/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.common.model.MutableProfile;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;

public class ThreadProfile {
    private final int maxSamples;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final List<List<StackTraceElement>> unmergedStackTraces = Lists.newArrayList();
    @GuardedBy(value="lock")
    private final List<Thread.State> unmergedStackTraceThreadStates = Lists.newArrayList();
    @GuardedBy(value="lock")
    private @MonotonicNonNull MutableProfile profile;
    @GuardedBy(value="lock")
    private long sampleCount;

    public ThreadProfile(int maxSamples) {
        this.maxSamples = maxSamples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeInto(MutableProfile profile) {
        Object object = this.lock;
        synchronized (object) {
            if (this.profile == null) {
                this.mergeTheUnmergedInto(profile);
            } else {
                profile.merge(this.profile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileOuterClass.Profile toProto() {
        Object object = this.lock;
        synchronized (object) {
            if (this.profile == null) {
                this.profile = new MutableProfile();
                this.mergeTheUnmergedInto(this.profile);
                this.unmergedStackTraces.clear();
                this.unmergedStackTraceThreadStates.clear();
            }
            return this.profile.toProto();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSampleCount() {
        Object object = this.lock;
        synchronized (object) {
            return Math.min(this.sampleCount, (long)this.maxSamples);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSampleLimitExceeded() {
        Object object = this.lock;
        synchronized (object) {
            return this.sampleCount > (long)this.maxSamples;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStackTrace(ThreadInfo threadInfo) {
        Object object = this.lock;
        synchronized (object) {
            if (++this.sampleCount > (long)this.maxSamples) {
                return;
            }
            List<StackTraceElement> stackTrace = Arrays.asList(threadInfo.getStackTrace());
            Thread.State threadState = threadInfo.getThreadState();
            if (this.profile == null) {
                this.unmergedStackTraces.add(stackTrace);
                this.unmergedStackTraceThreadStates.add(threadState);
                if (this.unmergedStackTraces.size() >= 10) {
                    this.profile = new MutableProfile();
                    this.mergeTheUnmergedInto(this.profile);
                    this.unmergedStackTraces.clear();
                    this.unmergedStackTraceThreadStates.clear();
                }
            } else {
                this.profile.merge(stackTrace, threadState);
            }
        }
    }

    @GuardedBy(value="lock")
    private void mergeTheUnmergedInto(MutableProfile profile) {
        for (int i = 0; i < this.unmergedStackTraces.size(); ++i) {
            List<StackTraceElement> stackTrace = this.unmergedStackTraces.get(i);
            Thread.State threadState = this.unmergedStackTraceThreadStates.get(i);
            profile.merge(stackTrace, threadState);
        }
    }
}

