/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.model.ImmutableErrorMessage;
import org.glowroot.agent.model.ImmutableStackTraceWithoutCommonFrames;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.glowroot.common.util.Throwables;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ErrorMessage {
    private static final int TRANSACTION_THROWABLE_FRAME_LIMIT = Integer.getInteger("glowroot.transaction.throwable.frame.limit", 100000);

    @Value.Parameter
    public abstract String message();

    @Value.Parameter
    public abstract  @Nullable Proto.Throwable throwable();

    public static ErrorMessage create(@Nullable String message, Throwable t, AtomicInteger transactionThrowableFrameCount) {
        if (t == null) {
            return ImmutableErrorMessage.of(Strings.nullToEmpty(message), null);
        }
        return ImmutableErrorMessage.of(Throwables.getBestMessage(t), ErrorMessage.buildThrowableInfo(t, null, transactionThrowableFrameCount, 0));
    }

    private static Proto.Throwable buildThrowableInfo(Throwable t, @Nullable List<StackTraceElement> causedStackTrace, AtomicInteger transactionThrowableFrameCount, int recursionDepth) {
        StackTraceElement[] stackTraceElements = MoreObjects.firstNonNull(t.getStackTrace(), new StackTraceElement[0]);
        StackTraceWithoutCommonFrames stackTraceWithoutCommonFrames = ErrorMessage.getStackTraceAndFramesInCommon(stackTraceElements, causedStackTrace, transactionThrowableFrameCount);
        transactionThrowableFrameCount.addAndGet(stackTraceWithoutCommonFrames.stackTrace().size());
        Proto.Throwable.Builder builder = Proto.Throwable.newBuilder().setClassName(t.getClass().getName());
        String message = t.getMessage();
        if (message != null) {
            builder.setMessage(message);
        }
        for (StackTraceElement element : stackTraceWithoutCommonFrames.stackTrace()) {
            builder.addStackTraceElement(ErrorMessage.toProto(element));
        }
        builder.setFramesInCommonWithEnclosing(stackTraceWithoutCommonFrames.framesInCommonWithEnclosing());
        Throwable cause = t.getCause();
        if (cause == null) {
            return builder.build();
        }
        if (transactionThrowableFrameCount.get() > TRANSACTION_THROWABLE_FRAME_LIMIT) {
            builder.setCause(Proto.Throwable.newBuilder().setMessage("Throwable frame capture limit exceeded").build());
        } else if (recursionDepth == 80) {
            builder.setCause(Proto.Throwable.newBuilder().setMessage("The rest of the causal chain for this exception has been truncated").build());
        } else {
            builder.setCause(ErrorMessage.buildThrowableInfo(cause, Arrays.asList(stackTraceElements), transactionThrowableFrameCount, recursionDepth + 1));
        }
        return builder.build();
    }

    public static Proto.StackTraceElement toProto(StackTraceElement ste) {
        String fileName;
        Proto.StackTraceElement.Builder builder = Proto.StackTraceElement.newBuilder().setClassName(ste.getClassName());
        String methodName = ste.getMethodName();
        if (methodName != null) {
            builder.setMethodName(methodName);
        }
        if ((fileName = ste.getFileName()) != null) {
            builder.setFileName(fileName);
        }
        return builder.setLineNumber(ste.getLineNumber()).build();
    }

    private static StackTraceWithoutCommonFrames getStackTraceAndFramesInCommon(StackTraceElement[] stackTraceElements, @Nullable List<StackTraceElement> causedStackTrace, AtomicInteger transactionThrowableFrameCount) {
        StackTraceElement causedElement;
        StackTraceElement element;
        if (transactionThrowableFrameCount.get() >= TRANSACTION_THROWABLE_FRAME_LIMIT) {
            return ImmutableStackTraceWithoutCommonFrames.builder().build();
        }
        if (causedStackTrace == null) {
            return ImmutableStackTraceWithoutCommonFrames.builder().addStackTrace(stackTraceElements).build();
        }
        List<StackTraceElement> stackTrace = ImmutableList.copyOf(stackTraceElements);
        int framesInCommonWithEnclosing = 0;
        ListIterator i = stackTrace.listIterator(stackTrace.size());
        ListIterator<StackTraceElement> j = causedStackTrace.listIterator(causedStackTrace.size());
        while (i.hasPrevious() && j.hasPrevious() && (element = (StackTraceElement)i.previous()).equals(causedElement = j.previous())) {
            ++framesInCommonWithEnclosing;
        }
        if (framesInCommonWithEnclosing > 0) {
            stackTrace = stackTrace.subList(0, stackTrace.size() - framesInCommonWithEnclosing);
        }
        return ImmutableStackTraceWithoutCommonFrames.builder().stackTrace(stackTrace).framesInCommonWithEnclosing(framesInCommonWithEnclosing).build();
    }

    @Value.Immutable
    static abstract class StackTraceWithoutCommonFrames {
        StackTraceWithoutCommonFrames() {
        }

        abstract List<StackTraceElement> stackTrace();

        @Value.Default
        public int framesInCommonWithEnclosing() {
            return 0;
        }
    }
}

