/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.live;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.management.ObjectName;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.live.JvmTool;
import org.glowroot.agent.shaded.com.google.common.io.ByteStreams;
import org.glowroot.agent.util.LazyPlatformMBeanServer;

class JStackTool {
    private JStackTool() {
    }

    static String run(LazyPlatformMBeanServer lazyPlatformMBeanServer) throws Exception {
        ObjectName objectName = ObjectName.getInstance("com.sun.management:type=DiagnosticCommand");
        return (String)lazyPlatformMBeanServer.invoke(objectName, "threadPrint", new Object[]{null}, new String[]{"[Ljava.lang.String;"});
    }

    static String runPriorToJava8(long pid, boolean allowAttachSelf, @Nullable File glowrootJarFile) throws Exception {
        return JvmTool.run(pid, "remoteDataDump", new JStackProcessor(), allowAttachSelf, glowrootJarFile);
    }

    private static class JStackProcessor
    implements JvmTool.InputStreamProcessor<String> {
        private JStackProcessor() {
        }

        @Override
        public String process(InputStream in) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteStreams.copy(in, baos);
            return new String(baos.toByteArray());
        }
    }
}

