/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.live;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.ObjectName;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.live.JvmTool;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.DownstreamServiceOuterClass;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.util.JavaVersion;
import org.glowroot.agent.util.LazyPlatformMBeanServer;

class HeapHistogramTool {
    private HeapHistogramTool() {
    }

    static DownstreamServiceOuterClass.HeapHistogram run(LazyPlatformMBeanServer lazyPlatformMBeanServer) throws Exception {
        ObjectName objectName = ObjectName.getInstance("com.sun.management:type=DiagnosticCommand");
        String result = (String)lazyPlatformMBeanServer.invoke(objectName, "gcClassHistogram", new Object[]{null}, new String[]{"[Ljava.lang.String;"});
        return HeapHistogramProcessor.process(new BufferedReader(new StringReader(result)));
    }

    static DownstreamServiceOuterClass.HeapHistogram runPriorToJava8(long pid, boolean allowAttachSelf, @Nullable File glowrootJarFile) throws Exception {
        return JvmTool.run(pid, "heapHisto", new HeapHistogramProcessor(), allowAttachSelf, glowrootJarFile);
    }

    private static class ClassInfo {
        private static final Ordering<ClassInfo> orderingByBytes = new Ordering<ClassInfo>(){

            @Override
            public int compare(ClassInfo left, ClassInfo right) {
                return Longs.compare(right.bytes, left.bytes);
            }
        };
        private final String className;
        private long bytes;
        private long count;

        private ClassInfo(String className) {
            this.className = className;
        }
    }

    private static class HeapHistogramProcessor
    implements JvmTool.InputStreamProcessor<DownstreamServiceOuterClass.HeapHistogram> {
        private HeapHistogramProcessor() {
        }

        @Override
        public DownstreamServiceOuterClass.HeapHistogram process(InputStream in) throws IOException {
            return HeapHistogramProcessor.process(new BufferedReader(new InputStreamReader(in)));
        }

        private static DownstreamServiceOuterClass.HeapHistogram process(BufferedReader in) throws IOException {
            boolean jrockit = JavaVersion.isJRockitJvm();
            String line = in.readLine();
            while (line != null && !line.contains("--------")) {
                line = in.readLine();
            }
            if (line == null) {
                throw new IOException("Unexpected heapHisto output");
            }
            HashMap<String, ClassInfo> classInfos = Maps.newHashMap();
            Splitter splitter = Splitter.on(' ').omitEmptyStrings();
            while ((line = in.readLine()) != null && !line.startsWith("Total ") && !line.endsWith(" total ---")) {
                ClassInfo classInfo;
                String className;
                long count;
                long bytes;
                Iterator<String> parts = splitter.split(line).iterator();
                parts.next();
                if (jrockit) {
                    String bytesStr = parts.next();
                    bytes = 1024L * Long.parseLong(bytesStr.substring(0, bytesStr.length() - 1));
                    count = Long.parseLong(parts.next());
                    parts.next();
                } else {
                    count = Long.parseLong(parts.next());
                    bytes = Long.parseLong(parts.next());
                }
                if ((className = parts.next()).charAt(0) == '<') continue;
                if (className.charAt(0) == '[') {
                    className = Type.getType(className).getClassName();
                }
                if ((classInfo = (ClassInfo)classInfos.get(className)) == null) {
                    classInfo = new ClassInfo(className);
                    classInfos.put(className, classInfo);
                }
                classInfo.bytes += bytes;
                classInfo.count += count;
            }
            DownstreamServiceOuterClass.HeapHistogram.Builder builder = DownstreamServiceOuterClass.HeapHistogram.newBuilder();
            for (ClassInfo classInfo : ClassInfo.orderingByBytes.sortedCopy(classInfos.values())) {
                builder.addClassInfo(DownstreamServiceOuterClass.HeapHistogram.ClassInfo.newBuilder().setClassName(classInfo.className).setBytes(classInfo.bytes).setCount(classInfo.count));
            }
            return builder.build();
        }
    }
}

