/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.init;

import org.glowroot.agent.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.glowroot.agent.shaded.io.netty.util.internal.PlatformDependent;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.JavaVersion;

public class NettyInit {
    private static final Logger logger = LoggerFactory.getLogger(NettyInit.class);

    private NettyInit() {
    }

    public static void run() {
        String prior;
        if (JavaVersion.isJ9Jvm()) {
            prior = System.getProperty("org.glowroot.agent.shaded.io.netty.noUnsafe");
            System.setProperty("org.glowroot.agent.shaded.io.netty.noUnsafe", "true");
            try {
                if (PlatformDependent.hasUnsafe()) {
                    throw new IllegalStateException("Netty property to disable usage of UNSAFE was not set early enough, please report to the Glowroot project");
                }
            }
            finally {
                if (prior == null) {
                    System.clearProperty("org.glowroot.agent.shaded.io.netty.noUnsafe");
                } else {
                    System.setProperty("org.glowroot.agent.shaded.io.netty.noUnsafe", prior);
                }
            }
        }
        if ((prior = System.getProperty("org.glowroot.agent.shaded.io.netty.allocator.maxOrder")) == null || prior.isEmpty()) {
            System.setProperty("org.glowroot.agent.shaded.io.netty.allocator.maxOrder", "10");
            try {
                if (PooledByteBufAllocator.defaultMaxOrder() != 10 && NettyInit.isShaded()) {
                    logger.warn("Netty property to reduce the default pool chunk size was not set early enough, please report to the Glowroot project");
                }
            }
            finally {
                if (prior == null) {
                    System.clearProperty("org.glowroot.agent.shaded.io.netty.allocator.maxOrder");
                } else {
                    System.setProperty("org.glowroot.agent.shaded.io.netty.allocator.maxOrder", prior);
                }
            }
        }
    }

    private static boolean isShaded() {
        try {
            Class.forName("org.glowroot.agent.shaded.org.slf4j.Logger");
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.trace(e.getMessage(), e);
            return false;
        }
    }
}

