/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.bytecode.api.ThreadContextThreadLocal;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.impl.ThreadContextImpl;
import org.glowroot.agent.impl.TimerNameCache;
import org.glowroot.agent.impl.TraceEntryImpl;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.impl.TransactionProcessor;
import org.glowroot.agent.impl.TransactionRegistry;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.config.ConfigListener;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.Queues;
import org.glowroot.agent.shaded.org.glowroot.common.config.AdvancedConfig;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.IterableWithSelfRemovableEntries;
import org.glowroot.agent.util.ThreadAllocatedBytes;

public class TransactionService
implements ConfigListener {
    private static final Logger logger = LoggerFactory.getLogger(TransactionService.class);
    private final TransactionRegistry transactionRegistry;
    private final ConfigService configService;
    private final TimerNameCache timerNameCache;
    private final Clock clock;
    private final Ticker ticker;
    private final TransactionCompletionCallback transactionCompletionCallback = new TransactionCompletionCallback();
    private boolean captureThreadStats;
    private int maxTraceEntries;
    private int maxQueryAggregates;
    private int maxServiceCallAggregates;
    private int maxProfileSamples;
    private @MonotonicNonNull TransactionProcessor transactionProcessor;
    private @Nullable ThreadAllocatedBytes threadAllocatedBytes;

    public static TransactionService create(TransactionRegistry transactionRegistry, ConfigService configService, TimerNameCache timerNameCache, Ticker ticker, Clock clock) {
        TransactionService transactionService = new TransactionService(transactionRegistry, configService, timerNameCache, ticker, clock);
        configService.addConfigListener(transactionService);
        return transactionService;
    }

    private TransactionService(TransactionRegistry transactionRegistry, ConfigService configService, TimerNameCache timerNameCache, Ticker ticker, Clock clock) {
        this.transactionRegistry = transactionRegistry;
        this.configService = configService;
        this.timerNameCache = timerNameCache;
        this.clock = clock;
        this.ticker = ticker;
    }

    public void setTransactionProcessor(TransactionProcessor transactionProcessor) {
        this.transactionProcessor = transactionProcessor;
        this.transactionCompletionCallback.processStartupTransaction(transactionProcessor);
    }

    public void setThreadAllocatedBytes(@Nullable ThreadAllocatedBytes threadAllocatedBytes) {
        this.threadAllocatedBytes = threadAllocatedBytes;
    }

    TraceEntryImpl startTransaction(String transactionType, String transactionName, MessageSupplier messageSupplier, TimerName timerName, ThreadContextThreadLocal.Holder threadContextHolder, int rootNestingGroupId, int rootSuppressionKeyId) {
        this.configService.readMemoryBarrier();
        long startTick = this.ticker.read();
        Transaction transaction = new Transaction(this.clock.currentTimeMillis(), startTick, transactionType, transactionName, messageSupplier, timerName, this.captureThreadStats, this.maxTraceEntries, this.maxQueryAggregates, this.maxServiceCallAggregates, this.maxProfileSamples, this.threadAllocatedBytes, this.transactionCompletionCallback, this.ticker, this.transactionRegistry, this, this.configService, threadContextHolder, rootNestingGroupId, rootSuppressionKeyId);
        IterableWithSelfRemovableEntries.SelfRemovableEntry transactionEntry = this.transactionRegistry.addTransaction(transaction);
        transaction.setTransactionEntry(transactionEntry);
        threadContextHolder.set(transaction.getMainThreadContext());
        return transaction.getMainThreadContext().getRootEntry();
    }

    @Nullable ThreadContextImpl startAuxThreadContextInternal(Transaction transaction, @Nullable TraceEntryImpl parentTraceEntry, @Nullable TraceEntryImpl parentThreadContextPriorEntry,  @Nullable ThreadContext.ServletRequestInfo servletRequestInfo, ThreadContextThreadLocal.Holder threadContextHolder) {
        long startTick = this.ticker.read();
        TimerName auxThreadTimerName = this.timerNameCache.getAuxThreadTimerName();
        return transaction.startAuxThreadContext(parentTraceEntry, parentThreadContextPriorEntry, auxThreadTimerName, startTick, threadContextHolder, servletRequestInfo, this.threadAllocatedBytes);
    }

    @Override
    public void onChange() {
        AdvancedConfig advancedConfig = this.configService.getAdvancedConfig();
        this.captureThreadStats = this.configService.getTransactionConfig().captureThreadStats();
        this.maxQueryAggregates = advancedConfig.maxQueryAggregates();
        this.maxServiceCallAggregates = advancedConfig.maxServiceCallAggregates();
        this.maxTraceEntries = advancedConfig.maxTraceEntriesPerTransaction();
        this.maxProfileSamples = advancedConfig.maxProfileSamplesPerTransaction();
    }

    private class TransactionCompletionCallback
    implements Transaction.CompletionCallback {
        private final ConcurrentLinkedQueue<Transaction> startupTransactions = Queues.newConcurrentLinkedQueue();

        private TransactionCompletionCallback() {
        }

        @Override
        public void completed(Transaction transaction) {
            if (TransactionService.this.transactionProcessor == null) {
                if (this.startupTransactions.size() < 100) {
                    this.startupTransactions.add(transaction);
                } else {
                    logger.warn("not processing startup transaction because already 100 pending");
                }
            } else {
                TransactionService.this.transactionProcessor.processOnCompletion(transaction);
            }
        }

        private void processStartupTransaction(TransactionProcessor transactionProcessor) {
            for (Transaction startupTransaction : this.startupTransactions) {
                transactionProcessor.processOnCompletion(startupTransaction);
            }
        }
    }
}

