/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.impl.ImmutablePendingTrace;
import org.glowroot.agent.impl.ImmutableSlowThresholdOverridesForType;
import org.glowroot.agent.impl.ImmutableSlowThresholdOverridesForUser;
import org.glowroot.agent.impl.TraceCreator;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.plugin.api.config.ConfigListener;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Queues;
import org.glowroot.agent.shaded.org.glowroot.common.config.TransactionConfig;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.RateLimitedLogger;
import org.glowroot.agent.util.ThreadFactories;
import org.immutables.value.Value;

public class TraceCollector {
    private static final Logger logger = LoggerFactory.getLogger(TraceCollector.class);
    private static final int PENDING_LIMIT = 50;
    private final ExecutorService dedicatedExecutor;
    private final Collector collector;
    private final Clock clock;
    private final Ticker ticker;
    private final BlockingQueue<PendingTrace> pendingTraces = Queues.newLinkedBlockingQueue(150);
    private final AtomicInteger normalCompletePendingCount = new AtomicInteger();
    private final AtomicInteger partialCompletePendingCount = new AtomicInteger();
    private final AtomicInteger partialIncompletePendingCount = new AtomicInteger();
    private final RateLimitedLogger backPressureLogger = new RateLimitedLogger(TraceCollector.class);
    private Map<String, SlowThresholdOverridesForType> slowThresholdOverrides = ImmutableMap.of();
    private long defaultSlowThresholdNanos;
    private volatile boolean closed;

    public TraceCollector(ConfigService configService, Collector collector, Clock clock, Ticker ticker) {
        this.collector = collector;
        this.clock = clock;
        this.ticker = ticker;
        this.dedicatedExecutor = Executors.newFixedThreadPool(1, ThreadFactories.create("Glowroot-Trace-Collector"));
        this.dedicatedExecutor.execute(new TraceCollectorLoop());
        configService.addConfigListener(new UpdateLocalConfig(configService));
    }

    public boolean shouldStoreSlow(Transaction transaction) {
        SlowThresholdOverridesForType slowThresholdOverrideForType;
        if (transaction.isPartiallyStored()) {
            return true;
        }
        long durationNanos = transaction.getDurationNanos();
        long slowThresholdMillis = transaction.getSlowThresholdMillisOverride();
        if (slowThresholdMillis != -1L) {
            return durationNanos >= TimeUnit.MILLISECONDS.toNanos(slowThresholdMillis);
        }
        if (!this.slowThresholdOverrides.isEmpty() && (slowThresholdOverrideForType = this.slowThresholdOverrides.get(transaction.getTransactionType())) != null) {
            Long slowThresholdNanos;
            String userLowerCase;
            SlowThresholdOverridesForUser slowThresholdOverridesForUser;
            String transactionName = transaction.getTransactionName();
            String user = transaction.getUser();
            Map<String, SlowThresholdOverridesForUser> userThresholds = slowThresholdOverrideForType.userThresholds();
            if (!userThresholds.isEmpty() && !user.isEmpty() && (slowThresholdOverridesForUser = userThresholds.get(userLowerCase = user.toLowerCase(Locale.ENGLISH))) != null && (slowThresholdNanos = TraceCollector.getSlowThreshold(slowThresholdOverridesForUser, transactionName)) != null) {
                return durationNanos >= slowThresholdNanos;
            }
            Long slowThresholdNanos2 = TraceCollector.getSlowThreshold(slowThresholdOverrideForType, transactionName);
            if (slowThresholdNanos2 != null) {
                return durationNanos >= slowThresholdNanos2;
            }
            slowThresholdNanos2 = slowThresholdOverrideForType.defaultThresholdNanos();
            if (slowThresholdNanos2 != null) {
                return durationNanos >= slowThresholdNanos2;
            }
        }
        return durationNanos >= this.defaultSlowThresholdNanos;
    }

    public boolean shouldStoreError(Transaction transaction) {
        return transaction.getErrorMessage() != null;
    }

    public Collection<Transaction> getPendingTransactions() {
        ArrayList<Transaction> pendingTransactions = Lists.newArrayList();
        for (PendingTrace pendingTrace : this.pendingTraces) {
            pendingTransactions.add(pendingTrace.transaction());
        }
        return pendingTransactions;
    }

    @OnlyUsedByTests
    public void close() throws InterruptedException {
        this.closed = true;
        this.dedicatedExecutor.shutdownNow();
        if (!this.dedicatedExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Could not terminate executor");
        }
    }

    void collectTrace(Transaction transaction) {
        boolean slow = this.shouldStoreSlow(transaction);
        if (!slow && !this.shouldStoreError(transaction)) {
            return;
        }
        if (transaction.isPartiallyStored() && this.partialCompletePendingCount.get() >= 50) {
            this.backPressureLogger.warn("not storing a completed (and once partial) trace because of an excessive backlog of {} completed (and once partial) traces already waiting to be stored", 50);
            return;
        }
        if (!transaction.isPartiallyStored() && this.normalCompletePendingCount.get() >= 50) {
            this.backPressureLogger.warn("not storing a completed trace because of an excessive backlog of {} completed traces already waiting to be stored", 50);
            return;
        }
        ImmutablePendingTrace pendingTransaction = ImmutablePendingTrace.builder().transaction(transaction).slow(slow).partial(false).build();
        if (!this.pendingTraces.offer(pendingTransaction)) {
            this.backPressureLogger.warn("not storing a trace because of an excessive backlog of {} traces already waiting to be stored", 150);
        }
    }

    public void storePartialTrace(Transaction transaction) {
        if (this.partialIncompletePendingCount.get() >= 50) {
            this.backPressureLogger.warn("not storing a partial trace because of an excessive backlog of {} partial traces already waiting to be stored", 50);
            return;
        }
        ImmutablePendingTrace pendingTransaction = ImmutablePendingTrace.builder().transaction(transaction).slow(false).partial(true).build();
        if (!this.pendingTraces.offer(pendingTransaction)) {
            this.backPressureLogger.warn("not storing a trace because of an excessive backlog of {} traces already waiting to be stored", 150);
        }
    }

    private static @Nullable Long getSlowThreshold(SlowThresholdOverridesForType slowThresholdOverridesForType, String transactionName) {
        Long slowThreshold = slowThresholdOverridesForType.thresholdNanos().get(transactionName);
        return slowThreshold == null ? slowThresholdOverridesForType.defaultThresholdNanos() : slowThreshold;
    }

    private static @Nullable Long getSlowThreshold(SlowThresholdOverridesForUser slowThresholdOverridesForUser, String transactionName) {
        Long slowThreshold = slowThresholdOverridesForUser.thresholdNanos().get(transactionName);
        return slowThreshold == null ? slowThresholdOverridesForUser.defaultThresholdNanos() : slowThreshold;
    }

    private static class SlowThresholdOverridesForUserBuilder {
        private @Nullable Long defaultThresholdNanos;
        private Map<String, Long> thresholdNanos = Maps.newHashMap();

        private SlowThresholdOverridesForUserBuilder() {
        }

        private SlowThresholdOverridesForUser toImmutable() {
            return ImmutableSlowThresholdOverridesForUser.builder().defaultThresholdNanos(this.defaultThresholdNanos).putAllThresholdNanos(this.thresholdNanos).build();
        }
    }

    private static class SlowThresholdOverridesForTypeBuilder {
        private @Nullable Long defaultThresholdNanos;
        private Map<String, SlowThresholdOverridesForUserBuilder> userThresholdNanos = Maps.newHashMap();
        private Map<String, Long> thresholdNanos = Maps.newHashMap();

        private SlowThresholdOverridesForTypeBuilder() {
        }

        private SlowThresholdOverridesForType toImmutable() {
            ImmutableSlowThresholdOverridesForType.Builder builder = ImmutableSlowThresholdOverridesForType.builder().defaultThresholdNanos(this.defaultThresholdNanos);
            for (Map.Entry<String, SlowThresholdOverridesForUserBuilder> entry : this.userThresholdNanos.entrySet()) {
                builder.putUserThresholds(entry.getKey(), entry.getValue().toImmutable());
            }
            return builder.putAllThresholdNanos(this.thresholdNanos).build();
        }
    }

    @Value.Immutable
    static interface SlowThresholdOverridesForUser {
        public @Nullable Long defaultThresholdNanos();

        public Map<String, Long> thresholdNanos();
    }

    @Value.Immutable
    static interface SlowThresholdOverridesForType {
        public @Nullable Long defaultThresholdNanos();

        public Map<String, Long> thresholdNanos();

        public Map<String, SlowThresholdOverridesForUser> userThresholds();
    }

    @Value.Immutable
    public static interface PendingTrace {
        public Transaction transaction();

        public boolean slow();

        public boolean partial();
    }

    private class TraceCollectorLoop
    implements Runnable {
        private TraceCollectorLoop() {
        }

        @Override
        public void run() {
            while (!TraceCollector.this.closed) {
                try {
                    PendingTrace pendingTrace = (PendingTrace)TraceCollector.this.pendingTraces.take();
                    if (pendingTrace.partial()) {
                        this.collectPartial(pendingTrace.transaction());
                        continue;
                    }
                    this.collectCompleted(pendingTrace.transaction(), pendingTrace.slow());
                }
                catch (InterruptedException e) {
                    logger.debug(e.getMessage(), e);
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }

        private void collectPartial(Transaction transaction) throws Exception {
            Collector.TraceReader traceReader = TraceCreator.createTraceReaderForPartial(transaction, TraceCollector.this.clock.currentTimeMillis(), TraceCollector.this.ticker.read());
            if (!transaction.isCompleted()) {
                transaction.setPartiallyStored();
                TraceCollector.this.collector.collectTrace(traceReader);
            }
        }

        private void collectCompleted(Transaction transaction, boolean slow) throws Exception {
            Collector.TraceReader traceReader = TraceCreator.createTraceReaderForCompleted(transaction, slow);
            TraceCollector.this.collector.collectTrace(traceReader);
        }
    }

    private class UpdateLocalConfig
    implements ConfigListener {
        private final ConfigService configService;

        private UpdateLocalConfig(ConfigService configService) {
            this.configService = configService;
        }

        @Override
        public void onChange() {
            TransactionConfig transactionConfig = this.configService.getTransactionConfig();
            HashMap<String, SlowThresholdOverridesForTypeBuilder> slowThresholdOverrides = Maps.newHashMap();
            for (TransactionConfig.SlowThresholdOverride slowThresholdOverride : transactionConfig.slowThresholdOverrides()) {
                String transactionType = slowThresholdOverride.transactionType();
                SlowThresholdOverridesForTypeBuilder slowThresholdOverrideForType = (SlowThresholdOverridesForTypeBuilder)slowThresholdOverrides.get(transactionType);
                if (slowThresholdOverrideForType == null) {
                    slowThresholdOverrideForType = new SlowThresholdOverridesForTypeBuilder();
                    slowThresholdOverrides.put(transactionType, slowThresholdOverrideForType);
                }
                String transactionName = slowThresholdOverride.transactionName();
                String user = slowThresholdOverride.user();
                long thresholdNanos = TimeUnit.MILLISECONDS.toNanos(slowThresholdOverride.thresholdMillis());
                if (user.isEmpty()) {
                    if (transactionName.isEmpty()) {
                        slowThresholdOverrideForType.defaultThresholdNanos = thresholdNanos;
                        continue;
                    }
                    slowThresholdOverrideForType.thresholdNanos.put(transactionName, thresholdNanos);
                    continue;
                }
                String userLowerCase = user.toLowerCase(Locale.ENGLISH);
                SlowThresholdOverridesForUserBuilder slowThresholdOverridesForUserBuilder = (SlowThresholdOverridesForUserBuilder)slowThresholdOverrideForType.userThresholdNanos.get(userLowerCase);
                if (slowThresholdOverridesForUserBuilder == null) {
                    slowThresholdOverridesForUserBuilder = new SlowThresholdOverridesForUserBuilder();
                    slowThresholdOverrideForType.userThresholdNanos.put(userLowerCase, slowThresholdOverridesForUserBuilder);
                }
                if (transactionName.isEmpty()) {
                    slowThresholdOverridesForUserBuilder.defaultThresholdNanos = thresholdNanos;
                    continue;
                }
                slowThresholdOverridesForUserBuilder.thresholdNanos.put(transactionName, thresholdNanos);
            }
            HashMap<String, SlowThresholdOverridesForType> builder = Maps.newHashMap();
            for (Map.Entry entry : slowThresholdOverrides.entrySet()) {
                builder.put((String)entry.getKey(), ((SlowThresholdOverridesForTypeBuilder)entry.getValue()).toImmutable());
            }
            TraceCollector.this.slowThresholdOverrides = ImmutableMap.copyOf(builder);
            TraceCollector.this.defaultSlowThresholdNanos = TimeUnit.MILLISECONDS.toNanos(transactionConfig.slowThresholdMillis());
        }
    }
}

