/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.bytecode.api.ThreadContextPlus;
import org.glowroot.agent.bytecode.api.ThreadContextThreadLocal;
import org.glowroot.agent.impl.NopTransactionService;
import org.glowroot.agent.impl.TraceEntryImpl;
import org.glowroot.agent.impl.TransactionService;
import org.glowroot.agent.plugin.api.AsyncQueryEntry;
import org.glowroot.agent.plugin.api.AsyncTraceEntry;
import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.OptionalThreadContext;
import org.glowroot.agent.plugin.api.QueryEntry;
import org.glowroot.agent.plugin.api.QueryMessageSupplier;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

class OptionalThreadContextImpl
implements ThreadContextPlus {
    private static final Logger logger = LoggerFactory.getLogger(OptionalThreadContextImpl.class);
    private int rootNestingGroupId;
    private int rootSuppressionKeyId;
    private @MonotonicNonNull ThreadContextPlus threadContext;
    private final TransactionService transactionService;
    private final ThreadContextThreadLocal.Holder threadContextHolder;

    static OptionalThreadContextImpl create(TransactionService transactionService, ThreadContextThreadLocal.Holder threadContextHolder, int rootNestingGroupId, int rootSuppressionKeyId) {
        return new OptionalThreadContextImpl(transactionService, threadContextHolder, rootNestingGroupId, rootSuppressionKeyId);
    }

    private OptionalThreadContextImpl(TransactionService transactionService, ThreadContextThreadLocal.Holder threadContextHolder, int rootNestingGroupId, int rootSuppressionKeyId) {
        this.transactionService = transactionService;
        this.threadContextHolder = threadContextHolder;
        this.rootNestingGroupId = rootNestingGroupId;
        this.rootSuppressionKeyId = rootSuppressionKeyId;
    }

    @Override
    public boolean isInTransaction() {
        return this.threadContext != null;
    }

    @Override
    public TraceEntry startTransaction(String transactionType, String transactionName, MessageSupplier messageSupplier, TimerName timerName) {
        return this.startTransaction(transactionType, transactionName, messageSupplier, timerName, OptionalThreadContext.AlreadyInTransactionBehavior.CAPTURE_TRACE_ENTRY);
    }

    @Override
    public TraceEntry startTransaction(String transactionType, String transactionName, MessageSupplier messageSupplier, TimerName timerName, OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehavior) {
        if (transactionType == null) {
            logger.error("startTransaction(): argument 'transactionType' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        if (transactionName == null) {
            logger.error("startTransaction(): argument 'transactionName' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        if (messageSupplier == null) {
            logger.error("startTransaction(): argument 'messageSupplier' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        if (timerName == null) {
            logger.error("startTransaction(): argument 'timerName' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        if (this.threadContext == null) {
            TraceEntryImpl traceEntry = this.transactionService.startTransaction(transactionType, transactionName, messageSupplier, timerName, this.threadContextHolder, this.rootNestingGroupId, this.rootSuppressionKeyId);
            this.threadContext = Preconditions.checkNotNull(this.threadContextHolder.get());
            return traceEntry;
        }
        return this.threadContext.startTransaction(transactionType, transactionName, messageSupplier, timerName, alreadyInTransactionBehavior);
    }

    @Override
    public TraceEntry startTraceEntry(MessageSupplier messageSupplier, TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.TRACE_ENTRY;
        }
        return this.threadContext.startTraceEntry(messageSupplier, timerName);
    }

    @Override
    public AsyncTraceEntry startAsyncTraceEntry(MessageSupplier messageSupplier, TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.ASYNC_QUERY_ENTRY;
        }
        return this.threadContext.startAsyncTraceEntry(messageSupplier, timerName);
    }

    @Override
    public QueryEntry startQueryEntry(String queryType, String queryText, QueryMessageSupplier queryMessageSupplier, TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.QUERY_ENTRY;
        }
        return this.threadContext.startQueryEntry(queryType, queryText, queryMessageSupplier, timerName);
    }

    @Override
    public QueryEntry startQueryEntry(String queryType, String queryText, long queryExecutionCount, QueryMessageSupplier queryMessageSupplier, TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.QUERY_ENTRY;
        }
        return this.threadContext.startQueryEntry(queryType, queryText, queryExecutionCount, queryMessageSupplier, timerName);
    }

    @Override
    public AsyncQueryEntry startAsyncQueryEntry(String queryType, String queryText, QueryMessageSupplier queryMessageSupplier, TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.ASYNC_QUERY_ENTRY;
        }
        return this.threadContext.startAsyncQueryEntry(queryType, queryText, queryMessageSupplier, timerName);
    }

    @Override
    public TraceEntry startServiceCallEntry(String serviceCallType, String serviceCallText, MessageSupplier messageSupplier, TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.TRACE_ENTRY;
        }
        return this.threadContext.startServiceCallEntry(serviceCallType, serviceCallText, messageSupplier, timerName);
    }

    @Override
    public AsyncTraceEntry startAsyncServiceCallEntry(String serviceCallType, String serviceCallText, MessageSupplier messageSupplier, TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.ASYNC_TRACE_ENTRY;
        }
        return this.threadContext.startAsyncServiceCallEntry(serviceCallType, serviceCallText, messageSupplier, timerName);
    }

    @Override
    public Timer startTimer(TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.NopTimer.INSTANCE;
        }
        return this.threadContext.startTimer(timerName);
    }

    @Override
    public AuxThreadContext createAuxThreadContext() {
        if (this.threadContext == null) {
            return NopTransactionService.NopAuxThreadContext.INSTANCE;
        }
        return this.threadContext.createAuxThreadContext();
    }

    @Override
    public void setTransactionAsync() {
        if (this.threadContext != null) {
            this.threadContext.setTransactionAsync();
        }
    }

    @Override
    public void setTransactionAsyncComplete() {
        if (this.threadContext != null) {
            this.threadContext.setTransactionAsyncComplete();
        }
    }

    @Override
    public void setTransactionOuter() {
        if (this.threadContext != null) {
            this.threadContext.setTransactionOuter();
        }
    }

    @Override
    public void setTransactionType(@Nullable String transactionType, int priority) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionType(transactionType, priority);
        }
    }

    @Override
    public void setTransactionName(@Nullable String transactionName, int priority) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionName(transactionName, priority);
        }
    }

    @Override
    public void setTransactionUser(@Nullable String user, int priority) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionUser(user, priority);
        }
    }

    @Override
    public void addTransactionAttribute(String name, @Nullable String value) {
        if (this.threadContext != null) {
            this.threadContext.addTransactionAttribute(name, value);
        }
    }

    @Override
    public void setTransactionSlowThreshold(long threshold, TimeUnit unit, int priority) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionSlowThreshold(threshold, unit, priority);
        }
    }

    @Override
    public void setTransactionError(Throwable t) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionError(t);
        }
    }

    @Override
    public void setTransactionError(@Nullable String message) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionError(message);
        }
    }

    @Override
    public void setTransactionError(@Nullable String message, @Nullable Throwable t) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionError(message, t);
        }
    }

    @Override
    public void addErrorEntry(Throwable t) {
        if (this.threadContext != null) {
            this.threadContext.addErrorEntry(t);
        }
    }

    @Override
    public void addErrorEntry(@Nullable String message) {
        if (this.threadContext != null) {
            this.threadContext.addErrorEntry(message);
        }
    }

    @Override
    public void addErrorEntry(@Nullable String message, Throwable t) {
        if (this.threadContext != null) {
            this.threadContext.addErrorEntry(message, t);
        }
    }

    @Override
    public void trackResourceAcquired(Object resource, boolean withLocationStackTrace) {
        if (this.threadContext != null) {
            this.threadContext.trackResourceAcquired(resource, withLocationStackTrace);
        }
    }

    @Override
    public void trackResourceReleased(Object resource) {
        if (this.threadContext != null) {
            this.threadContext.trackResourceReleased(resource);
        }
    }

    @Override
    public  @Nullable ThreadContext.ServletRequestInfo getServletRequestInfo() {
        if (this.threadContext != null) {
            return this.threadContext.getServletRequestInfo();
        }
        return null;
    }

    @Override
    public void setServletRequestInfo( @Nullable ThreadContext.ServletRequestInfo servletRequestInfo) {
        if (this.threadContext != null) {
            this.threadContext.setServletRequestInfo(servletRequestInfo);
        }
    }

    @Override
    public int getCurrentNestingGroupId() {
        if (this.threadContext == null) {
            return 0;
        }
        return this.threadContext.getCurrentNestingGroupId();
    }

    @Override
    public void setCurrentNestingGroupId(int nestingGroupId) {
        if (this.threadContext == null) {
            this.rootNestingGroupId = nestingGroupId;
        } else {
            this.threadContext.setCurrentNestingGroupId(nestingGroupId);
        }
    }

    @Override
    public int getCurrentSuppressionKeyId() {
        if (this.threadContext == null) {
            return 0;
        }
        return this.threadContext.getCurrentSuppressionKeyId();
    }

    @Override
    public void setCurrentSuppressionKeyId(int suppressionKeyId) {
        if (this.threadContext == null) {
            this.rootSuppressionKeyId = suppressionKeyId;
        } else {
            this.threadContext.setCurrentSuppressionKeyId(suppressionKeyId);
        }
    }
}

