/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.impl.AggregateCollector;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.model.SharedQueryTextCollection;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.glowroot.common.model.LazyHistogram;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallErrorSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ProfileCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.QueryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ServiceCallCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameErrorSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.util.CaptureTimes;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;

public class AggregateIntervalCollector {
    private static final String LIMIT_EXCEEDED_BUCKET = "LIMIT EXCEEDED BUCKET";
    private final long captureTime;
    private final int maxTransactionAggregates;
    private final int maxQueryAggregates;
    private final int maxServiceCallAggregates;
    private final Clock clock;
    private final ConcurrentMap<String, IntervalTypeCollector> typeCollectors = Maps.newConcurrentMap();

    AggregateIntervalCollector(long currentTime, long aggregateIntervalMillis, int maxTransactionAggregates, int maxQueryAggregates, int maxServiceCallAggregates, Clock clock) {
        this.captureTime = CaptureTimes.getRollup(currentTime, aggregateIntervalMillis);
        this.maxTransactionAggregates = maxTransactionAggregates;
        this.maxQueryAggregates = maxQueryAggregates;
        this.maxServiceCallAggregates = maxServiceCallAggregates;
        this.clock = clock;
    }

    public long getCaptureTime() {
        return this.captureTime;
    }

    public void add(Transaction transaction) {
        IntervalTypeCollector typeCollector = (IntervalTypeCollector)this.typeCollectors.get(transaction.getTransactionType());
        if (typeCollector == null) {
            typeCollector = new IntervalTypeCollector();
            this.typeCollectors.put(transaction.getTransactionType(), typeCollector);
        }
        typeCollector.add(transaction);
    }

    public void mergeOverallSummaryInto(OverallSummaryCollector collector, String transactionType) {
        IntervalTypeCollector typeCollector = (IntervalTypeCollector)this.typeCollectors.get(transactionType);
        if (typeCollector == null) {
            return;
        }
        typeCollector.overallAggregateCollector.mergeOverallSummaryInto(collector);
    }

    public void mergeTransactionNameSummariesInto(TransactionNameSummaryCollector collector, String transactionType) {
        IntervalTypeCollector typeCollector = (IntervalTypeCollector)this.typeCollectors.get(transactionType);
        if (typeCollector == null) {
            return;
        }
        for (AggregateCollector aggregateCollector : typeCollector.transactionAggregateCollectors.values()) {
            aggregateCollector.mergeTransactionNameSummariesInto(collector);
        }
    }

    public void mergeOverallErrorSummaryInto(OverallErrorSummaryCollector collector, String transactionType) {
        IntervalTypeCollector typeCollector = (IntervalTypeCollector)this.typeCollectors.get(transactionType);
        if (typeCollector == null) {
            return;
        }
        typeCollector.overallAggregateCollector.mergeOverallErrorSummaryInto(collector);
    }

    public void mergeTransactionNameErrorSummariesInto(TransactionNameErrorSummaryCollector collector, String transactionType) {
        IntervalTypeCollector typeCollector = (IntervalTypeCollector)this.typeCollectors.get(transactionType);
        if (typeCollector == null) {
            return;
        }
        for (AggregateCollector aggregateCollector : typeCollector.transactionAggregateCollectors.values()) {
            aggregateCollector.mergeTransactionNameErrorSummariesInto(collector);
        }
    }

    public  @Nullable LiveAggregateRepository.OverviewAggregate getOverviewAggregate(String transactionType, @Nullable String transactionName) {
        AggregateCollector aggregateCollector = this.getAggregateCollector(transactionType, transactionName);
        if (aggregateCollector == null) {
            return null;
        }
        long liveCaptureTime = Math.min(this.captureTime, this.clock.currentTimeMillis());
        return aggregateCollector.getOverviewAggregate(liveCaptureTime);
    }

    public  @Nullable LiveAggregateRepository.PercentileAggregate getPercentileAggregate(String transactionType, @Nullable String transactionName) {
        AggregateCollector aggregateCollector = this.getAggregateCollector(transactionType, transactionName);
        if (aggregateCollector == null) {
            return null;
        }
        long liveCaptureTime = Math.min(this.captureTime, this.clock.currentTimeMillis());
        return aggregateCollector.getPercentileAggregate(liveCaptureTime);
    }

    public  @Nullable LiveAggregateRepository.ThroughputAggregate getThroughputAggregate(String transactionType, @Nullable String transactionName) {
        AggregateCollector aggregateCollector = this.getAggregateCollector(transactionType, transactionName);
        if (aggregateCollector == null) {
            return null;
        }
        long liveCaptureTime = Math.min(this.captureTime, this.clock.currentTimeMillis());
        return aggregateCollector.getThroughputAggregate(liveCaptureTime);
    }

    public @Nullable String getFullQueryText(String fullQueryTextSha1) {
        for (IntervalTypeCollector typeCollector : this.typeCollectors.values()) {
            String fullQueryText = typeCollector.getFullQueryText(fullQueryTextSha1);
            if (fullQueryText == null) continue;
            return fullQueryText;
        }
        return null;
    }

    public void mergeQueriesInto(QueryCollector collector, String transactionType, @Nullable String transactionName) {
        AggregateCollector aggregateCollector = this.getAggregateCollector(transactionType, transactionName);
        if (aggregateCollector == null) {
            return;
        }
        aggregateCollector.mergeQueriesInto(collector);
    }

    public void mergeServiceCallsInto(ServiceCallCollector collector, String transactionType, @Nullable String transactionName) {
        AggregateCollector aggregateCollector = this.getAggregateCollector(transactionType, transactionName);
        if (aggregateCollector == null) {
            return;
        }
        aggregateCollector.mergeServiceCallsInto(collector);
    }

    public void mergeMainThreadProfilesInto(ProfileCollector collector, String transactionType, @Nullable String transactionName) {
        AggregateCollector aggregateCollector = this.getAggregateCollector(transactionType, transactionName);
        if (aggregateCollector == null) {
            return;
        }
        aggregateCollector.mergeMainThreadProfilesInto(collector);
    }

    public void mergeAuxThreadProfilesInto(ProfileCollector collector, String transactionType, @Nullable String transactionName) {
        AggregateCollector aggregateCollector = this.getAggregateCollector(transactionType, transactionName);
        if (aggregateCollector == null) {
            return;
        }
        aggregateCollector.mergeAuxThreadProfilesInto(collector);
    }

    Set<String> getTransactionTypes() {
        return this.typeCollectors.keySet();
    }

    void flush(Collector collector) throws Exception {
        collector.collectAggregates(new AggregateReaderImpl(this.captureTime));
    }

    void clear() {
        this.typeCollectors.clear();
    }

    private @Nullable AggregateCollector getAggregateCollector(String transactionType, @Nullable String transactionName) {
        IntervalTypeCollector intervalTypeCollector = (IntervalTypeCollector)this.typeCollectors.get(transactionType);
        if (intervalTypeCollector == null) {
            return null;
        }
        if (transactionName == null) {
            return intervalTypeCollector.overallAggregateCollector;
        }
        return (AggregateCollector)intervalTypeCollector.transactionAggregateCollectors.get(transactionName);
    }

    private static class SharedQueryTextCollectionImpl
    implements SharedQueryTextCollection {
        private final Map<String, Integer> sharedQueryTextIndexes = Maps.newHashMap();
        private List<String> latestSharedQueryTexts = Lists.newArrayList();

        private SharedQueryTextCollectionImpl() {
        }

        public List<String> getAndClearLastestSharedQueryTexts() {
            List<String> latestSharedQueryTexts = this.latestSharedQueryTexts;
            this.latestSharedQueryTexts = Lists.newArrayList();
            return latestSharedQueryTexts;
        }

        @Override
        public int getSharedQueryTextIndex(String queryText) {
            Integer sharedQueryTextIndex = this.sharedQueryTextIndexes.get(queryText);
            if (sharedQueryTextIndex == null) {
                sharedQueryTextIndex = this.sharedQueryTextIndexes.size();
                this.sharedQueryTextIndexes.put(queryText, sharedQueryTextIndex);
                this.latestSharedQueryTexts.add(queryText);
            }
            return sharedQueryTextIndex;
        }
    }

    private class AggregateReaderImpl
    implements Collector.AggregateReader {
        private final long captureTime;

        private AggregateReaderImpl(long captureTime) {
            this.captureTime = captureTime;
        }

        @Override
        public long captureTime() {
            return this.captureTime;
        }

        @Override
        public void accept(Collector.AggregateVisitor aggregateVisitor) throws Exception {
            SharedQueryTextCollectionImpl sharedQueryTextCollector = new SharedQueryTextCollectionImpl();
            LazyHistogram.ScratchBuffer scratchBuffer = new LazyHistogram.ScratchBuffer();
            for (Map.Entry e : AggregateIntervalCollector.this.typeCollectors.entrySet()) {
                String transactionType = (String)e.getKey();
                IntervalTypeCollector intervalTypeCollector = (IntervalTypeCollector)e.getValue();
                AggregateOuterClass.Aggregate overallAggregate = intervalTypeCollector.overallAggregateCollector.build(sharedQueryTextCollector, scratchBuffer);
                aggregateVisitor.visitOverallAggregate(transactionType, sharedQueryTextCollector.getAndClearLastestSharedQueryTexts(), overallAggregate);
                for (Map.Entry f : intervalTypeCollector.transactionAggregateCollectors.entrySet()) {
                    AggregateOuterClass.Aggregate transactionAggregate = ((AggregateCollector)f.getValue()).build(sharedQueryTextCollector, scratchBuffer);
                    aggregateVisitor.visitTransactionAggregate(transactionType, (String)f.getKey(), sharedQueryTextCollector.getAndClearLastestSharedQueryTexts(), transactionAggregate);
                }
            }
        }
    }

    private class IntervalTypeCollector {
        private final AggregateCollector overallAggregateCollector;
        private final Map<String, AggregateCollector> transactionAggregateCollectors = Maps.newConcurrentMap();

        private IntervalTypeCollector() {
            this.overallAggregateCollector = new AggregateCollector(null, AggregateIntervalCollector.this.maxQueryAggregates, AggregateIntervalCollector.this.maxServiceCallAggregates);
        }

        private void add(Transaction transaction) {
            this.merge(transaction, this.overallAggregateCollector);
            AggregateCollector transactionAggregateCollector = this.transactionAggregateCollectors.get(transaction.getTransactionName());
            if (transactionAggregateCollector == null) {
                if (this.transactionAggregateCollectors.size() < AggregateIntervalCollector.this.maxTransactionAggregates) {
                    transactionAggregateCollector = this.createTransactionAggregateCollector(transaction.getTransactionName());
                } else {
                    transactionAggregateCollector = this.transactionAggregateCollectors.get(AggregateIntervalCollector.LIMIT_EXCEEDED_BUCKET);
                    if (transactionAggregateCollector == null) {
                        transactionAggregateCollector = this.createTransactionAggregateCollector(AggregateIntervalCollector.LIMIT_EXCEEDED_BUCKET);
                    }
                }
            }
            this.merge(transaction, transactionAggregateCollector);
        }

        private AggregateCollector createTransactionAggregateCollector(String transactionName) {
            AggregateCollector transactionAggregateCollector = new AggregateCollector(transactionName, AggregateIntervalCollector.this.maxQueryAggregates, AggregateIntervalCollector.this.maxServiceCallAggregates);
            this.transactionAggregateCollectors.put(transactionName, transactionAggregateCollector);
            return transactionAggregateCollector;
        }

        private void merge(Transaction transaction, AggregateCollector aggregateCollector) {
            aggregateCollector.mergeDataFrom(transaction);
        }

        private @Nullable String getFullQueryText(String fullQueryTextSha1) {
            String fullQueryText = this.overallAggregateCollector.getFullQueryText(fullQueryTextSha1);
            if (fullQueryText != null) {
                return fullQueryText;
            }
            for (AggregateCollector aggregateCollector : this.transactionAggregateCollectors.values()) {
                fullQueryText = aggregateCollector.getFullQueryText(fullQueryTextSha1);
                if (fullQueryText == null) continue;
                return fullQueryText;
            }
            return null;
        }
    }
}

