/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.util.jar.JarFile;

public class AgentPremain {
    private static final boolean PRE_CHECK_LOADED_CLASSES = Boolean.getBoolean("glowroot.debug.preCheckLoadedClasses");

    private AgentPremain() {
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        try {
            Class[] allPriorLoadedClasses = PRE_CHECK_LOADED_CLASSES ? instrumentation.getAllLoadedClasses() : new Class[]{};
            CodeSource codeSource = AgentPremain.class.getProtectionDomain().getCodeSource();
            File glowrootJarFile = AgentPremain.getGlowrootJarFile(codeSource);
            if (glowrootJarFile != null) {
                instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(glowrootJarFile));
            }
            Class<?> mainEntryPointClass = Class.forName("org.glowroot.agent.MainEntryPoint", true, AgentPremain.class.getClassLoader());
            Method premainMethod = mainEntryPointClass.getMethod("premain", Instrumentation.class, Class[].class, File.class);
            premainMethod.invoke(null, instrumentation, allPriorLoadedClasses, glowrootJarFile);
        }
        catch (Throwable t) {
            System.err.println("Glowroot failed to start: " + t.getMessage());
            t.printStackTrace();
        }
    }

    static File getGlowrootJarFile(CodeSource codeSource) throws Exception {
        if (codeSource == null) {
            if (System.getProperty("glowroot.test.dir") != null) {
                return null;
            }
            throw new IOException("Could not determine glowroot jar location");
        }
        File codeSourceFile = new File(codeSource.getLocation().toURI());
        if (codeSourceFile.getName().endsWith(".jar")) {
            return codeSourceFile;
        }
        if (System.getProperty("glowroot.test.dir") != null) {
            return null;
        }
        throw new IOException("Could not determine glowroot jar location");
    }
}

