/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.net.logstash.logback.composite.loggingevent;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.NoArgGenerator;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import java.io.IOException;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.ILoggingEvent;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.net.logstash.logback.composite.AbstractFieldJsonProvider;
import org.glowroot.agent.shaded.net.logstash.logback.composite.JsonWritingUtils;

public class UuidProvider
extends AbstractFieldJsonProvider<ILoggingEvent> {
    public static final String FIELD_UUID = "uuid";
    public static final String STRATEGY_RANDOM = "random";
    public static final String STRATEGY_TIME = "time";
    private NoArgGenerator uuids = Generators.randomBasedGenerator();
    private String strategy = "random";
    private String ethernet;

    public UuidProvider() {
        this.setFieldName(FIELD_UUID);
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent iLoggingEvent) throws IOException {
        JsonWritingUtils.writeStringField(generator, this.getFieldName(), this.uuids.generate().toString());
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
        this.uuids = this.newUuidStrategy(strategy, this.ethernet);
    }

    public String getEthernet() {
        return this.ethernet;
    }

    public void setEthernet(String ethernet) {
        this.ethernet = ethernet;
        this.uuids = this.newUuidStrategy(this.strategy, this.ethernet);
    }

    private NoArgGenerator newUuidStrategy(String strategy, String ethernet) {
        if (STRATEGY_TIME.equalsIgnoreCase(strategy)) {
            return this.newTimeBasedGenerator(ethernet);
        }
        if (STRATEGY_RANDOM.equalsIgnoreCase(strategy)) {
            return Generators.randomBasedGenerator();
        }
        throw new IllegalArgumentException("Unknown strategy: " + strategy);
    }

    private TimeBasedGenerator newTimeBasedGenerator(String ethernet) {
        if (ethernet == null) {
            return Generators.timeBasedGenerator();
        }
        if ("interface".equalsIgnoreCase(ethernet)) {
            return Generators.timeBasedGenerator((EthernetAddress)EthernetAddress.fromInterface());
        }
        return Generators.timeBasedGenerator((EthernetAddress)EthernetAddress.valueOf((String)ethernet));
    }
}

