/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.net.logstash.logback.composite.loggingevent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.ILoggingEvent;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.IThrowableProxy;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.ThrowableProxy;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.net.logstash.logback.composite.AbstractFieldJsonProvider;
import org.glowroot.agent.shaded.net.logstash.logback.composite.JsonWritingUtils;
import org.glowroot.agent.shaded.net.logstash.logback.stacktrace.StackElementFilter;
import org.glowroot.agent.shaded.net.logstash.logback.stacktrace.StackHasher;

public class StackHashJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent> {
    public static final String FIELD_NAME = "stack_hash";
    private List<Pattern> excludes = new ArrayList<Pattern>(5);
    private StackHasher hasher = new StackHasher();

    public StackHashJsonProvider() {
        this.setFieldName(FIELD_NAME);
    }

    @Override
    public void start() {
        if (!this.excludes.isEmpty()) {
            this.hasher = new StackHasher(StackElementFilter.byPattern(this.excludes));
        }
        super.start();
    }

    public void addExclude(String exclusionPattern) {
        this.excludes.add(Pattern.compile(exclusionPattern));
    }

    public void setExclusions(String comaSeparatedPatterns) {
        if (comaSeparatedPatterns == null || comaSeparatedPatterns.isEmpty()) {
            this.excludes = new ArrayList<Pattern>(5);
        } else {
            this.setExcludes(Arrays.asList(comaSeparatedPatterns.split("\\s*\\,\\s*")));
        }
    }

    public void setExcludes(List<String> exclusionPatterns) {
        if (exclusionPatterns == null || exclusionPatterns.isEmpty()) {
            this.excludes = new ArrayList<Pattern>(5);
        } else {
            this.excludes = new ArrayList<Pattern>(exclusionPatterns.size());
            for (String pattern : exclusionPatterns) {
                this.addExclude(pattern);
            }
        }
    }

    public List<String> getExcludes() {
        ArrayList<String> exclusionPatterns = new ArrayList<String>(this.excludes.size());
        for (Pattern pattern : this.excludes) {
            exclusionPatterns.add(pattern.pattern());
        }
        return exclusionPatterns;
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy != null && throwableProxy instanceof ThrowableProxy) {
            String hash = this.hasher.hexHash(((ThrowableProxy)event.getThrowableProxy()).getThrowable());
            JsonWritingUtils.writeStringField(generator, this.getFieldName(), hash);
        }
    }
}

