/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.net.logstash.logback.composite.loggingevent;

import java.io.IOException;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.ILoggingEvent;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.IThrowableProxy;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.ThrowableProxy;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.net.logstash.logback.composite.AbstractFieldJsonProvider;
import org.glowroot.agent.shaded.net.logstash.logback.composite.JsonWritingUtils;

public abstract class AbstractThrowableClassNameJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent> {
    static final boolean DEFAULT_USE_SIMPLE_CLASS_NAME = true;
    private boolean useSimpleClassName = true;

    public AbstractThrowableClassNameJsonProvider(String fieldName) {
        this.setFieldName(fieldName);
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        IThrowableProxy throwable = this.getThrowable(event.getThrowableProxy());
        if (throwable != null) {
            String throwableClassName = this.determineClassName(throwable);
            JsonWritingUtils.writeStringField(generator, this.getFieldName(), throwableClassName);
        }
    }

    private String determineClassName(IThrowableProxy throwable) {
        if (!this.useSimpleClassName) {
            return throwable.getClassName();
        }
        if (throwable instanceof ThrowableProxy) {
            return ((ThrowableProxy)throwable).getThrowable().getClass().getSimpleName();
        }
        String className = throwable.getClassName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    abstract IThrowableProxy getThrowable(IThrowableProxy var1);

    public void setUseSimpleClassName(boolean useSimpleClassName) {
        this.useSimpleClassName = useSimpleClassName;
    }
}

