/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.net.logstash.logback;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glowroot.agent.shaded.ch.qos.logback.classic.pattern.Abbreviator;

public class CachingAbbreviator
implements Abbreviator {
    private final Abbreviator delegate;
    private final ConcurrentMap<String, String> cache = new ConcurrentHashMap<String, String>();

    public CachingAbbreviator(Abbreviator delegate) {
        this.delegate = delegate;
    }

    public String abbreviate(String in) {
        String abbreviation = (String)this.cache.get(in);
        if (abbreviation == null) {
            abbreviation = this.delegate.abbreviate(in);
            this.cache.putIfAbsent(in, abbreviation);
        }
        return abbreviation;
    }

    public void clear() {
        this.cache.clear();
    }
}

