/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.util;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Schemas.Index", generator="Immutables")
@Immutable
public final class ImmutableIndex
implements Schemas.Index {
    private final @Untainted String name;
    private final ImmutableList<String> columns;

    private ImmutableIndex(@Untainted String name, Iterable<String> columns) {
        this.name = Objects.requireNonNull(name, "name");
        this.columns = ImmutableList.copyOf(columns);
    }

    private ImmutableIndex(ImmutableIndex original, @Untainted String name, ImmutableList<String> columns) {
        this.name = name;
        this.columns = columns;
    }

    @Override
    @JsonProperty(value="name")
    public @Untainted String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="columns")
    public ImmutableList<String> columns() {
        return this.columns;
    }

    public final ImmutableIndex withName(@Untainted String value) {
        @Untainted String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableIndex(this, newValue, this.columns);
    }

    public final ImmutableIndex withColumns(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableIndex(this, this.name, (ImmutableList<String>)newValue);
    }

    public final ImmutableIndex withColumns(Iterable<String> elements) {
        if (this.columns == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableIndex(this, this.name, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIndex && this.equalTo(0, (ImmutableIndex)another);
    }

    private boolean equalTo(int synthetic, ImmutableIndex another) {
        return this.name.equals(another.name) && this.columns.equals(another.columns);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.columns.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Index").omitNullValues().add("name", (Object)this.name).add("columns", this.columns).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIndex fromJson(Json json) {
        Builder builder = ImmutableIndex.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.columns != null) {
            builder.addAllColumns((Iterable<String>)json.columns);
        }
        return builder.build();
    }

    public static ImmutableIndex of(@Untainted String name, ImmutableList<String> columns) {
        return ImmutableIndex.of(name, columns);
    }

    public static ImmutableIndex of(@Untainted String name, Iterable<String> columns) {
        return new ImmutableIndex(name, columns);
    }

    public static ImmutableIndex copyOf(Schemas.Index instance) {
        if (instance instanceof ImmutableIndex) {
            return (ImmutableIndex)instance;
        }
        return ImmutableIndex.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Schemas.Index", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private @Untainted String name;
        private ImmutableList.Builder<String> columns = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(Schemas.Index instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.addAllColumns((Iterable<String>)instance.columns());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(@Untainted String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addColumns(String element) {
            this.columns.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addColumns(String ... elements) {
            this.columns.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder columns(Iterable<String> elements) {
            this.columns = ImmutableList.builder();
            return this.addAllColumns(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllColumns(Iterable<String> elements) {
            this.columns.addAll(elements);
            return this;
        }

        public ImmutableIndex build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIndex(null, this.name, this.columns.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Index, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Schemas.Index", generator="Immutables")
    static final class Json
    implements Schemas.Index {
        @Nullable
        @Untainted String name;
        @Nullable
        ImmutableList<String> columns = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(@Untainted String name) {
            this.name = name;
        }

        @JsonProperty(value="columns")
        public void setColumns(ImmutableList<String> columns) {
            this.columns = columns;
        }

        @Override
        public @Untainted String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<String> columns() {
            throw new UnsupportedOperationException();
        }
    }
}

