/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.org.glowroot.common.util.ScheduledRunnable;

class CappedDatabaseOutputStream
extends OutputStream {
    static final int HEADER_SKIP_BYTES = 20;
    static final int BLOCK_HEADER_SKIP_BYTES = 8;
    private static final int FSYNC_INTERVAL_MILLIS = 100;
    private static final int HEADER_CURR_INDEX_POS = 0;
    private final File file;
    private final Ticker ticker;
    private RandomAccessFile out;
    private volatile long currIndex;
    private long lastResizeBaseIndex;
    private volatile int sizeKb;
    private long sizeBytes;
    private volatile long smallestNonOverwrittenId;
    private long blockStartIndex;
    private long blockStartPosition;
    private final AtomicBoolean fsyncNeeded = new AtomicBoolean();
    private final AtomicLong lastFsyncTick = new AtomicLong();
    private final FsyncRunnable fsyncScheduledRunnable;

    static CappedDatabaseOutputStream create(File file, int requestedSizeKb, @Nullable ScheduledExecutorService scheduledExecutor, Ticker ticker) throws IOException {
        CappedDatabaseOutputStream out = new CappedDatabaseOutputStream(file, requestedSizeKb, ticker);
        if (scheduledExecutor != null) {
            out.fsyncScheduledRunnable.scheduleWithFixedDelay(scheduledExecutor, 100L, 100L, TimeUnit.MILLISECONDS);
        }
        return out;
    }

    private CappedDatabaseOutputStream(File file, int requestedSizeKb, Ticker ticker) throws IOException {
        this.file = file;
        this.ticker = ticker;
        boolean newFile = !file.exists() || file.length() == 0L;
        this.out = new RandomAccessFile(file, "rw");
        if (newFile) {
            this.currIndex = 0L;
            this.sizeKb = requestedSizeKb;
            this.sizeBytes = (long)this.sizeKb * 1024L;
            this.lastResizeBaseIndex = 0L;
            this.out.writeLong(this.currIndex);
            this.out.writeInt(this.sizeKb);
            this.out.writeLong(this.lastResizeBaseIndex);
        } else {
            this.currIndex = this.out.readLong();
            this.sizeKb = this.out.readInt();
            this.sizeBytes = (long)this.sizeKb * 1024L;
            this.lastResizeBaseIndex = this.out.readLong();
        }
        this.smallestNonOverwrittenId = CappedDatabaseOutputStream.calculateSmallestNonOverwrittenId(this.lastResizeBaseIndex, this.currIndex, this.sizeBytes);
        this.lastFsyncTick.set(ticker.read());
        this.fsyncScheduledRunnable = new FsyncRunnable();
    }

    void startBlock() {
        long currPosition = (this.currIndex - this.lastResizeBaseIndex) % this.sizeBytes;
        long remainingBytes = this.sizeBytes - currPosition;
        if (remainingBytes < 8L) {
            this.currIndex += remainingBytes;
        }
        this.blockStartIndex = this.currIndex;
        this.blockStartPosition = (this.currIndex - this.lastResizeBaseIndex) % this.sizeBytes;
        this.currIndex += 8L;
        this.updateSmallestNonOverwrittenId();
    }

    long endBlock() throws IOException {
        this.out.seek(20L + this.blockStartPosition);
        this.out.writeLong(this.currIndex - this.blockStartIndex - 8L);
        this.fsyncNeeded.set(true);
        return this.blockStartIndex;
    }

    void fsyncIfReallyNeeded() throws IOException {
        if (this.ticker.read() - this.lastFsyncTick.get() > TimeUnit.SECONDS.toNanos(2L)) {
            this.fsyncIfNeeded();
        }
    }

    boolean isInTheFuture(long cappedId) {
        return cappedId >= this.currIndex;
    }

    boolean isOverwritten(long cappedId) {
        return cappedId < this.smallestNonOverwrittenId;
    }

    long getSmallestNonOverwrittenId() {
        return this.smallestNonOverwrittenId;
    }

    int getSizeKb() {
        return this.sizeKb;
    }

    long convertToFilePosition(long index) {
        return (index - this.lastResizeBaseIndex) % this.sizeBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resize(int newSizeKb) throws IOException {
        if (this.performEasyResize(newSizeKb)) {
            return;
        }
        long newSizeBytes = (long)newSizeKb * 1024L;
        int numKeepKb = Math.min(this.sizeKb, newSizeKb);
        long numKeepBytes = (long)numKeepKb * 1024L;
        long startPosition = this.convertToFilePosition(this.currIndex - numKeepBytes);
        this.lastResizeBaseIndex = this.currIndex - numKeepBytes;
        File tmpCappedFile = new File(this.file.getPath() + ".resizing.tmp");
        try (RandomAccessFile tmpOut = new RandomAccessFile(tmpCappedFile, "rw");){
            tmpOut.writeLong(this.currIndex);
            tmpOut.writeInt(newSizeKb);
            tmpOut.writeLong(this.lastResizeBaseIndex);
            long remaining = this.sizeBytes - startPosition;
            this.out.seek(20L + startPosition);
            if (numKeepBytes > remaining) {
                CappedDatabaseOutputStream.copy(this.out, tmpOut, remaining);
                this.out.seek(20L);
                CappedDatabaseOutputStream.copy(this.out, tmpOut, numKeepBytes - remaining);
            } else {
                CappedDatabaseOutputStream.copy(this.out, tmpOut, numKeepBytes);
            }
            this.out.close();
        }
        if (!this.file.delete()) {
            throw new IOException("Unable to delete existing capped database during resize");
        }
        if (!tmpCappedFile.renameTo(this.file)) {
            throw new IOException("Unable to rename new capped database during resize");
        }
        this.sizeKb = newSizeKb;
        this.sizeBytes = newSizeBytes;
        this.out = new RandomAccessFile(this.file, "rw");
        this.updateSmallestNonOverwrittenId();
    }

    @Override
    public void close() throws IOException {
        this.fsyncScheduledRunnable.cancel();
        this.out.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.currIndex + (long)len - this.blockStartIndex > this.sizeBytes) {
            throw new IOException("A single block cannot have more bytes than size of the capped database");
        }
        long currPosition = (this.currIndex - this.lastResizeBaseIndex) % this.sizeBytes;
        this.out.seek(20L + currPosition);
        long remaining = this.sizeBytes - currPosition;
        if ((long)len >= remaining) {
            this.out.write(b, off, (int)remaining);
            this.out.seek(20L);
            this.out.write(b, (int)remaining, (int)((long)len - remaining));
        } else {
            this.out.write(b, off, len);
        }
        this.currIndex += (long)len;
        this.out.seek(0L);
        this.out.writeLong(this.currIndex);
        this.updateSmallestNonOverwrittenId();
    }

    private void fsyncIfNeeded() throws IOException {
        if (this.fsyncNeeded.getAndSet(false)) {
            this.out.getFD().sync();
            this.lastFsyncTick.set(this.ticker.read());
        }
    }

    private boolean performEasyResize(int newSizeKb) throws IOException {
        if (newSizeKb == this.sizeKb) {
            return true;
        }
        long newSizeBytes = (long)newSizeKb * 1024L;
        if (this.isEasyResize(newSizeKb, newSizeBytes)) {
            this.out.seek(8L);
            this.out.writeInt(newSizeKb);
            this.sizeKb = newSizeKb;
            this.sizeBytes = newSizeBytes;
            this.updateSmallestNonOverwrittenId();
            return true;
        }
        return false;
    }

    private boolean isEasyResize(int newSizeKb, long newSizeBytes) {
        if (newSizeKb < this.sizeKb && this.currIndex - this.lastResizeBaseIndex < newSizeBytes) {
            return true;
        }
        return newSizeKb > this.sizeKb && this.currIndex - this.lastResizeBaseIndex < this.sizeBytes;
    }

    private void updateSmallestNonOverwrittenId() {
        this.smallestNonOverwrittenId = CappedDatabaseOutputStream.calculateSmallestNonOverwrittenId(this.lastResizeBaseIndex, this.currIndex, this.sizeBytes);
    }

    private static long calculateSmallestNonOverwrittenId(long lastResizeBaseIndex, long currIndex, long sizeBytes) {
        return Math.max(lastResizeBaseIndex, currIndex - sizeBytes);
    }

    private static void copy(RandomAccessFile in, RandomAccessFile out, long numBytes) throws IOException {
        int n;
        byte[] block = new byte[1024];
        for (long total = 0L; total < numBytes; total += (long)n) {
            n = in.read(block, 0, (int)Math.min(1024L, numBytes - total));
            out.write(block, 0, n);
        }
    }

    private class FsyncRunnable
    extends ScheduledRunnable {
        private FsyncRunnable() {
        }

        protected void runInternal() throws IOException {
            CappedDatabaseOutputStream.this.fsyncIfNeeded();
        }
    }
}

