/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.sql.SQLException;

public class DriverManager {
    private static final Driver driver = new org.glowroot.agent.embedded.shaded.org.h2.Driver();
    private static volatile int loginTimeout;
    private static volatile @Nullable PrintWriter logWriter;
    private static volatile @Nullable PrintStream logStream;

    private DriverManager() {
    }

    public static Connection getConnection(String url) throws SQLException {
        return DriverManager.getConnection(url, new Properties());
    }

    public static Connection getConnection(String url, String user, String password) throws SQLException {
        Properties info = new Properties();
        info.put("user", user);
        info.put("password", password);
        return DriverManager.getConnection(url, info);
    }

    public static Connection getConnection(String url, Properties info) throws SQLException {
        return driver.connect(url, info);
    }

    public static Driver getDriver(String url) {
        return driver;
    }

    public static void registerDriver(Driver driver) throws SQLException {
    }

    public static void deregisterDriver(Driver driver) {
    }

    public static Enumeration<Driver> getDrivers() {
        return Collections.enumeration(Arrays.asList(driver));
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    public static void setLoginTimeout(int loginTimeout) {
        DriverManager.loginTimeout = loginTimeout;
    }

    public static @Nullable PrintWriter getLogWriter() {
        return logWriter;
    }

    public static void setLogWriter(@Nullable PrintWriter logWriter) {
        DriverManager.logWriter = logWriter;
    }

    public static void setLogStream(@Nullable PrintStream logStream) {
        DriverManager.logStream = logStream;
    }

    public static @Nullable PrintStream getLogStream() {
        return logStream;
    }

    public static void println(String message) {
    }
}

