/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.owasp.html;

final class Strings {
    private static final char[] LCASE_CHARS;
    private static final char[] UCASE_CHARS;

    public static boolean regionMatchesIgnoreCase(CharSequence a, int aoffset, CharSequence b, int boffset, int n) {
        if (aoffset + n > a.length() || boffset + n > b.length()) {
            return false;
        }
        int i = n;
        while (--i >= 0) {
            char d;
            char c = a.charAt(aoffset + i);
            if (c == (d = b.charAt(boffset + i))) continue;
            if (c <= 'z' && c >= 'A') {
                if (c <= 'Z') {
                    c = (char)(c | 0x20);
                }
                if (d <= 'Z' && d >= 'A') {
                    d = (char)(d | 0x20);
                }
                if (c == d) continue;
            }
            return false;
        }
        return true;
    }

    public static String toLowerCase(String s) {
        int i = s.length();
        while (--i >= 0) {
            char c = s.charAt(i);
            if (c > 'Z' || c < 'A') continue;
            char[] chars = s.toCharArray();
            chars[i] = LCASE_CHARS[c];
            while (--i >= 0) {
                c = chars[i];
                if (c > 'Z') continue;
                chars[i] = LCASE_CHARS[c];
            }
            return String.valueOf(chars);
        }
        return s;
    }

    static boolean isHtmlSpace(int ch) {
        return ch <= 32 && (0x100003600L & 1L << ch) != 0L;
    }

    static String stripHtmlSpaces(String s) {
        int n;
        int i = 0;
        for (n = s.length(); n > i && Strings.isHtmlSpace(s.charAt(n - 1)); --n) {
        }
        while (i < n && Strings.isHtmlSpace(s.charAt(i))) {
            ++i;
        }
        if (i == 0 && n == s.length()) {
            return s;
        }
        return s.substring(i, n);
    }

    static int skipValidFloatingPointNumber(String value, int start) {
        char ch;
        int i = start;
        int n = value.length();
        if (i >= n) {
            return -1;
        }
        if (value.charAt(i) == '-') {
            ++i;
        }
        boolean hasMantissa = false;
        while (i < n && '0' <= (ch = value.charAt(i)) && ch <= '9') {
            ++i;
            hasMantissa = true;
        }
        if (i < n && value.charAt(i) == '.') {
            ++i;
            hasMantissa = false;
            while (i < n && '0' <= (ch = value.charAt(i)) && ch <= '9') {
                ++i;
                hasMantissa = true;
            }
        }
        if (!hasMantissa) {
            return -1;
        }
        if (i < n && (value.charAt(i) | 0x20) == 101) {
            char ch2;
            if (++i < n && ((ch = value.charAt(i)) == '+' || ch == '-')) {
                ++i;
            }
            boolean hasExponent = false;
            while (i < n && '0' <= (ch2 = value.charAt(i)) && ch2 <= '9') {
                ++i;
                hasExponent = true;
            }
            if (!hasExponent) {
                return -1;
            }
        }
        return i;
    }

    static {
        int i;
        LCASE_CHARS = new char[91];
        UCASE_CHARS = new char[123];
        for (i = 0; i < 65; ++i) {
            Strings.LCASE_CHARS[i] = (char)i;
        }
        for (i = 65; i <= 90; ++i) {
            Strings.LCASE_CHARS[i] = (char)(i | 0x20);
        }
        for (i = 0; i < 97; ++i) {
            Strings.UCASE_CHARS[i] = (char)i;
        }
        for (i = 97; i <= 122; ++i) {
            Strings.UCASE_CHARS[i] = (char)(i & 0xFFFFFFDF);
        }
    }
}

