/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.owasp.html;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.glowroot.agent.embedded.shaded.org.owasp.html.Joinable;
import org.glowroot.agent.embedded.shaded.org.owasp.html.JoinedElementPolicy;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;

public interface ElementPolicy {
    public static final ElementPolicy IDENTITY_ELEMENT_POLICY = new ElementPolicy(){

        @Override
        public String apply(String elementName, List<String> attrs) {
            return elementName;
        }
    };
    public static final ElementPolicy REJECT_ALL_ELEMENT_POLICY = new ElementPolicy(){

        @Override
        @Nullable
        public String apply(String elementName, List<String> attrs) {
            return null;
        }
    };

    @Nullable
    public String apply(String var1, List<String> var2);

    public static interface JoinableElementPolicy
    extends ElementPolicy,
    Joinable<JoinableElementPolicy> {
    }

    public static final class Util {
        public static final ElementPolicy join(ElementPolicy ... policies) {
            PolicyJoiner joiner = new PolicyJoiner();
            for (ElementPolicy p : policies) {
                if (p == null) continue;
                joiner.unroll(p);
            }
            return (ElementPolicy)joiner.join();
        }

        static final class PolicyJoiner
        extends Joinable.JoinHelper<ElementPolicy, JoinableElementPolicy> {
            PolicyJoiner() {
                super(ElementPolicy.class, JoinableElementPolicy.class, REJECT_ALL_ELEMENT_POLICY, IDENTITY_ELEMENT_POLICY);
            }

            @Override
            Optional<ImmutableList<ElementPolicy>> split(ElementPolicy x) {
                if (x instanceof JoinedElementPolicy) {
                    return Optional.of(((JoinedElementPolicy)x).policies);
                }
                return Optional.absent();
            }

            @Override
            ElementPolicy rejoin(Set<? extends ElementPolicy> xs) {
                return new JoinedElementPolicy(xs);
            }
        }
    }
}

