/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.value;

import java.sql.PreparedStatement;
import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.value.CompareMode;
import org.glowroot.agent.embedded.shaded.org.h2.value.Value;
import org.glowroot.agent.embedded.sql.SQLException;

public class ValueFloat
extends Value {
    public static final int ZERO_BITS = Float.floatToIntBits(0.0f);
    private static final ValueFloat ZERO = new ValueFloat(0.0f);
    private static final ValueFloat ONE = new ValueFloat(1.0f);
    private final float value;

    private ValueFloat(float f) {
        this.value = f;
    }

    @Override
    public Value add(Value value) {
        ValueFloat valueFloat = (ValueFloat)value;
        return ValueFloat.get(this.value + valueFloat.value);
    }

    @Override
    public Value subtract(Value value) {
        ValueFloat valueFloat = (ValueFloat)value;
        return ValueFloat.get(this.value - valueFloat.value);
    }

    @Override
    public Value negate() {
        return ValueFloat.get(-this.value);
    }

    @Override
    public Value multiply(Value value) {
        ValueFloat valueFloat = (ValueFloat)value;
        return ValueFloat.get(this.value * valueFloat.value);
    }

    @Override
    public Value divide(Value value) {
        ValueFloat valueFloat = (ValueFloat)value;
        if ((double)valueFloat.value == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueFloat.get(this.value / valueFloat.value);
    }

    @Override
    public Value modulus(Value value) {
        ValueFloat valueFloat = (ValueFloat)value;
        if (valueFloat.value == 0.0f) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueFloat.get(this.value % valueFloat.value);
    }

    @Override
    public String getSQL() {
        if (this.value == Float.POSITIVE_INFINITY) {
            return "POWER(0, -1)";
        }
        if (this.value == Float.NEGATIVE_INFINITY) {
            return "(-POWER(0, -1))";
        }
        if (Double.isNaN(this.value)) {
            return "SQRT(-1)";
        }
        String string = this.getString();
        if (string.equals("-0.0")) {
            return "-CAST(0 AS REAL)";
        }
        return string;
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueFloat valueFloat = (ValueFloat)value;
        return Float.compare(this.value, valueFloat.value);
    }

    @Override
    public int getSignum() {
        return this.value == 0.0f ? 0 : (this.value < 0.0f ? -1 : 1);
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 7L;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int hashCode() {
        long l = Float.floatToIntBits(this.value);
        return (int)(l ^ l >> 32);
    }

    @Override
    public Object getObject() {
        return Float.valueOf(this.value);
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setFloat(n, this.value);
    }

    public static ValueFloat get(float f) {
        if (f == 1.0f) {
            return ONE;
        }
        if (f == 0.0f && Float.floatToIntBits(f) == ZERO_BITS) {
            return ZERO;
        }
        return (ValueFloat)Value.cache(new ValueFloat(f));
    }

    @Override
    public int getDisplaySize() {
        return 15;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueFloat)) {
            return false;
        }
        return this.compareSecure((ValueFloat)object, null) == 0;
    }
}

