/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.util;

import java.lang.ref.SoftReference;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import org.glowroot.agent.embedded.shaded.org.h2.engine.Constants;
import org.glowroot.agent.embedded.shaded.org.h2.engine.SysProperties;
import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.util.New;
import org.glowroot.agent.embedded.shaded.org.h2.util.StatementBuilder;

public class StringUtils {
    private static SoftReference<String[]> softCache;
    private static long softCacheCreated;
    private static final char[] HEX;
    private static final int[] HEX_DECODE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getCache() {
        String[] stringArray;
        if (softCache != null && (stringArray = softCache.get()) != null) {
            return stringArray;
        }
        long l = System.currentTimeMillis();
        if (softCacheCreated != 0L && l - softCacheCreated < 5000L) {
            return null;
        }
        try {
            stringArray = new String[SysProperties.OBJECT_CACHE_SIZE];
            softCache = new SoftReference<String[]>(stringArray);
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            softCacheCreated = System.currentTimeMillis();
        }
    }

    public static boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static String toUpperEnglish(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static String toLowerEnglish(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        if (string.length() < string2.length()) {
            return false;
        }
        return string.substring(0, string2.length()).equalsIgnoreCase(string2);
    }

    public static String quoteStringSQL(String string) {
        if (string == null) {
            return "NULL";
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 2);
        stringBuilder.append('\'');
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuilder.append(c);
            } else if (c < ' ' || c > '\u007f') {
                return "STRINGDECODE(" + StringUtils.quoteStringSQL(StringUtils.javaEncode(string)) + ")";
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    public static String javaEncode(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block8;
                }
                default: {
                    int n2 = c & 0xFFFF;
                    if (n2 >= 32 && n2 < 128) {
                        stringBuilder.append(c);
                        continue block8;
                    }
                    stringBuilder.append("\\u");
                    String string2 = Integer.toHexString(n2);
                    for (int j = string2.length(); j < 4; ++j) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(string2);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String addAsterisk(String string, int n) {
        if (string != null && n < string.length()) {
            string = string.substring(0, n) + "[*]" + string.substring(n);
        }
        return string;
    }

    private static DbException getFormatException(String string, int n) {
        return DbException.get(90095, StringUtils.addAsterisk(string, n));
    }

    public static String javaDecode(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block17: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (i + 1 >= string.length()) {
                    throw StringUtils.getFormatException(string, i);
                }
                c = string.charAt(++i);
                switch (c) {
                    case 't': {
                        stringBuilder.append('\t');
                        continue block17;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        continue block17;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        continue block17;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        continue block17;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        continue block17;
                    }
                    case '#': {
                        stringBuilder.append('#');
                        continue block17;
                    }
                    case '=': {
                        stringBuilder.append('=');
                        continue block17;
                    }
                    case ':': {
                        stringBuilder.append(':');
                        continue block17;
                    }
                    case '\"': {
                        stringBuilder.append('\"');
                        continue block17;
                    }
                    case '\\': {
                        stringBuilder.append('\\');
                        continue block17;
                    }
                    case 'u': {
                        try {
                            c = (char)Integer.parseInt(string.substring(i + 1, i + 5), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw StringUtils.getFormatException(string, i);
                        }
                        i += 4;
                        stringBuilder.append(c);
                        continue block17;
                    }
                    default: {
                        if (c >= '0' && c <= '9') {
                            try {
                                c = (char)Integer.parseInt(string.substring(i, i + 3), 8);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw StringUtils.getFormatException(string, i);
                            }
                            i += 2;
                            stringBuilder.append(c);
                            continue block17;
                        }
                        throw StringUtils.getFormatException(string, i);
                    }
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String quoteJavaString(String string) {
        if (string == null) {
            return "null";
        }
        return "\"" + StringUtils.javaEncode(string) + "\"";
    }

    public static String quoteJavaStringArray(String[] stringArray) {
        if (stringArray == null) {
            return "null";
        }
        StatementBuilder statementBuilder = new StatementBuilder("new String[]{");
        for (String string : stringArray) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(StringUtils.quoteJavaString(string));
        }
        return statementBuilder.append('}').toString();
    }

    public static String quoteJavaIntArray(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StatementBuilder statementBuilder = new StatementBuilder("new int[]{");
        for (int n : nArray) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(n);
        }
        return statementBuilder.append('}').toString();
    }

    public static String enclose(String string) {
        if (string.startsWith("(")) {
            return string;
        }
        return "(" + string + ")";
    }

    public static String unEnclose(String string) {
        if (string.startsWith("(") && string.endsWith(")")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    public static String urlDecode(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '+') {
                byArray[n2++] = 32;
                continue;
            }
            if (c == '%') {
                byArray[n2++] = (byte)Integer.parseInt(string.substring(i + 1, i + 3), 16);
                i += 2;
                continue;
            }
            if (SysProperties.CHECK && (c > '\u007f' || c < ' ')) {
                throw new IllegalArgumentException("Unexpected char " + c + " decoding " + string);
            }
            byArray[n2++] = (byte)c;
        }
        String string2 = new String(byArray, 0, n2, Constants.UTF8);
        return string2;
    }

    public static String[] arraySplit(String string, char c, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return new String[0];
        }
        ArrayList<String> arrayList = New.arrayList();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                String string2 = stringBuilder.toString();
                arrayList.add(bl ? string2.trim() : string2);
                stringBuilder.setLength(0);
                continue;
            }
            if (c2 == '\\' && i < n - 1) {
                stringBuilder.append(string.charAt(++i));
                continue;
            }
            stringBuilder.append(c2);
        }
        String string3 = stringBuilder.toString();
        arrayList.add(bl ? string3.trim() : string3);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String arrayCombine(String[] stringArray, char c) {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (String string : stringArray) {
            statementBuilder.appendExceptFirst(String.valueOf(c));
            if (string == null) {
                string = "";
            }
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c2 = string.charAt(i);
                if (c2 == '\\' || c2 == c) {
                    statementBuilder.append('\\');
                }
                statementBuilder.append(c2);
            }
        }
        return statementBuilder.toString();
    }

    public static String xmlAttr(String string, String string2) {
        return " " + string + "=\"" + StringUtils.xmlText(string2) + "\"";
    }

    public static String xmlNode(String string, String string2, String string3, boolean bl) {
        String string4;
        String string5 = string4 = string2 == null ? string : string + string2;
        if (string3 == null) {
            return "<" + string4 + "/>\n";
        }
        if (bl && string3.indexOf(10) >= 0) {
            string3 = "\n" + StringUtils.indent(string3);
        }
        return "<" + string4 + ">" + string3 + "</" + string + ">\n";
    }

    public static String indent(String string) {
        return StringUtils.indent(string, 4, true);
    }

    public static String indent(String string, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + n);
        int n2 = 0;
        while (n2 < string.length()) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                stringBuilder.append(' ');
            }
            n3 = string.indexOf(10, n2);
            n3 = n3 < 0 ? string.length() : n3 + 1;
            stringBuilder.append(string.substring(n2, n3));
            n2 = n3;
        }
        if (bl && !string.endsWith("\n")) {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static String xmlComment(String string) {
        int n = 0;
        while ((n = string.indexOf("--", n)) >= 0) {
            string = string.substring(0, n + 1) + " " + string.substring(n + 1);
        }
        if (string.indexOf(10) >= 0) {
            return "<!--\n" + StringUtils.indent(string) + "-->\n";
        }
        return "<!-- " + string + " -->\n";
    }

    public static String xmlCData(String string) {
        if (string.indexOf("]]>") >= 0) {
            return StringUtils.xmlText(string);
        }
        boolean bl = string.endsWith("\n");
        string = "<![CDATA[" + string + "]]>";
        return bl ? string + "\n" : string;
    }

    public static String xmlStartDoc() {
        return "<?xml version=\"1.0\"?>\n";
    }

    public static String xmlText(String string) {
        return StringUtils.xmlText(string, false);
    }

    public static String xmlText(String string, boolean bl) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block9: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block9;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block9;
                }
                case '\n': 
                case '\r': {
                    if (bl) {
                        stringBuilder.append("&#x").append(Integer.toHexString(c)).append(';');
                        continue block9;
                    }
                    stringBuilder.append(c);
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append(c);
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '\u007f') {
                        stringBuilder.append("&#x").append(Integer.toHexString(c)).append(';');
                        continue block9;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String replaceAll(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() - string2.length() + string3.length());
        int n2 = 0;
        do {
            stringBuilder.append(string.substring(n2, n)).append(string3);
        } while ((n = string.indexOf(string2, n2 = n + string2.length())) >= 0);
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    public static String quoteIdentifier(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 2);
        stringBuilder.append('\"');
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuilder.append(c);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.append('\"').toString();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String quoteRemarkSQL(String string) {
        string = StringUtils.replaceAll(string, "*/", "++/");
        return StringUtils.replaceAll(string, "/*", "/++");
    }

    public static String pad(String string, int n, String string2, boolean bl) {
        if (n < 0) {
            n = 0;
        }
        if (n < string.length()) {
            return string.substring(0, n);
        }
        if (n == string.length()) {
            return string;
        }
        char c = string2 == null || string2.length() == 0 ? (char)' ' : (char)string2.charAt(0);
        StringBuilder stringBuilder = new StringBuilder(n);
        n -= string.length();
        if (bl) {
            stringBuilder.append(string);
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
        if (!bl) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static char[] cloneCharArray(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        if (n == 0) {
            return cArray;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    public static String trim(String string, boolean bl, boolean bl2, String string2) {
        int n;
        int n2;
        char c;
        char c2 = c = string2 == null || string2.length() < 1 ? (char)' ' : (char)string2.charAt(0);
        if (bl) {
            n2 = string.length();
            for (n = 0; n < n2 && string.charAt(n) == c; ++n) {
            }
            String string3 = string = n == 0 ? string : string.substring(n);
        }
        if (bl2) {
            for (n = n2 = string.length() - 1; n >= 0 && string.charAt(n) == c; --n) {
            }
            string = n == n2 ? string : string.substring(0, n + 1);
        }
        return string;
    }

    public static String cache(String string) {
        if (!SysProperties.OBJECT_CACHE) {
            return string;
        }
        if (string == null) {
            return string;
        }
        if (string.length() == 0) {
            return "";
        }
        int n = string.hashCode();
        String[] stringArray = StringUtils.getCache();
        if (stringArray != null) {
            int n2 = n & SysProperties.OBJECT_CACHE_SIZE - 1;
            String string2 = stringArray[n2];
            if (string2 != null && string.equals(string2)) {
                return string2;
            }
            stringArray[n2] = string;
        }
        return string;
    }

    public static String fromCacheOrNew(String string) {
        if (!SysProperties.OBJECT_CACHE) {
            return string;
        }
        if (string == null) {
            return string;
        }
        if (string.length() == 0) {
            return "";
        }
        int n = string.hashCode();
        String[] stringArray = StringUtils.getCache();
        int n2 = n & SysProperties.OBJECT_CACHE_SIZE - 1;
        if (stringArray == null) {
            return string;
        }
        String string2 = stringArray[n2];
        if (string2 != null && string.equals(string2)) {
            return string2;
        }
        stringArray[n2] = string = new String(string);
        return string;
    }

    public static byte[] convertHexToBytes(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            throw DbException.get(90003, string);
        }
        byte[] byArray = new byte[n /= 2];
        int n2 = 0;
        int[] nArray = HEX_DECODE;
        try {
            for (int i = 0; i < n; ++i) {
                int n3 = nArray[string.charAt(i + i)] << 4 | nArray[string.charAt(i + i + 1)];
                n2 |= n3;
                byArray[i] = (byte)n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw DbException.get(90004, string);
        }
        if ((n2 & 0xFFFFFF00) != 0) {
            throw DbException.get(90004, string);
        }
        return byArray;
    }

    public static String convertBytesToHex(byte[] byArray) {
        return StringUtils.convertBytesToHex(byArray, byArray.length);
    }

    public static String convertBytesToHex(byte[] byArray, int n) {
        char[] cArray = new char[n + n];
        char[] cArray2 = HEX;
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            cArray[i + i] = cArray2[n2 >> 4];
            cArray[i + i + 1] = cArray2[n2 & 0xF];
        }
        return new String(cArray);
    }

    public static boolean isNumber(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static void appendZeroPadded(StringBuilder stringBuilder, int n, long l) {
        if (n == 2) {
            if (l < 10L) {
                stringBuilder.append('0');
            }
            stringBuilder.append(l);
        } else {
            String string = Long.toString(l);
            n -= string.length();
            while (n > 0) {
                stringBuilder.append('0');
                --n;
            }
            stringBuilder.append(string);
        }
    }

    public static String escapeMetaDataPattern(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return StringUtils.replaceAll(string, "\\", "\\\\");
    }

    static {
        int n;
        softCache = new SoftReference<Object>(null);
        HEX = "0123456789abcdef".toCharArray();
        HEX_DECODE = new int[103];
        for (n = 0; n < HEX_DECODE.length; ++n) {
            StringUtils.HEX_DECODE[n] = -1;
        }
        for (n = 0; n <= 9; ++n) {
            StringUtils.HEX_DECODE[n + 48] = n;
        }
        for (n = 0; n <= 5; ++n) {
            int n2 = n + 10;
            StringUtils.HEX_DECODE[n + 65] = n2;
            StringUtils.HEX_DECODE[n + 97] = n2;
        }
    }
}

