/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.mvstore;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.Cursor;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.DataUtils;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.MVStore;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.Page;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.type.DataType;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.type.ObjectDataType;
import org.glowroot.agent.embedded.shaded.org.h2.util.New;

public class MVMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    protected MVStore store;
    protected volatile Page root;
    protected volatile long writeVersion;
    protected volatile long currentWriteVersion = -1L;
    private int id;
    private long createVersion;
    private final DataType keyType;
    private final DataType valueType;
    private ArrayList<Page> oldRoots = new ArrayList();
    private boolean closed;
    private boolean readOnly;

    protected MVMap(DataType dataType, DataType dataType2) {
        this.keyType = dataType;
        this.valueType = dataType2;
        this.root = Page.createEmpty(this, -1L);
    }

    protected void init(MVStore mVStore, HashMap<String, Object> hashMap) {
        this.store = mVStore;
        this.id = DataUtils.readHexInt(hashMap, "id", 0);
        this.createVersion = DataUtils.readHexLong(hashMap, "createVersion", 0L);
        this.writeVersion = mVStore.getCurrentVersion();
    }

    protected Page copyOnWrite(Page page, long l) {
        if (page.getVersion() == l) {
            return page;
        }
        return page.copy(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
        this.beforeWrite();
        try {
            long l = this.writeVersion;
            Page page = this.copyOnWrite(this.root, l);
            page = this.splitRootIfNeeded(page, l);
            Object object = this.put(page, l, k, v);
            this.newRoot(page);
            Object object2 = object;
            return (V)object2;
        }
        finally {
            this.afterWrite();
        }
    }

    protected Page splitRootIfNeeded(Page page, long l) {
        if (page.getMemory() <= this.store.getPageSplitSize() || page.getKeyCount() <= 1) {
            return page;
        }
        int n = page.getKeyCount() / 2;
        long l2 = page.getTotalCount();
        Object object = page.getKey(n);
        Page page2 = page.split(n);
        Object[] objectArray = new Object[]{object};
        long[] lArray = new long[]{page.getPos(), page2.getPos()};
        Page[] pageArray = new Page[]{page, page2};
        long[] lArray2 = new long[]{page.getTotalCount(), page2.getTotalCount()};
        page = Page.create(this, l, 1, objectArray, null, 2, lArray, pageArray, lArray2, l2, 0, 0);
        return page;
    }

    protected Object put(Page page, long l, Object object, Object object2) {
        int n = page.binarySearch(object);
        if (page.isLeaf()) {
            if (n < 0) {
                n = -n - 1;
                page.insertLeaf(n, object, object2);
                return null;
            }
            return page.setValue(n, object2);
        }
        n = n < 0 ? -n - 1 : ++n;
        Page page2 = this.copyOnWrite(page.getChildPage(n), l);
        if (page2.getMemory() > this.store.getPageSplitSize() && page2.getKeyCount() > 1) {
            int n2 = page2.getKeyCount() / 2;
            Object object3 = page2.getKey(n2);
            Page page3 = page2.split(n2);
            page.setChild(n, page3);
            page.setCounts(n, page3);
            page.insertNode(n, object3, page2);
            return this.put(page, l, object, object2);
        }
        page.setChild(n, page2);
        Object object4 = this.put(page2, l, object, object2);
        page.setCounts(n, page2);
        return object4;
    }

    public K firstKey() {
        return this.getFirstLast(true);
    }

    public K lastKey() {
        return this.getFirstLast(false);
    }

    public K getKey(long l) {
        if (l < 0L || l >= (long)this.size()) {
            return null;
        }
        Page page = this.root;
        long l2 = 0L;
        while (true) {
            long l3;
            int n;
            if (page.isLeaf()) {
                if (l >= l2 + (long)page.getKeyCount()) {
                    return null;
                }
                return (K)page.getKey((int)(l - l2));
            }
            int n2 = page.getChildPageCount();
            for (n = 0; n < n2 && l >= (l3 = page.getCounts(n)) + l2; ++n) {
                l2 += l3;
            }
            if (n == n2) {
                return null;
            }
            page = page.getChildPage(n);
        }
    }

    public long getKeyIndex(K k) {
        if (this.size() == 0) {
            return -1L;
        }
        Page page = this.root;
        long l = 0L;
        while (true) {
            int n = page.binarySearch(k);
            if (page.isLeaf()) {
                if (n < 0) {
                    return -l + (long)n;
                }
                return l + (long)n;
            }
            n = n < 0 ? -n - 1 : ++n;
            for (int i = 0; i < n; ++i) {
                l += page.getCounts(i);
            }
            page = page.getChildPage(n);
        }
    }

    protected K getFirstLast(boolean bl) {
        if (this.size() == 0) {
            return null;
        }
        Page page = this.root;
        while (!page.isLeaf()) {
            page = page.getChildPage(bl ? 0 : page.getChildPageCount() - 1);
        }
        return (K)page.getKey(bl ? 0 : page.getKeyCount() - 1);
    }

    public K higherKey(K k) {
        return this.getMinMax(k, false, true);
    }

    public K ceilingKey(K k) {
        return this.getMinMax(k, false, false);
    }

    public K floorKey(K k) {
        return this.getMinMax(k, true, false);
    }

    public K lowerKey(K k) {
        return this.getMinMax(k, true, true);
    }

    protected K getMinMax(K k, boolean bl, boolean bl2) {
        return this.getMinMax(this.root, k, bl, bl2);
    }

    private K getMinMax(Page page, K k, boolean bl, boolean bl2) {
        if (page.isLeaf()) {
            int n = page.binarySearch(k);
            if (n < 0) {
                n = -n - (bl ? 2 : 1);
            } else if (bl2) {
                n += bl ? -1 : 1;
            }
            if (n < 0 || n >= page.getKeyCount()) {
                return null;
            }
            return (K)page.getKey(n);
        }
        int n = page.binarySearch(k);
        n = n < 0 ? -n - 1 : ++n;
        while (n >= 0 && n < page.getChildPageCount()) {
            K k2 = this.getMinMax(page.getChildPage(n), k, bl, bl2);
            if (k2 != null) {
                return k2;
            }
            n += bl ? -1 : 1;
        }
        return null;
    }

    @Override
    public V get(Object object) {
        return (V)this.binarySearch(this.root, object);
    }

    protected Object binarySearch(Page page, Object object) {
        int n = page.binarySearch(object);
        if (!page.isLeaf()) {
            n = n < 0 ? -n - 1 : ++n;
            page = page.getChildPage(n);
            return this.binarySearch(page, object);
        }
        if (n >= 0) {
            return page.getValue(n);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    protected Page getPage(K k) {
        return this.binarySearchPage(this.root, k);
    }

    protected Page binarySearchPage(Page page, Object object) {
        int n = page.binarySearch(object);
        if (!page.isLeaf()) {
            n = n < 0 ? -n - 1 : ++n;
            page = page.getChildPage(n);
            return this.binarySearchPage(page, object);
        }
        if (n >= 0) {
            return page;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.beforeWrite();
        try {
            this.root.removeAllRecursive();
            this.newRoot(Page.createEmpty(this, this.writeVersion));
        }
        finally {
            this.afterWrite();
        }
    }

    void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object) {
        this.beforeWrite();
        try {
            long l = this.writeVersion;
            Page page = this.copyOnWrite(this.root, l);
            Object object2 = this.remove(page, l, object);
            if (!page.isLeaf() && page.getTotalCount() == 0L) {
                page.removePage();
                page = Page.createEmpty(this, page.getVersion());
            }
            this.newRoot(page);
            Object object3 = object2;
            return (V)object3;
        }
        finally {
            this.afterWrite();
        }
    }

    @Override
    public synchronized V putIfAbsent(K k, V v) {
        V v2 = this.get(k);
        if (v2 == null) {
            this.put(k, v);
        }
        return v2;
    }

    @Override
    public synchronized boolean remove(Object object, Object object2) {
        V v = this.get(object);
        if (this.areValuesEqual(v, object2)) {
            this.remove(object);
            return true;
        }
        return false;
    }

    public boolean areValuesEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return this.valueType.compare(object, object2) == 0;
    }

    @Override
    public synchronized boolean replace(K k, V v, V v2) {
        V v3 = this.get(k);
        if (this.areValuesEqual(v3, v)) {
            this.put(k, v2);
            return true;
        }
        return false;
    }

    @Override
    public synchronized V replace(K k, V v) {
        V v2 = this.get(k);
        if (v2 != null) {
            this.put(k, v);
            return v2;
        }
        return null;
    }

    protected Object remove(Page page, long l, Object object) {
        int n = page.binarySearch(object);
        Object object2 = null;
        if (page.isLeaf()) {
            if (n >= 0) {
                object2 = page.getValue(n);
                page.remove(n);
            }
            return object2;
        }
        n = n < 0 ? -n - 1 : ++n;
        Page page2 = page.getChildPage(n);
        Page page3 = this.copyOnWrite(page2, l);
        object2 = this.remove(page3, l, object);
        if (object2 == null || page3.getTotalCount() != 0L) {
            page.setChild(n, page3);
            page.setCounts(n, page3);
        } else if (page.getKeyCount() == 0) {
            page.setChild(n, page3);
            page.setCounts(n, page3);
            page3.removePage();
        } else {
            page.remove(n);
        }
        return object2;
    }

    protected void newRoot(Page page) {
        if (this.root != page) {
            this.removeUnusedOldVersions();
            if (this.root.getVersion() != page.getVersion()) {
                ArrayList<Page> arrayList = this.oldRoots;
                if (arrayList.size() > 0) {
                    Page page2 = arrayList.get(arrayList.size() - 1);
                    if (page2.getVersion() != this.root.getVersion()) {
                        arrayList.add(this.root);
                    }
                } else {
                    arrayList.add(this.root);
                }
            }
            this.root = page;
        }
    }

    int compare(Object object, Object object2) {
        return this.keyType.compare(object, object2);
    }

    public DataType getKeyType() {
        return this.keyType;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    Page readPage(long l) {
        return this.store.readPage(this, l);
    }

    void setRootPos(long l, long l2) {
        this.root = l == 0L ? Page.createEmpty(this, -1L) : this.readPage(l);
        this.root.setVersion(l2);
    }

    public Iterator<K> keyIterator(K k) {
        return new Cursor(this, this.root, k);
    }

    public Cursor<K, V> cursor(K k) {
        return new Cursor(this, this.root, k);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final MVMap mVMap = this;
        final Page page = this.root;
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Cursor cursor = new Cursor(mVMap, page, null);
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return cursor.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Object k = cursor.next();
                        return new DataUtils.MapEntry(k, cursor.getValue());
                    }

                    @Override
                    public void remove() {
                        throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                    }
                };
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return MVMap.this.containsKey(object);
            }
        };
    }

    @Override
    public Set<K> keySet() {
        final MVMap mVMap = this;
        final Page page = this.root;
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Cursor(mVMap, page, null);
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return MVMap.this.containsKey(object);
            }
        };
    }

    public Page getRoot() {
        return this.root;
    }

    public String getName() {
        return this.store.getMapName(this.id);
    }

    public MVStore getStore() {
        return this.store;
    }

    public int getId() {
        return this.id;
    }

    void removeUnusedOldVersions() {
        long l = this.store.getOldestVersionToKeep();
        if (l == -1L) {
            return;
        }
        int n = this.searchRoot(l);
        if (n < 0) {
            n = -n - 1;
        }
        if (--n <= 0) {
            return;
        }
        int n2 = this.oldRoots.size() - n;
        ArrayList<Page> arrayList = new ArrayList<Page>(n2);
        arrayList.addAll(this.oldRoots.subList(n, this.oldRoots.size()));
        this.oldRoots = arrayList;
    }

    protected void beforeWrite() {
        if (this.closed) {
            throw DataUtils.newIllegalStateException(4, "This map is closed", new Object[0]);
        }
        if (this.readOnly) {
            throw DataUtils.newUnsupportedOperationException("This map is read-only");
        }
        this.checkConcurrentWrite();
        this.store.beforeWrite();
        this.currentWriteVersion = this.writeVersion;
    }

    protected void checkConcurrentWrite() {
        if (this.currentWriteVersion != -1L) {
            throw DataUtils.newConcurrentModificationException(this.getName());
        }
    }

    protected void afterWrite() {
        this.currentWriteVersion = -1L;
    }

    protected void waitUntilWritten(long l) {
        if (this.readOnly) {
            throw DataUtils.newIllegalStateException(3, "Waiting for writes to a read-only map", new Object[0]);
        }
        while (this.currentWriteVersion == l) {
            Thread.yield();
        }
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int size() {
        long l = this.sizeAsLong();
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public long sizeAsLong() {
        return this.root.getTotalCount();
    }

    @Override
    public boolean isEmpty() {
        return this.root.isLeaf() && this.root.getKeyCount() == 0;
    }

    public long getCreateVersion() {
        return this.createVersion;
    }

    protected void removePage(long l, int n) {
        this.store.removePage(this, l, n);
    }

    public MVMap<K, V> openVersion(long l) {
        if (this.readOnly) {
            throw DataUtils.newUnsupportedOperationException("This map is read-only; need to call the method on the writable map");
        }
        DataUtils.checkArgument(l >= this.createVersion, "Unknown version {0}; this map was created in version is {1}", l, this.createVersion);
        Page page = null;
        Page page2 = this.root;
        if (l >= page2.getVersion() && (l == this.writeVersion || page2.getVersion() >= 0L || l <= this.createVersion || this.store.getFileStore() == null)) {
            page = page2;
        } else {
            int n = this.searchRoot(l);
            if (n < 0) {
                if (n == -1) {
                    return this.store.openMapVersion(l, this.id, this);
                }
                n = -n - 2;
            }
            page = this.oldRoots.get(n);
        }
        MVMap<K, V> mVMap = this.openReadOnly();
        mVMap.root = page;
        return mVMap;
    }

    MVMap<K, V> openReadOnly() {
        MVMap<K, V> mVMap = new MVMap<K, V>(this.keyType, this.valueType);
        mVMap.readOnly = true;
        HashMap<String, Object> hashMap = New.hashMap();
        hashMap.put("id", this.id);
        hashMap.put("createVersion", this.createVersion);
        mVMap.init(this.store, hashMap);
        mVMap.root = this.root;
        return mVMap;
    }

    private int searchRoot(long l) {
        int n = 0;
        int n2 = this.oldRoots.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            long l2 = this.oldRoots.get(n3).getVersion();
            if (l2 < l) {
                n = n3 + 1;
                continue;
            }
            if (l < l2) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public long getVersion() {
        return this.root.getVersion();
    }

    protected int getChildPageCount(Page page) {
        return page.getChildPageCount();
    }

    public String getType() {
        return null;
    }

    String asString(String string) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            DataUtils.appendMap(stringBuilder, "name", string);
        }
        if (this.createVersion != 0L) {
            DataUtils.appendMap(stringBuilder, "createVersion", this.createVersion);
        }
        if ((string2 = this.getType()) != null) {
            DataUtils.appendMap(stringBuilder, "type", string2);
        }
        return stringBuilder.toString();
    }

    void setWriteVersion(long l) {
        this.writeVersion = l;
    }

    @Override
    public String toString() {
        return this.asString(null);
    }

    public static class Builder<K, V>
    implements MapBuilder<MVMap<K, V>, K, V> {
        protected DataType keyType;
        protected DataType valueType;

        public Builder<K, V> keyType(DataType dataType) {
            this.keyType = dataType;
            return this;
        }

        public Builder<K, V> valueType(DataType dataType) {
            this.valueType = dataType;
            return this;
        }

        @Override
        public MVMap<K, V> create() {
            if (this.keyType == null) {
                this.keyType = new ObjectDataType();
            }
            if (this.valueType == null) {
                this.valueType = new ObjectDataType();
            }
            return new MVMap(this.keyType, this.valueType);
        }
    }

    public static interface MapBuilder<M extends MVMap<K, V>, K, V> {
        public M create();
    }
}

