/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TraceCommonService;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

@JsonService
class TraceJsonService {
    private static final Logger logger = LoggerFactory.getLogger(TraceJsonService.class);
    private final TraceCommonService traceCommonService;

    TraceJsonService(TraceCommonService traceCommonService) {
        this.traceCommonService = traceCommonService;
    }

    @GET(path="/backend/trace/header", permission="agent:trace")
    String getHeader(@BindAgentId String agentId, @BindRequest HeaderRequest request) throws Exception {
        String headerJson = this.traceCommonService.getHeaderJson(agentId, request.traceId(), request.checkLiveTraces());
        if (headerJson == null) {
            logger.debug("no trace found for agent id '{}' and trace id '{}'", (Object)agentId, (Object)request.traceId());
            return "{\"expired\":true}";
        }
        return headerJson;
    }

    @Value.Immutable
    static abstract class HeaderRequest {
        HeaderRequest() {
        }

        abstract String traceId();

        @Value.Default
        boolean checkLiveTraces() {
            return false;
        }
    }
}

