/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AgentDisplayRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableTraceExport;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;
import org.glowroot.agent.shaded.com.google.common.collect.Iterators;
import org.glowroot.agent.shaded.com.google.common.collect.PeekingIterator;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveJvmService;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveTraceRepository;
import org.glowroot.agent.shaded.org.glowroot.common.model.MutableProfile;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;
import org.immutables.value.Value;

class TraceCommonService {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final TraceRepository traceRepository;
    private final LiveTraceRepository liveTraceRepository;
    private final AgentDisplayRepository agentDisplayRepository;

    TraceCommonService(TraceRepository traceRepository, LiveTraceRepository liveTraceRepository, AgentDisplayRepository agentDisplayRepository) {
        this.traceRepository = traceRepository;
        this.liveTraceRepository = liveTraceRepository;
        this.agentDisplayRepository = agentDisplayRepository;
    }

    @Nullable String getHeaderJson(String agentId, String traceId, boolean checkLiveTraces) throws Exception {
        Object header;
        if (checkLiveTraces) {
            try {
                header = this.liveTraceRepository.getHeader(agentId, traceId);
            }
            catch (LiveJvmService.AgentNotConnectedException e) {
                header = null;
            }
            catch (TimeoutException e) {
                header = null;
            }
            if (header != null) {
                return this.toJsonLiveHeader(agentId, (TraceOuterClass.Trace.Header)header);
            }
        }
        if ((header = this.getStoredHeader(agentId, traceId, new RetryCountdown(checkLiveTraces))) == null) {
            return null;
        }
        return this.toJsonRepoHeader(agentId, (TraceRepository.HeaderPlus)header);
    }

    @Nullable String getEntriesJson(String agentId, String traceId, boolean checkLiveTraces, CassandraProfile profile) throws Exception {
        if (checkLiveTraces) {
            LiveTraceRepository.Entries entries;
            try {
                entries = this.liveTraceRepository.getEntries(agentId, traceId);
            }
            catch (LiveJvmService.AgentNotConnectedException e) {
                entries = null;
            }
            catch (TimeoutException e) {
                entries = null;
            }
            if (entries != null) {
                return TraceCommonService.toJson(entries);
            }
        }
        return TraceCommonService.toJson(this.getStoredEntries(agentId, traceId, new RetryCountdown(checkLiveTraces), profile));
    }

    @Nullable String getQueriesJson(String agentId, String traceId, boolean checkLiveTraces) throws Exception {
        if (checkLiveTraces) {
            LiveTraceRepository.Queries queries;
            try {
                queries = this.liveTraceRepository.getQueries(agentId, traceId);
            }
            catch (LiveJvmService.AgentNotConnectedException e) {
                queries = null;
            }
            catch (TimeoutException e) {
                queries = null;
            }
            if (queries != null) {
                return TraceCommonService.toJson(queries);
            }
        }
        return TraceCommonService.toJson(this.getStoredQueries(agentId, traceId, new RetryCountdown(checkLiveTraces), CassandraProfile.web));
    }

    @Nullable String getMainThreadProfileJson(String agentId, String traceId, boolean checkLiveTraces) throws Exception {
        return TraceCommonService.toJson(this.getMainThreadProfile(agentId, traceId, checkLiveTraces));
    }

    @Nullable String getAuxThreadProfileJson(String agentId, String traceId, boolean checkLiveTraces) throws Exception {
        return TraceCommonService.toJson(this.getAuxThreadProfile(agentId, traceId, checkLiveTraces));
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ProfileOuterClass.Profile getMainThreadProfile(String agentId, String traceId, boolean checkLiveTraces) throws Exception {
        if (checkLiveTraces) {
            ProfileOuterClass.Profile profile;
            try {
                profile = this.liveTraceRepository.getMainThreadProfile(agentId, traceId);
            }
            catch (LiveJvmService.AgentNotConnectedException e) {
                profile = null;
            }
            catch (TimeoutException e) {
                profile = null;
            }
            if (profile != null) {
                return profile;
            }
        }
        return this.getStoredMainThreadProfile(agentId, traceId, new RetryCountdown(checkLiveTraces));
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ProfileOuterClass.Profile getAuxThreadProfile(String agentId, String traceId, boolean checkLiveTraces) throws Exception {
        if (checkLiveTraces) {
            ProfileOuterClass.Profile profile;
            try {
                profile = this.liveTraceRepository.getAuxThreadProfile(agentId, traceId);
            }
            catch (LiveJvmService.AgentNotConnectedException e) {
                profile = null;
            }
            catch (TimeoutException e) {
                profile = null;
            }
            if (profile != null) {
                return profile;
            }
        }
        return this.getStoredAuxThreadProfile(agentId, traceId, new RetryCountdown(checkLiveTraces));
    }

    @Nullable TraceExport getExport(String agentId, String traceId, boolean checkLiveTraces, CassandraProfile profile) throws Exception {
        RetryCountdown retryCountdown;
        Object header;
        if (checkLiveTraces) {
            TraceOuterClass.Trace trace;
            try {
                trace = this.liveTraceRepository.getFullTrace(agentId, traceId);
            }
            catch (LiveJvmService.AgentNotConnectedException e) {
                trace = null;
            }
            catch (TimeoutException e) {
                trace = null;
            }
            if (trace != null) {
                header = trace.getHeader();
                return ImmutableTraceExport.builder().fileName(TraceCommonService.getFileName((TraceOuterClass.Trace.Header)header)).headerJson(this.toJsonLiveHeader(agentId, (TraceOuterClass.Trace.Header)header)).entriesJson(TraceCommonService.entriesToJson(trace.getEntryList())).queriesJson(TraceCommonService.queriesToJson(trace.getQueryList())).sharedQueryTextsJson(TraceCommonService.sharedQueryTextsToJson(trace.getSharedQueryTextList())).mainThreadProfileJson(TraceCommonService.toJson(trace.getMainThreadProfile())).auxThreadProfileJson(TraceCommonService.toJson(trace.getAuxThreadProfile())).build();
            }
        }
        if ((header = this.getStoredHeader(agentId, traceId, retryCountdown = new RetryCountdown(checkLiveTraces))) == null) {
            return null;
        }
        ImmutableTraceExport.Builder builder = ImmutableTraceExport.builder().fileName(TraceCommonService.getFileName(header.header())).headerJson(this.toJsonRepoHeader(agentId, (TraceRepository.HeaderPlus)header));
        LiveTraceRepository.EntriesAndQueries queriesAndEntries = this.getStoredEntriesAndQueriesForExport(agentId, traceId, retryCountdown, profile);
        if (queriesAndEntries != null) {
            builder.entriesJson(TraceCommonService.entriesToJson(queriesAndEntries.entries()));
            builder.queriesJson(TraceCommonService.queriesToJson(queriesAndEntries.queries()));
            builder.sharedQueryTextsJson(TraceCommonService.sharedQueryTextsToJson(queriesAndEntries.sharedQueryTexts()));
        }
        builder.mainThreadProfileJson(TraceCommonService.toJson(this.getStoredMainThreadProfile(agentId, traceId, retryCountdown)));
        builder.auxThreadProfileJson(TraceCommonService.toJson(this.getStoredAuxThreadProfile(agentId, traceId, retryCountdown)));
        return builder.build();
    }

    private TraceRepository.HeaderPlus getStoredHeader(String agentId, String traceId, RetryCountdown retryCountdown) throws Exception {
        TraceRepository.HeaderPlus headerPlus = this.traceRepository.readHeaderPlus(agentId, traceId).toCompletableFuture().get();
        while (headerPlus == null && retryCountdown.remaining-- > 0) {
            TimeUnit.MILLISECONDS.sleep(500L);
            headerPlus = this.traceRepository.readHeaderPlus(agentId, traceId).toCompletableFuture().get();
        }
        return headerPlus;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LiveTraceRepository.Entries getStoredEntries(String agentId, String traceId, RetryCountdown retryCountdown, CassandraProfile profile) throws Exception {
        LiveTraceRepository.Entries entries = this.traceRepository.readEntries(agentId, traceId, profile).toCompletableFuture().get();
        while (entries == null && retryCountdown.remaining-- > 0) {
            TimeUnit.MILLISECONDS.sleep(500L);
            entries = this.traceRepository.readEntries(agentId, traceId, profile).toCompletableFuture().get();
        }
        return entries;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LiveTraceRepository.Queries getStoredQueries(String agentId, String traceId, RetryCountdown retryCountdown, CassandraProfile profile) throws Exception {
        LiveTraceRepository.Queries queries = this.traceRepository.readQueries(agentId, traceId, profile).toCompletableFuture().get();
        while (queries == null && retryCountdown.remaining-- > 0) {
            TimeUnit.MILLISECONDS.sleep(500L);
            queries = this.traceRepository.readQueries(agentId, traceId, profile).toCompletableFuture().get();
        }
        return queries;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LiveTraceRepository.EntriesAndQueries getStoredEntriesAndQueriesForExport(String agentId, String traceId, RetryCountdown retryCountdown, CassandraProfile profile) throws Exception {
        LiveTraceRepository.EntriesAndQueries entries = this.traceRepository.readEntriesAndQueriesForExport(agentId, traceId, profile).toCompletableFuture().get();
        while (entries == null && retryCountdown.remaining-- > 0) {
            TimeUnit.MILLISECONDS.sleep(500L);
            entries = this.traceRepository.readEntriesAndQueriesForExport(agentId, traceId, profile).toCompletableFuture().get();
        }
        return entries;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ProfileOuterClass.Profile getStoredMainThreadProfile(String agentId, String traceId, RetryCountdown retryCountdown) throws Exception {
        ProfileOuterClass.Profile profile = this.traceRepository.readMainThreadProfile(agentId, traceId).toCompletableFuture().get();
        while (profile == null && retryCountdown.remaining-- > 0) {
            TimeUnit.MILLISECONDS.sleep(500L);
            profile = this.traceRepository.readMainThreadProfile(agentId, traceId).toCompletableFuture().get();
        }
        return profile;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ProfileOuterClass.Profile getStoredAuxThreadProfile(String agentId, String traceId, RetryCountdown retryCountdown) throws Exception {
        ProfileOuterClass.Profile profile = this.traceRepository.readAuxThreadProfile(agentId, traceId).toCompletableFuture().get();
        while (profile == null && retryCountdown.remaining-- > 0) {
            TimeUnit.MILLISECONDS.sleep(500L);
            profile = this.traceRepository.readAuxThreadProfile(agentId, traceId).toCompletableFuture().get();
        }
        return profile;
    }

    private static @Nullable String toJson(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LiveTraceRepository.Entries entries) throws IOException {
        if (entries == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeFieldName("entries");
            TraceCommonService.writeEntries(jg, entries.entries());
            jg.writeFieldName("sharedQueryTexts");
            TraceCommonService.writeSharedQueryTexts(jg, entries.sharedQueryTexts());
            jg.writeEndObject();
        }
        return sb.toString();
    }

    private static @Nullable String toJson(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LiveTraceRepository.Queries queries) throws IOException {
        if (queries == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeFieldName("queries");
            TraceCommonService.writeQueries(jg, queries.queries());
            jg.writeFieldName("sharedQueryTexts");
            TraceCommonService.writeSharedQueryTexts(jg, queries.sharedQueryTexts());
            jg.writeEndObject();
        }
        return sb.toString();
    }

    @VisibleForTesting
    static @Nullable String entriesToJson(List<TraceOuterClass.Trace.Entry> entries) throws IOException {
        if (entries.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter((Appendable)sb));){
            TraceCommonService.writeEntries(jg, entries);
        }
        return sb.toString();
    }

    @VisibleForTesting
    static @Nullable String queriesToJson(List<AggregateOuterClass.Aggregate.Query> queries) throws IOException {
        if (queries.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter((Appendable)sb));){
            TraceCommonService.writeQueries(jg, queries);
        }
        return sb.toString();
    }

    private static @Nullable String sharedQueryTextsToJson(List<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts) throws IOException {
        if (sharedQueryTexts.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter((Appendable)sb));){
            TraceCommonService.writeSharedQueryTexts(jg, sharedQueryTexts);
        }
        return sb.toString();
    }

    private static void writeEntries(JsonGenerator jg, List<TraceOuterClass.Trace.Entry> entries) throws IOException {
        jg.writeStartArray();
        PeekingIterator i = Iterators.peekingIterator(entries.iterator());
        while (i.hasNext()) {
            int nextDepth;
            TraceOuterClass.Trace.Entry entry = (TraceOuterClass.Trace.Entry)i.next();
            int depth = entry.getDepth();
            jg.writeStartObject();
            TraceCommonService.writeJson(entry, jg);
            int n = nextDepth = i.hasNext() ? ((TraceOuterClass.Trace.Entry)i.peek()).getDepth() : 0;
            if (nextDepth > depth) {
                jg.writeArrayFieldStart("childEntries");
                continue;
            }
            if (nextDepth < depth) {
                jg.writeEndObject();
                for (int j = depth; j > nextDepth; --j) {
                    jg.writeEndArray();
                    jg.writeEndObject();
                }
                continue;
            }
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    private static void writeQueries(JsonGenerator jg, List<AggregateOuterClass.Aggregate.Query> queries) throws IOException {
        jg.writeStartArray();
        for (AggregateOuterClass.Aggregate.Query query : queries) {
            jg.writeStartObject();
            TraceCommonService.writeJson(query, jg);
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    private static void writeSharedQueryTexts(JsonGenerator jg, List<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts) throws IOException {
        jg.writeStartArray();
        for (TraceOuterClass.Trace.SharedQueryText sharedQueryText : sharedQueryTexts) {
            jg.writeStartObject();
            String fullText = sharedQueryText.getFullText();
            if (fullText.isEmpty()) {
                jg.writeStringField("truncatedText", sharedQueryText.getTruncatedText());
                jg.writeStringField("truncatedEndText", sharedQueryText.getTruncatedEndText());
                jg.writeStringField("fullTextSha1", sharedQueryText.getFullTextSha1());
            } else {
                jg.writeStringField("fullText", fullText);
            }
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    private static @Nullable String toJson(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ProfileOuterClass.Profile profile) throws IOException {
        if (profile == null) {
            return null;
        }
        MutableProfile mutableProfile = new MutableProfile();
        mutableProfile.merge(profile);
        return mutableProfile.toJson();
    }

    private String toJsonLiveHeader(String agentId, TraceOuterClass.Trace.Header header) throws Exception {
        boolean hasProfile = header.getMainThreadProfileSampleCount() > 0L || header.getAuxThreadProfileSampleCount() > 0L;
        return this.toJson(agentId, header, header.getPartial(), header.getEntryCount() > 0 ? LiveTraceRepository.Existence.YES : LiveTraceRepository.Existence.NO, header.getQueryCount() > 0 ? LiveTraceRepository.Existence.YES : LiveTraceRepository.Existence.NO, hasProfile ? LiveTraceRepository.Existence.YES : LiveTraceRepository.Existence.NO);
    }

    private String toJsonRepoHeader(String agentId, TraceRepository.HeaderPlus header) throws Exception {
        return this.toJson(agentId, header.header(), false, header.entriesExistence(), header.queriesExistence(), header.profileExistence());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toJson(String agentId, TraceOuterClass.Trace.Header header, boolean active, LiveTraceRepository.Existence entriesExistence, LiveTraceRepository.Existence queriesExistence, LiveTraceRepository.Existence profileExistence) throws Exception {
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter((Appendable)sb));){
            List locationStackTraceElements;
            List detailEntries;
            boolean async;
            boolean partial;
            jg.writeStartObject();
            if (!agentId.isEmpty()) {
                jg.writeStringField("agent", this.agentDisplayRepository.readFullDisplay(agentId).toCompletableFuture().get());
            }
            if (active) {
                jg.writeBooleanField("active", active);
            }
            if (partial = header.getPartial()) {
                jg.writeBooleanField("partial", partial);
            }
            if (async = header.getAsync()) {
                jg.writeBooleanField("async", async);
            }
            jg.writeNumberField("startTime", header.getStartTime());
            jg.writeNumberField("captureTime", header.getCaptureTime());
            jg.writeNumberField("durationNanos", header.getDurationNanos());
            jg.writeStringField("transactionType", header.getTransactionType());
            jg.writeStringField("transactionName", header.getTransactionName());
            jg.writeStringField("headline", header.getHeadline());
            jg.writeStringField("user", header.getUser());
            List attributes = header.getAttributeList();
            if (!attributes.isEmpty()) {
                jg.writeObjectFieldStart("attributes");
                for (TraceOuterClass.Trace.Attribute attribute : attributes) {
                    jg.writeArrayFieldStart(attribute.getName());
                    for (String value : attribute.getValueList()) {
                        jg.writeString(value);
                    }
                    jg.writeEndArray();
                }
                jg.writeEndObject();
            }
            if (!(detailEntries = header.getDetailEntryList()).isEmpty()) {
                jg.writeFieldName("detail");
                TraceCommonService.writeDetailEntries(detailEntries, jg);
            }
            if (!(locationStackTraceElements = header.getLocationStackTraceElementList()).isEmpty()) {
                jg.writeArrayFieldStart("locationStackTraceElements");
                for (Proto.StackTraceElement stackTraceElement : locationStackTraceElements) {
                    TraceCommonService.writeStackTraceElement(stackTraceElement, jg);
                }
                jg.writeEndArray();
            }
            if (header.hasError()) {
                jg.writeFieldName("error");
                TraceCommonService.writeError(header.getError(), jg);
            }
            jg.writeFieldName("mainThreadRootTimer");
            TraceCommonService.writeTimer(header.getMainThreadRootTimer(), jg);
            jg.writeFieldName("mainThreadStats");
            if (header.hasOldMainThreadStats()) {
                TraceCommonService.writeOldThreadStats(header.getOldMainThreadStats(), jg);
            } else {
                TraceCommonService.writeThreadStats(header.getMainThreadStats(), jg);
            }
            if (header.hasAuxThreadRootTimer()) {
                jg.writeFieldName("auxThreadRootTimer");
                TraceCommonService.writeTimer(header.getAuxThreadRootTimer(), jg);
                jg.writeFieldName("auxThreadStats");
                if (header.hasOldAuxThreadStats()) {
                    TraceCommonService.writeOldThreadStats(header.getOldAuxThreadStats(), jg);
                } else {
                    TraceCommonService.writeThreadStats(header.getAuxThreadStats(), jg);
                }
            }
            jg.writeArrayFieldStart("asyncTimers");
            for (TraceOuterClass.Trace.Timer asyncTimer : header.getAsyncTimerList()) {
                TraceCommonService.writeTimer(asyncTimer, jg);
            }
            jg.writeEndArray();
            jg.writeNumberField("entryCount", header.getEntryCount());
            boolean entryLimitExceeded = header.getEntryLimitExceeded();
            if (entryLimitExceeded) {
                jg.writeBooleanField("entryLimitExceeded", entryLimitExceeded);
            }
            jg.writeNumberField("queryCount", header.getQueryCount());
            boolean queryLimitExceeded = header.getQueryLimitExceeded();
            if (queryLimitExceeded) {
                jg.writeBooleanField("queryLimitExceeded", queryLimitExceeded);
            }
            jg.writeNumberField("mainThreadProfileSampleCount", header.getMainThreadProfileSampleCount());
            boolean mainThreadProfileSampleLimitExceeded = header.getMainThreadProfileSampleLimitExceeded();
            if (mainThreadProfileSampleLimitExceeded) {
                jg.writeBooleanField("mainThreadProfileSampleLimitExceeded", mainThreadProfileSampleLimitExceeded);
            }
            jg.writeNumberField("auxThreadProfileSampleCount", header.getAuxThreadProfileSampleCount());
            boolean auxThreadProfileSampleLimitExceeded = header.getAuxThreadProfileSampleLimitExceeded();
            if (auxThreadProfileSampleLimitExceeded) {
                jg.writeBooleanField("auxThreadProfileSampleLimitExceeded", auxThreadProfileSampleLimitExceeded);
            }
            jg.writeStringField("entriesExistence", entriesExistence.name().toLowerCase(Locale.ENGLISH));
            jg.writeStringField("queriesExistence", queriesExistence.name().toLowerCase(Locale.ENGLISH));
            jg.writeStringField("profileExistence", profileExistence.name().toLowerCase(Locale.ENGLISH));
            jg.writeEndObject();
        }
        return sb.toString();
    }

    private static void writeJson(TraceOuterClass.Trace.Entry entry, JsonGenerator jg) throws IOException {
        List locationStackTraceElements;
        jg.writeNumberField("startOffsetNanos", entry.getStartOffsetNanos());
        jg.writeNumberField("durationNanos", entry.getDurationNanos());
        if (entry.getActive()) {
            jg.writeBooleanField("active", true);
        }
        if (entry.hasQueryEntryMessage()) {
            jg.writeObjectFieldStart("queryMessage");
            TraceOuterClass.Trace.QueryEntryMessage queryMessage = entry.getQueryEntryMessage();
            jg.writeNumberField("sharedQueryTextIndex", queryMessage.getSharedQueryTextIndex());
            jg.writeStringField("prefix", queryMessage.getPrefix());
            jg.writeStringField("suffix", queryMessage.getSuffix());
            jg.writeEndObject();
        } else {
            jg.writeStringField("message", entry.getMessage());
        }
        List detailEntries = entry.getDetailEntryList();
        if (!detailEntries.isEmpty()) {
            jg.writeFieldName("detail");
            TraceCommonService.writeDetailEntries(detailEntries, jg);
        }
        if (!(locationStackTraceElements = entry.getLocationStackTraceElementList()).isEmpty()) {
            jg.writeArrayFieldStart("locationStackTraceElements");
            for (Proto.StackTraceElement stackTraceElement : locationStackTraceElements) {
                TraceCommonService.writeStackTraceElement(stackTraceElement, jg);
            }
            jg.writeEndArray();
        }
        if (entry.hasError()) {
            jg.writeFieldName("error");
            TraceCommonService.writeError(entry.getError(), jg);
        }
    }

    private static void writeJson(AggregateOuterClass.Aggregate.Query query, JsonGenerator jg) throws IOException {
        jg.writeStringField("type", query.getType());
        jg.writeNumberField("sharedQueryTextIndex", query.getSharedQueryTextIndex());
        jg.writeNumberField("totalDurationNanos", query.getTotalDurationNanos());
        jg.writeNumberField("executionCount", query.getExecutionCount());
        if (query.hasTotalRows()) {
            jg.writeNumberField("totalRows", query.getTotalRows().getValue());
        }
        jg.writeBooleanField("active", query.getActive());
    }

    private static void writeDetailEntries(List<TraceOuterClass.Trace.DetailEntry> detailEntries, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        for (TraceOuterClass.Trace.DetailEntry detailEntry : detailEntries) {
            jg.writeFieldName(detailEntry.getName());
            List childEntries = detailEntry.getChildEntryList();
            List values = detailEntry.getValueList();
            if (!childEntries.isEmpty()) {
                TraceCommonService.writeDetailEntries(childEntries, jg);
                continue;
            }
            if (values.size() == 1) {
                TraceCommonService.writeValue((TraceOuterClass.Trace.DetailValue)values.get(0), jg);
                continue;
            }
            if (values.size() > 1) {
                jg.writeStartArray();
                for (TraceOuterClass.Trace.DetailValue value : values) {
                    TraceCommonService.writeValue(value, jg);
                }
                jg.writeEndArray();
                continue;
            }
            jg.writeNull();
        }
        jg.writeEndObject();
    }

    private static void writeValue(TraceOuterClass.Trace.DetailValue value, JsonGenerator jg) throws IOException {
        switch (value.getValCase()) {
            case STRING: {
                jg.writeString(value.getString());
                break;
            }
            case DOUBLE: {
                jg.writeNumber(value.getDouble());
                break;
            }
            case LONG: {
                jg.writeNumber(value.getLong());
                break;
            }
            case BOOLEAN: {
                jg.writeBoolean(value.getBoolean());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected detail value: " + value.getValCase());
            }
        }
    }

    private static void writeError(TraceOuterClass.Trace.Error error, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("message", error.getMessage());
        if (error.hasException()) {
            jg.writeFieldName("exception");
            TraceCommonService.writeThrowable(error.getException(), false, jg);
        }
        jg.writeEndObject();
    }

    private static void writeThrowable(Proto.Throwable throwable, boolean hasEnclosing, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("className", throwable.getClassName());
        jg.writeStringField("message", throwable.getMessage());
        jg.writeArrayFieldStart("stackTraceElements");
        for (Proto.StackTraceElement stackTraceElement : throwable.getStackTraceElementList()) {
            TraceCommonService.writeStackTraceElement(stackTraceElement, jg);
        }
        jg.writeEndArray();
        if (hasEnclosing) {
            jg.writeNumberField("framesInCommonWithEnclosing", throwable.getFramesInCommonWithEnclosing());
        }
        if (throwable.hasCause()) {
            jg.writeFieldName("cause");
            TraceCommonService.writeThrowable(throwable.getCause(), true, jg);
        }
        jg.writeEndObject();
    }

    private static void writeTimer(TraceOuterClass.Trace.Timer timer, JsonGenerator jg) throws IOException {
        List childTimers;
        jg.writeStartObject();
        jg.writeStringField("name", timer.getName());
        boolean extended = timer.getExtended();
        if (extended) {
            jg.writeBooleanField("extended", extended);
        }
        jg.writeNumberField("totalNanos", timer.getTotalNanos());
        jg.writeNumberField("count", timer.getCount());
        boolean active = timer.getActive();
        if (active) {
            jg.writeBooleanField("active", active);
        }
        if (!(childTimers = timer.getChildTimerList()).isEmpty()) {
            jg.writeArrayFieldStart("childTimers");
            for (TraceOuterClass.Trace.Timer childTimer : childTimers) {
                TraceCommonService.writeTimer(childTimer, jg);
            }
            jg.writeEndArray();
        }
        jg.writeEndObject();
    }

    private static void writeOldThreadStats(TraceOuterClass.Trace.OldThreadStats threadStats, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        jg.writeNumberField("totalCpuNanos", threadStats.getCpuNanos().getValue());
        jg.writeNumberField("totalBlockedNanos", threadStats.getBlockedNanos().getValue());
        jg.writeNumberField("totalWaitedNanos", threadStats.getWaitedNanos().getValue());
        jg.writeNumberField("totalAllocatedBytes", threadStats.getAllocatedBytes().getValue());
        jg.writeEndObject();
    }

    private static void writeThreadStats(TraceOuterClass.Trace.ThreadStats threadStats, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        jg.writeNumberField("totalCpuNanos", threadStats.getCpuNanos());
        jg.writeNumberField("totalBlockedNanos", threadStats.getBlockedNanos());
        jg.writeNumberField("totalWaitedNanos", threadStats.getWaitedNanos());
        jg.writeNumberField("totalAllocatedBytes", threadStats.getAllocatedBytes());
        jg.writeEndObject();
    }

    private static void writeStackTraceElement(Proto.StackTraceElement stackTraceElement, JsonGenerator jg) throws IOException {
        jg.writeString(new StackTraceElement(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()).toString());
    }

    private static String getFileName(TraceOuterClass.Trace.Header header) {
        return "trace-" + new SimpleDateFormat("yyyyMMdd-HHmmss-SSS").format(header.getStartTime());
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface TraceExport {
        public String fileName();

        public String headerJson();

        public @Nullable String entriesJson();

        public @Nullable String queriesJson();

        public @Nullable String sharedQueryTextsJson();

        public @Nullable String mainThreadProfileJson();

        public @Nullable String auxThreadProfileJson();
    }

    private static class RetryCountdown {
        private int remaining;

        public RetryCountdown(boolean checkLiveTraces) {
            this.remaining = checkLiveTraces ? 5 : 0;
        }
    }
}

