/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableInstrumentationConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableInstrumentationConfigResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableInstrumentationListResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableMethodSignatureDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonServiceException;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.POST;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.primitives.Ints;
import org.glowroot.agent.shaded.com.google.protobuf.AbstractMessage;
import org.glowroot.agent.shaded.com.google.protobuf.ProtocolStringList;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveJvmService;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveWeavingService;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.DownstreamServiceOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

@JsonService
class InstrumentationConfigJsonService {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationConfigJsonService.class);
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private static final Ordering<AgentConfigOuterClass.AgentConfig.InstrumentationConfig> ordering = new InstrumentationConfigOrdering();
    private final boolean central;
    private final ConfigRepository configRepository;
    private final @Nullable LiveWeavingService liveWeavingService;
    private final @Nullable LiveJvmService liveJvmService;

    InstrumentationConfigJsonService(boolean central, ConfigRepository configRepository, @Nullable LiveWeavingService liveWeavingService, @Nullable LiveJvmService liveJvmService) {
        this.central = central;
        this.configRepository = configRepository;
        this.liveWeavingService = liveWeavingService;
        this.liveJvmService = liveJvmService;
    }

    @GET(path="/backend/config/instrumentation", permission="agent:config:view:instrumentation")
    String getInstrumentationConfig(@BindAgentId String agentId, @BindRequest InstrumentationConfigRequest request) throws Exception {
        Optional<String> version = request.version();
        if (version.isPresent()) {
            return this.getInstrumentationConfigInternal(agentId, (String)version.get());
        }
        ImmutableList configs = this.configRepository.getInstrumentationConfigs(agentId);
        configs = ordering.immutableSortedCopy(configs);
        ArrayList dtos = Lists.newArrayList();
        for (AgentConfigOuterClass.AgentConfig.InstrumentationConfig config : configs) {
            dtos.add(InstrumentationConfigDto.create(config));
        }
        DownstreamServiceOuterClass.GlobalMeta globalMeta = null;
        if (this.liveWeavingService != null) {
            try {
                globalMeta = this.liveWeavingService.getGlobalMeta(agentId);
            }
            catch (LiveJvmService.AgentNotConnectedException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return mapper.writeValueAsString((Object)ImmutableInstrumentationListResponse.builder().addAllConfigs(dtos).jvmOutOfSync(globalMeta != null && globalMeta.getJvmOutOfSync()).jvmRetransformClassesSupported(globalMeta != null && globalMeta.getJvmRetransformClassesSupported()).build());
    }

    @GET(path="/backend/config/preload-classpath-cache", permission="agent:config:view:instrumentation")
    void preloadClasspathCache(final @BindAgentId String agentId) throws Exception {
        if (this.liveWeavingService == null) {
            return;
        }
        if (this.central) {
            try {
                this.liveWeavingService.preloadClasspathCache(agentId);
            }
            catch (LiveJvmService.AgentNotConnectedException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        } else {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Preconditions.checkNotNull((Object)InstrumentationConfigJsonService.this.liveWeavingService);
                        InstrumentationConfigJsonService.this.liveWeavingService.preloadClasspathCache(agentId);
                    }
                    catch (LiveJvmService.AgentNotConnectedException e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
            thread.setDaemon(true);
            thread.setName("Glowroot-Temporary-Thread");
            thread.start();
        }
    }

    @GET(path="/backend/config/new-instrumentation-check-agent-connected", permission="agent:config:edit:instrumentation")
    String checkAgentConnected(@BindAgentId String agentId) throws Exception {
        Preconditions.checkNotNull((Object)this.liveJvmService);
        return Boolean.toString(this.liveJvmService.isAvailable(agentId));
    }

    @GET(path="/backend/config/matching-class-names", permission="agent:config:edit:instrumentation")
    String getMatchingClassNames(@BindAgentId String agentId, @BindRequest ClassNamesRequest request) throws Exception {
        Preconditions.checkNotNull((Object)this.liveWeavingService);
        return mapper.writeValueAsString((Object)this.liveWeavingService.getMatchingClassNames(agentId, request.partialClassName(), request.limit()));
    }

    @GET(path="/backend/config/matching-method-names", permission="agent:config:edit:instrumentation")
    String getMatchingMethodNames(@BindAgentId String agentId, @BindRequest MethodNamesRequest request) throws Exception {
        Preconditions.checkNotNull((Object)this.liveWeavingService);
        List matchingMethodNames = this.liveWeavingService.getMatchingMethodNames(agentId, request.className(), request.partialMethodName(), request.limit());
        return mapper.writeValueAsString((Object)matchingMethodNames);
    }

    @GET(path="/backend/config/method-signatures", permission="agent:config:edit:instrumentation")
    String getMethodSignatures(@BindAgentId String agentId, @BindRequest MethodSignaturesRequest request) throws Exception {
        Preconditions.checkNotNull((Object)this.liveWeavingService);
        List signatures = this.liveWeavingService.getMethodSignatures(agentId, request.className(), request.methodName());
        ArrayList methodSignatures = Lists.newArrayList();
        for (DownstreamServiceOuterClass.MethodSignature signature : signatures) {
            methodSignatures.add(MethodSignatureDto.create(signature));
        }
        return mapper.writeValueAsString((Object)methodSignatures);
    }

    @POST(path="/backend/config/instrumentation/add", permission="agent:config:edit:instrumentation")
    String addInstrumentationConfig(@BindAgentId String agentId, @BindRequest InstrumentationConfigDto configDto) throws Exception {
        AgentConfigOuterClass.AgentConfig.InstrumentationConfig config = configDto.convert();
        this.configRepository.insertInstrumentationConfig(agentId, config, CassandraProfile.web).toCompletableFuture().join();
        return this.getInstrumentationConfigInternal(agentId, Versions.getVersion((AbstractMessage)config));
    }

    @POST(path="/backend/config/instrumentation/update", permission="agent:config:edit:instrumentation")
    String updateInstrumentationConfig(@BindAgentId String agentId, @BindRequest InstrumentationConfigDto configDto) throws Exception {
        AgentConfigOuterClass.AgentConfig.InstrumentationConfig config = configDto.convert();
        String version = (String)configDto.version().get();
        this.configRepository.updateInstrumentationConfig(agentId, config, version, CassandraProfile.web).toCompletableFuture().join();
        return this.getInstrumentationConfigInternal(agentId, Versions.getVersion((AbstractMessage)config));
    }

    @POST(path="/backend/config/instrumentation/remove", permission="agent:config:edit:instrumentation")
    void removeInstrumentationConfig(@BindAgentId String agentId, @BindRequest InstrumentationDeleteRequest request) throws Exception {
        this.configRepository.deleteInstrumentationConfigs(agentId, request.versions(), CassandraProfile.web).toCompletableFuture().join();
    }

    @POST(path="/backend/config/instrumentation/import", permission="agent:config:edit:instrumentation")
    void importInstrumentationConfig(@BindAgentId String agentId, @BindRequest InstrumentationImportRequest request) throws Exception {
        ArrayList configs = Lists.newArrayList();
        for (InstrumentationConfigDto configDto : request.configs()) {
            configs.add(configDto.convert());
        }
        this.configRepository.insertInstrumentationConfigs(agentId, configs, CassandraProfile.web).toCompletableFuture().join();
    }

    @POST(path="/backend/config/reweave", permission="agent:config:edit:instrumentation")
    String reweave(@BindAgentId String agentId) throws Exception {
        Preconditions.checkNotNull((Object)this.liveWeavingService);
        int count = this.liveWeavingService.reweave(agentId);
        return "{\"classes\":" + count + "}";
    }

    private String getInstrumentationConfigInternal(String agentId, String version) throws Exception {
        AgentConfigOuterClass.AgentConfig.InstrumentationConfig config = this.configRepository.getInstrumentationConfig(agentId, version);
        if (config == null) {
            throw new JsonServiceException(HttpResponseStatus.NOT_FOUND);
        }
        List methodSignatures = null;
        if (this.liveWeavingService != null) {
            try {
                methodSignatures = this.liveWeavingService.getMethodSignatures(agentId, config.getClassName(), config.getMethodName());
            }
            catch (LiveJvmService.AgentNotConnectedException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        ImmutableInstrumentationConfigResponse.Builder builder = ImmutableInstrumentationConfigResponse.builder().agentNotConnected(methodSignatures == null).config(InstrumentationConfigDto.create(config));
        if (methodSignatures == null) {
            ArrayList modifiers = Lists.newArrayList();
            if (!InstrumentationConfigJsonService.isSignatureAll(config)) {
                for (AgentConfigOuterClass.AgentConfig.InstrumentationConfig.MethodModifier modifier : config.getMethodModifierList()) {
                    modifiers.add(modifier.name());
                }
                builder.addMethodSignatures((MethodSignatureDto)ImmutableMethodSignatureDto.builder().name(config.getMethodName()).parameterTypes((Iterable<String>)config.getMethodParameterTypeList()).returnType(config.getMethodReturnType()).modifiers(modifiers).build());
            }
        } else {
            for (DownstreamServiceOuterClass.MethodSignature methodSignature : methodSignatures) {
                builder.addMethodSignatures(MethodSignatureDto.create(methodSignature));
            }
        }
        return mapper.writeValueAsString((Object)builder.build());
    }

    private static boolean isSignatureAll(AgentConfigOuterClass.AgentConfig.InstrumentationConfig config) {
        return config.getMethodModifierCount() == 0 && config.getMethodReturnType().isEmpty() && config.getMethodParameterTypeCount() == 1 && config.getMethodParameterType(0).equals("..");
    }

    @VisibleForTesting
    static class InstrumentationConfigOrdering
    extends Ordering<AgentConfigOuterClass.AgentConfig.InstrumentationConfig> {
        InstrumentationConfigOrdering() {
        }

        public int compare(AgentConfigOuterClass.AgentConfig.InstrumentationConfig left, AgentConfigOuterClass.AgentConfig.InstrumentationConfig right) {
            int compare = left.getClassName().compareToIgnoreCase(right.getClassName());
            if (compare != 0) {
                return compare;
            }
            compare = left.getMethodName().compareToIgnoreCase(right.getMethodName());
            if (compare != 0) {
                return compare;
            }
            ProtocolStringList leftParameterTypes = left.getMethodParameterTypeList();
            ProtocolStringList rightParameterTypes = right.getMethodParameterTypeList();
            compare = Ints.compare((int)leftParameterTypes.size(), (int)rightParameterTypes.size());
            if (compare != 0) {
                return compare;
            }
            for (int i = 0; i < leftParameterTypes.size(); ++i) {
                compare = ((String)leftParameterTypes.get(i)).compareToIgnoreCase((String)rightParameterTypes.get(i));
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @Value.Immutable
    static abstract class MethodSignatureDto {
        MethodSignatureDto() {
        }

        abstract String name();

        abstract ImmutableList<String> parameterTypes();

        abstract String returnType();

        abstract ImmutableList<String> modifiers();

        private static MethodSignatureDto create(DownstreamServiceOuterClass.MethodSignature methodSignature) {
            return ImmutableMethodSignatureDto.builder().name(methodSignature.getName()).addAllParameterTypes((Iterable<String>)methodSignature.getParameterTypeList()).returnType(methodSignature.getReturnType()).modifiers((Iterable<String>)methodSignature.getModifierList()).build();
        }
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @Value.Immutable
    static abstract class InstrumentationConfigDto {
        InstrumentationConfigDto() {
        }

        abstract String className();

        abstract String classAnnotation();

        abstract String subTypeRestriction();

        abstract String superTypeRestriction();

        @Deprecated
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        abstract @Nullable String methodDeclaringClassName();

        abstract String methodName();

        abstract String methodAnnotation();

        abstract ImmutableList<String> methodParameterTypes();

        abstract String methodReturnType();

        abstract ImmutableList<AgentConfigOuterClass.AgentConfig.InstrumentationConfig.MethodModifier> methodModifiers();

        abstract String nestingGroup();

        abstract int order();

        abstract AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind captureKind();

        abstract String transactionType();

        abstract String transactionNameTemplate();

        abstract String transactionUserTemplate();

        abstract Map<String, String> transactionAttributeTemplates();

        abstract @Nullable Integer transactionSlowThresholdMillis();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior alreadyInTransactionBehavior();

        abstract boolean transactionOuter();

        abstract String traceEntryMessageTemplate();

        abstract @Nullable Integer traceEntryStackThresholdMillis();

        abstract boolean traceEntryCaptureSelfNested();

        abstract String timerName();

        abstract String enabledProperty();

        abstract String traceEntryEnabledProperty();

        abstract Optional<String> version();

        private AgentConfigOuterClass.AgentConfig.InstrumentationConfig convert() {
            AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior alreadyInTransactionBehavior;
            AgentConfigOuterClass.AgentConfig.InstrumentationConfig.Builder builder = AgentConfigOuterClass.AgentConfig.InstrumentationConfig.newBuilder().setClassName(this.className()).setClassAnnotation(this.classAnnotation()).setSubTypeRestriction(this.subTypeRestriction()).setSuperTypeRestriction(this.superTypeRestriction()).setMethodDeclaringClassName(Strings.nullToEmpty((String)this.methodDeclaringClassName())).setMethodName(this.methodName()).setMethodAnnotation(this.methodAnnotation()).addAllMethodParameterType(this.methodParameterTypes()).setMethodReturnType(this.methodReturnType()).addAllMethodModifier(this.methodModifiers()).setNestingGroup(this.nestingGroup()).setOrder(this.order()).setCaptureKind(this.captureKind()).setTransactionType(this.transactionType()).setTransactionNameTemplate(this.transactionNameTemplate()).setTransactionUserTemplate(this.transactionUserTemplate()).putAllTransactionAttributeTemplates(this.transactionAttributeTemplates());
            Integer transactionSlowThresholdMillis = this.transactionSlowThresholdMillis();
            if (transactionSlowThresholdMillis != null) {
                builder.setTransactionSlowThresholdMillis(Proto.OptionalInt32.newBuilder().setValue(transactionSlowThresholdMillis.intValue()));
            }
            if ((alreadyInTransactionBehavior = this.alreadyInTransactionBehavior()) != null) {
                builder.setAlreadyInTransactionBehavior(alreadyInTransactionBehavior);
            }
            builder.setTransactionOuter(this.transactionOuter()).setTraceEntryMessageTemplate(this.traceEntryMessageTemplate());
            Integer traceEntryStackThresholdMillis = this.traceEntryStackThresholdMillis();
            if (traceEntryStackThresholdMillis != null) {
                builder.setTraceEntryStackThresholdMillis(Proto.OptionalInt32.newBuilder().setValue(traceEntryStackThresholdMillis.intValue()));
            }
            return builder.setTraceEntryCaptureSelfNested(this.traceEntryCaptureSelfNested()).setTimerName(this.timerName()).setEnabledProperty(this.enabledProperty()).setTraceEntryEnabledProperty(this.traceEntryEnabledProperty()).build();
        }

        private static InstrumentationConfigDto create(AgentConfigOuterClass.AgentConfig.InstrumentationConfig config) {
            ImmutableInstrumentationConfigDto.Builder builder = ImmutableInstrumentationConfigDto.builder().className(config.getClassName()).classAnnotation(config.getClassAnnotation()).subTypeRestriction(config.getSubTypeRestriction()).superTypeRestriction(config.getSuperTypeRestriction()).methodDeclaringClassName(Strings.emptyToNull((String)config.getMethodDeclaringClassName())).methodName(config.getMethodName()).methodAnnotation(config.getMethodAnnotation()).addAllMethodParameterTypes((Iterable<String>)config.getMethodParameterTypeList()).methodReturnType(config.getMethodReturnType()).addAllMethodModifiers(config.getMethodModifierList()).nestingGroup(config.getNestingGroup()).order(config.getOrder()).captureKind(config.getCaptureKind()).transactionType(config.getTransactionType()).transactionNameTemplate(config.getTransactionNameTemplate()).transactionUserTemplate(config.getTransactionUserTemplate()).putAllTransactionAttributeTemplates(config.getTransactionAttributeTemplatesMap());
            if (config.hasTransactionSlowThresholdMillis()) {
                builder.transactionSlowThresholdMillis(config.getTransactionSlowThresholdMillis().getValue());
            }
            if (config.getCaptureKind() == AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TRANSACTION) {
                builder.alreadyInTransactionBehavior(config.getAlreadyInTransactionBehavior());
            }
            builder.transactionOuter(config.getTransactionOuter()).traceEntryMessageTemplate(config.getTraceEntryMessageTemplate());
            if (config.hasTraceEntryStackThresholdMillis()) {
                builder.traceEntryStackThresholdMillis(config.getTraceEntryStackThresholdMillis().getValue());
            }
            return builder.traceEntryCaptureSelfNested(config.getTraceEntryCaptureSelfNested()).timerName(config.getTimerName()).enabledProperty(config.getEnabledProperty()).traceEntryEnabledProperty(config.getTraceEntryEnabledProperty()).version(Versions.getVersion((AbstractMessage)config)).build();
        }
    }

    @Value.Immutable
    static interface InstrumentationDeleteRequest {
        public List<String> versions();
    }

    @Value.Immutable
    static interface InstrumentationImportRequest {
        public ImmutableList<ImmutableInstrumentationConfigDto> configs();
    }

    @Value.Immutable
    static interface InstrumentationErrorResponse {
        public ImmutableList<String> errors();
    }

    @Value.Immutable
    static interface InstrumentationConfigResponse {
        public boolean agentNotConnected();

        public InstrumentationConfigDto config();

        public ImmutableList<MethodSignatureDto> methodSignatures();
    }

    @Value.Immutable
    static interface InstrumentationListResponse {
        public ImmutableList<InstrumentationConfigDto> configs();

        public boolean jvmOutOfSync();

        public boolean jvmRetransformClassesSupported();
    }

    @Value.Immutable
    static interface MethodSignaturesRequest {
        public String className();

        public String methodName();
    }

    @Value.Immutable
    static interface MethodNamesRequest {
        public String className();

        public String partialMethodName();

        public int limit();
    }

    @Value.Immutable
    static interface ClassNamesRequest {
        public String partialClassName();

        public int limit();
    }

    @Value.Immutable
    static interface InstrumentationConfigRequest {
        public Optional<String> version();
    }
}

