/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.UserConfigJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UserConfigJsonService.UserConfigResponse", generator="Immutables")
@Immutable
final class ImmutableUserConfigResponse
implements UserConfigJsonService.UserConfigResponse {
    private final UserConfigJsonService.UserConfigDto config;
    private final ImmutableList<String> allRoles;
    private final boolean ldapAvailable;

    private ImmutableUserConfigResponse(UserConfigJsonService.UserConfigDto config, ImmutableList<String> allRoles, boolean ldapAvailable) {
        this.config = config;
        this.allRoles = allRoles;
        this.ldapAvailable = ldapAvailable;
    }

    @Override
    @JsonProperty(value="config")
    public UserConfigJsonService.UserConfigDto config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="allRoles")
    public ImmutableList<String> allRoles() {
        return this.allRoles;
    }

    @Override
    @JsonProperty(value="ldapAvailable")
    public boolean ldapAvailable() {
        return this.ldapAvailable;
    }

    public final ImmutableUserConfigResponse withConfig(UserConfigJsonService.UserConfigDto value) {
        if (this.config == value) {
            return this;
        }
        UserConfigJsonService.UserConfigDto newValue = Objects.requireNonNull(value, "config");
        return new ImmutableUserConfigResponse(newValue, this.allRoles, this.ldapAvailable);
    }

    public final ImmutableUserConfigResponse withAllRoles(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableUserConfigResponse(this.config, (ImmutableList<String>)newValue, this.ldapAvailable);
    }

    public final ImmutableUserConfigResponse withAllRoles(Iterable<String> elements) {
        if (this.allRoles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableUserConfigResponse(this.config, (ImmutableList<String>)newValue, this.ldapAvailable);
    }

    public final ImmutableUserConfigResponse withLdapAvailable(boolean value) {
        if (this.ldapAvailable == value) {
            return this;
        }
        return new ImmutableUserConfigResponse(this.config, this.allRoles, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserConfigResponse && this.equalTo(0, (ImmutableUserConfigResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableUserConfigResponse another) {
        return this.config.equals(another.config) && this.allRoles.equals(another.allRoles) && this.ldapAvailable == another.ldapAvailable;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + this.allRoles.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.ldapAvailable);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UserConfigResponse").omitNullValues().add("config", (Object)this.config).add("allRoles", this.allRoles).add("ldapAvailable", this.ldapAvailable).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableUserConfigResponse fromJson(Json json) {
        Builder builder = ImmutableUserConfigResponse.builder();
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.allRoles != null) {
            builder.addAllAllRoles((Iterable<String>)json.allRoles);
        }
        if (json.ldapAvailableIsSet) {
            builder.ldapAvailable(json.ldapAvailable);
        }
        return builder.build();
    }

    public static ImmutableUserConfigResponse copyOf(UserConfigJsonService.UserConfigResponse instance) {
        if (instance instanceof ImmutableUserConfigResponse) {
            return (ImmutableUserConfigResponse)instance;
        }
        return ImmutableUserConfigResponse.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UserConfigJsonService.UserConfigResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONFIG = 1L;
        private static final long INIT_BIT_LDAP_AVAILABLE = 2L;
        private long initBits = 3L;
        @Nullable
        private UserConfigJsonService.UserConfigDto config;
        private ImmutableList.Builder<String> allRoles = ImmutableList.builder();
        private boolean ldapAvailable;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(UserConfigJsonService.UserConfigResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.config(instance.config());
            this.addAllAllRoles((Iterable<String>)instance.allRoles());
            this.ldapAvailable(instance.ldapAvailable());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder config(UserConfigJsonService.UserConfigDto config) {
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllRoles(String element) {
            this.allRoles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllRoles(String ... elements) {
            this.allRoles.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allRoles(Iterable<String> elements) {
            this.allRoles = ImmutableList.builder();
            return this.addAllAllRoles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAllRoles(Iterable<String> elements) {
            this.allRoles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ldapAvailable(boolean ldapAvailable) {
            this.ldapAvailable = ldapAvailable;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUserConfigResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUserConfigResponse(this.config, this.allRoles.build(), this.ldapAvailable);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ldapAvailable");
            }
            return "Cannot build UserConfigResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UserConfigJsonService.UserConfigResponse", generator="Immutables")
    static final class Json
    implements UserConfigJsonService.UserConfigResponse {
        @Nullable
        UserConfigJsonService.UserConfigDto config;
        @Nullable
        ImmutableList<String> allRoles = ImmutableList.of();
        boolean ldapAvailable;
        boolean ldapAvailableIsSet;

        Json() {
        }

        @JsonProperty(value="config")
        public void setConfig(UserConfigJsonService.UserConfigDto config) {
            this.config = config;
        }

        @JsonProperty(value="allRoles")
        public void setAllRoles(ImmutableList<String> allRoles) {
            this.allRoles = allRoles;
        }

        @JsonProperty(value="ldapAvailable")
        public void setLdapAvailable(boolean ldapAvailable) {
            this.ldapAvailable = ldapAvailable;
            this.ldapAvailableIsSet = true;
        }

        @Override
        public UserConfigJsonService.UserConfigDto config() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<String> allRoles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean ldapAvailable() {
            throw new UnsupportedOperationException();
        }
    }
}

