/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TransactionJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameSummaryCollector;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionJsonService.TransactionSummaryRequest", generator="Immutables")
@Immutable
final class ImmutableTransactionSummaryRequest
implements TransactionJsonService.TransactionSummaryRequest {
    private final String transactionType;
    private final long from;
    private final long to;
    private final TransactionNameSummaryCollector.SummarySortOrder sortOrder;
    private final int limit;

    private ImmutableTransactionSummaryRequest(String transactionType, long from, long to, TransactionNameSummaryCollector.SummarySortOrder sortOrder, int limit) {
        this.transactionType = transactionType;
        this.from = from;
        this.to = to;
        this.sortOrder = sortOrder;
        this.limit = limit;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="sortOrder")
    public TransactionNameSummaryCollector.SummarySortOrder sortOrder() {
        return this.sortOrder;
    }

    @Override
    @JsonProperty(value="limit")
    public int limit() {
        return this.limit;
    }

    public final ImmutableTransactionSummaryRequest withTransactionType(String value) {
        String newValue = Objects.requireNonNull(value, "transactionType");
        if (this.transactionType.equals(newValue)) {
            return this;
        }
        return new ImmutableTransactionSummaryRequest(newValue, this.from, this.to, this.sortOrder, this.limit);
    }

    public final ImmutableTransactionSummaryRequest withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        return new ImmutableTransactionSummaryRequest(this.transactionType, value, this.to, this.sortOrder, this.limit);
    }

    public final ImmutableTransactionSummaryRequest withTo(long value) {
        if (this.to == value) {
            return this;
        }
        return new ImmutableTransactionSummaryRequest(this.transactionType, this.from, value, this.sortOrder, this.limit);
    }

    public final ImmutableTransactionSummaryRequest withSortOrder(TransactionNameSummaryCollector.SummarySortOrder value) {
        TransactionNameSummaryCollector.SummarySortOrder newValue = Objects.requireNonNull(value, "sortOrder");
        if (this.sortOrder == newValue) {
            return this;
        }
        return new ImmutableTransactionSummaryRequest(this.transactionType, this.from, this.to, newValue, this.limit);
    }

    public final ImmutableTransactionSummaryRequest withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableTransactionSummaryRequest(this.transactionType, this.from, this.to, this.sortOrder, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionSummaryRequest && this.equalTo(0, (ImmutableTransactionSummaryRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableTransactionSummaryRequest another) {
        return this.transactionType.equals(another.transactionType) && this.from == another.from && this.to == another.to && this.sortOrder.equals((Object)another.sortOrder) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionType.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.from);
        h += (h << 5) + Longs.hashCode((long)this.to);
        h += (h << 5) + this.sortOrder.hashCode();
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransactionSummaryRequest").omitNullValues().add("transactionType", (Object)this.transactionType).add("from", this.from).add("to", this.to).add("sortOrder", (Object)this.sortOrder).add("limit", this.limit).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTransactionSummaryRequest fromJson(Json json) {
        Builder builder = ImmutableTransactionSummaryRequest.builder();
        if (json.transactionType != null) {
            builder.transactionType(json.transactionType);
        }
        if (json.fromIsSet) {
            builder.from(json.from);
        }
        if (json.toIsSet) {
            builder.to(json.to);
        }
        if (json.sortOrder != null) {
            builder.sortOrder(json.sortOrder);
        }
        if (json.limitIsSet) {
            builder.limit(json.limit);
        }
        return builder.build();
    }

    public static ImmutableTransactionSummaryRequest copyOf(TransactionJsonService.TransactionSummaryRequest instance) {
        if (instance instanceof ImmutableTransactionSummaryRequest) {
            return (ImmutableTransactionSummaryRequest)instance;
        }
        return ImmutableTransactionSummaryRequest.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionJsonService.TransactionSummaryRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_TYPE = 1L;
        private static final long INIT_BIT_FROM = 2L;
        private static final long INIT_BIT_TO = 4L;
        private static final long INIT_BIT_SORT_ORDER = 8L;
        private static final long INIT_BIT_LIMIT = 16L;
        private long initBits = 31L;
        @Nullable
        private String transactionType;
        private long from;
        private long to;
        @Nullable
        private TransactionNameSummaryCollector.SummarySortOrder sortOrder;
        private int limit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TransactionJsonService.TransactionSummaryRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.transactionType(instance.transactionType());
            this.from(instance.from());
            this.to(instance.to());
            this.sortOrder(instance.sortOrder());
            this.limit(instance.limit());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionType(String transactionType) {
            this.transactionType = Objects.requireNonNull(transactionType, "transactionType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(long from) {
            this.from = from;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder to(long to) {
            this.to = to;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sortOrder(TransactionNameSummaryCollector.SummarySortOrder sortOrder) {
            this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableTransactionSummaryRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransactionSummaryRequest(this.transactionType, this.from, this.to, this.sortOrder, this.limit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("from");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("to");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("sortOrder");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build TransactionSummaryRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionJsonService.TransactionSummaryRequest", generator="Immutables")
    static final class Json
    implements TransactionJsonService.TransactionSummaryRequest {
        @Nullable
        String transactionType;
        long from;
        boolean fromIsSet;
        long to;
        boolean toIsSet;
        @Nullable
        TransactionNameSummaryCollector.SummarySortOrder sortOrder;
        int limit;
        boolean limitIsSet;

        Json() {
        }

        @JsonProperty(value="transactionType")
        public void setTransactionType(String transactionType) {
            this.transactionType = transactionType;
        }

        @JsonProperty(value="from")
        public void setFrom(long from) {
            this.from = from;
            this.fromIsSet = true;
        }

        @JsonProperty(value="to")
        public void setTo(long to) {
            this.to = to;
            this.toIsSet = true;
        }

        @JsonProperty(value="sortOrder")
        public void setSortOrder(TransactionNameSummaryCollector.SummarySortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        @JsonProperty(value="limit")
        public void setLimit(int limit) {
            this.limit = limit;
            this.limitIsSet = true;
        }

        @Override
        public String transactionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long from() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long to() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TransactionNameSummaryCollector.SummarySortOrder sortOrder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int limit() {
            throw new UnsupportedOperationException();
        }
    }
}

