/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TransactionJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionJsonService.ServiceCall", generator="Immutables")
@Immutable
final class ImmutableServiceCall
implements TransactionJsonService.ServiceCall {
    private final String type;
    private final String text;
    private final double totalDurationNanos;
    private final long executionCount;

    private ImmutableServiceCall(String type, String text, double totalDurationNanos, long executionCount) {
        this.type = type;
        this.text = text;
        this.totalDurationNanos = totalDurationNanos;
        this.executionCount = executionCount;
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="text")
    public String text() {
        return this.text;
    }

    @Override
    @JsonProperty(value="totalDurationNanos")
    public double totalDurationNanos() {
        return this.totalDurationNanos;
    }

    @Override
    @JsonProperty(value="executionCount")
    public long executionCount() {
        return this.executionCount;
    }

    public final ImmutableServiceCall withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceCall(newValue, this.text, this.totalDurationNanos, this.executionCount);
    }

    public final ImmutableServiceCall withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceCall(this.type, newValue, this.totalDurationNanos, this.executionCount);
    }

    public final ImmutableServiceCall withTotalDurationNanos(double value) {
        if (Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableServiceCall(this.type, this.text, value, this.executionCount);
    }

    public final ImmutableServiceCall withExecutionCount(long value) {
        if (this.executionCount == value) {
            return this;
        }
        return new ImmutableServiceCall(this.type, this.text, this.totalDurationNanos, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceCall && this.equalTo(0, (ImmutableServiceCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableServiceCall another) {
        return this.type.equals(another.type) && this.text.equals(another.text) && Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(another.totalDurationNanos) && this.executionCount == another.executionCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + Doubles.hashCode((double)this.totalDurationNanos);
        h += (h << 5) + Longs.hashCode((long)this.executionCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServiceCall").omitNullValues().add("type", (Object)this.type).add("text", (Object)this.text).add("totalDurationNanos", this.totalDurationNanos).add("executionCount", this.executionCount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServiceCall fromJson(Json json) {
        Builder builder = ImmutableServiceCall.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.text != null) {
            builder.text(json.text);
        }
        if (json.totalDurationNanosIsSet) {
            builder.totalDurationNanos(json.totalDurationNanos);
        }
        if (json.executionCountIsSet) {
            builder.executionCount(json.executionCount);
        }
        return builder.build();
    }

    public static ImmutableServiceCall copyOf(TransactionJsonService.ServiceCall instance) {
        if (instance instanceof ImmutableServiceCall) {
            return (ImmutableServiceCall)instance;
        }
        return ImmutableServiceCall.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionJsonService.ServiceCall", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private static final long INIT_BIT_TOTAL_DURATION_NANOS = 4L;
        private static final long INIT_BIT_EXECUTION_COUNT = 8L;
        private long initBits = 15L;
        @Nullable
        private String type;
        @Nullable
        private String text;
        private double totalDurationNanos;
        private long executionCount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TransactionJsonService.ServiceCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.text(instance.text());
            this.totalDurationNanos(instance.totalDurationNanos());
            this.executionCount(instance.executionCount());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder executionCount(long executionCount) {
            this.executionCount = executionCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableServiceCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceCall(this.type, this.text, this.totalDurationNanos, this.executionCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("totalDurationNanos");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("executionCount");
            }
            return "Cannot build ServiceCall, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionJsonService.ServiceCall", generator="Immutables")
    static final class Json
    implements TransactionJsonService.ServiceCall {
        @Nullable
        String type;
        @Nullable
        String text;
        double totalDurationNanos;
        boolean totalDurationNanosIsSet;
        long executionCount;
        boolean executionCountIsSet;

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="text")
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty(value="totalDurationNanos")
        public void setTotalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.totalDurationNanosIsSet = true;
        }

        @JsonProperty(value="executionCount")
        public void setExecutionCount(long executionCount) {
            this.executionCount = executionCount;
            this.executionCountIsSet = true;
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String text() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double totalDurationNanos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long executionCount() {
            throw new UnsupportedOperationException();
        }
    }
}

