/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TransactionJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionJsonService.Query", generator="Immutables")
@Immutable
final class ImmutableQuery
implements TransactionJsonService.Query {
    private final String queryType;
    private final String truncatedQueryText;
    private final @org.checkerframework.checker.nullness.qual.Nullable String fullQueryTextSha1;
    private final double totalDurationNanos;
    private final long executionCount;
    private final @org.checkerframework.checker.nullness.qual.Nullable Long totalRows;

    private ImmutableQuery(String queryType, String truncatedQueryText, @org.checkerframework.checker.nullness.qual.Nullable String fullQueryTextSha1, double totalDurationNanos, long executionCount, @org.checkerframework.checker.nullness.qual.Nullable Long totalRows) {
        this.queryType = queryType;
        this.truncatedQueryText = truncatedQueryText;
        this.fullQueryTextSha1 = fullQueryTextSha1;
        this.totalDurationNanos = totalDurationNanos;
        this.executionCount = executionCount;
        this.totalRows = totalRows;
    }

    @Override
    @JsonProperty(value="queryType")
    public String queryType() {
        return this.queryType;
    }

    @Override
    @JsonProperty(value="truncatedQueryText")
    public String truncatedQueryText() {
        return this.truncatedQueryText;
    }

    @Override
    @JsonProperty(value="fullQueryTextSha1")
    public @org.checkerframework.checker.nullness.qual.Nullable String fullQueryTextSha1() {
        return this.fullQueryTextSha1;
    }

    @Override
    @JsonProperty(value="totalDurationNanos")
    public double totalDurationNanos() {
        return this.totalDurationNanos;
    }

    @Override
    @JsonProperty(value="executionCount")
    public long executionCount() {
        return this.executionCount;
    }

    @Override
    @JsonProperty(value="totalRows")
    public @org.checkerframework.checker.nullness.qual.Nullable Long totalRows() {
        return this.totalRows;
    }

    public final ImmutableQuery withQueryType(String value) {
        String newValue = Objects.requireNonNull(value, "queryType");
        if (this.queryType.equals(newValue)) {
            return this;
        }
        return new ImmutableQuery(newValue, this.truncatedQueryText, this.fullQueryTextSha1, this.totalDurationNanos, this.executionCount, this.totalRows);
    }

    public final ImmutableQuery withTruncatedQueryText(String value) {
        String newValue = Objects.requireNonNull(value, "truncatedQueryText");
        if (this.truncatedQueryText.equals(newValue)) {
            return this;
        }
        return new ImmutableQuery(this.queryType, newValue, this.fullQueryTextSha1, this.totalDurationNanos, this.executionCount, this.totalRows);
    }

    public final ImmutableQuery withFullQueryTextSha1(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.fullQueryTextSha1, value)) {
            return this;
        }
        return new ImmutableQuery(this.queryType, this.truncatedQueryText, value, this.totalDurationNanos, this.executionCount, this.totalRows);
    }

    public final ImmutableQuery withTotalDurationNanos(double value) {
        if (Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableQuery(this.queryType, this.truncatedQueryText, this.fullQueryTextSha1, value, this.executionCount, this.totalRows);
    }

    public final ImmutableQuery withExecutionCount(long value) {
        if (this.executionCount == value) {
            return this;
        }
        return new ImmutableQuery(this.queryType, this.truncatedQueryText, this.fullQueryTextSha1, this.totalDurationNanos, value, this.totalRows);
    }

    public final ImmutableQuery withTotalRows(@org.checkerframework.checker.nullness.qual.Nullable Long value) {
        if (Objects.equals(this.totalRows, value)) {
            return this;
        }
        return new ImmutableQuery(this.queryType, this.truncatedQueryText, this.fullQueryTextSha1, this.totalDurationNanos, this.executionCount, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQuery && this.equalTo(0, (ImmutableQuery)another);
    }

    private boolean equalTo(int synthetic, ImmutableQuery another) {
        return this.queryType.equals(another.queryType) && this.truncatedQueryText.equals(another.truncatedQueryText) && Objects.equals(this.fullQueryTextSha1, another.fullQueryTextSha1) && Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(another.totalDurationNanos) && this.executionCount == another.executionCount && Objects.equals(this.totalRows, another.totalRows);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.queryType.hashCode();
        h += (h << 5) + this.truncatedQueryText.hashCode();
        h += (h << 5) + Objects.hashCode(this.fullQueryTextSha1);
        h += (h << 5) + Doubles.hashCode((double)this.totalDurationNanos);
        h += (h << 5) + Longs.hashCode((long)this.executionCount);
        h += (h << 5) + Objects.hashCode(this.totalRows);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Query").omitNullValues().add("queryType", (Object)this.queryType).add("truncatedQueryText", (Object)this.truncatedQueryText).add("fullQueryTextSha1", (Object)this.fullQueryTextSha1).add("totalDurationNanos", this.totalDurationNanos).add("executionCount", this.executionCount).add("totalRows", (Object)this.totalRows).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableQuery fromJson(Json json) {
        Builder builder = ImmutableQuery.builder();
        if (json.queryType != null) {
            builder.queryType(json.queryType);
        }
        if (json.truncatedQueryText != null) {
            builder.truncatedQueryText(json.truncatedQueryText);
        }
        if (json.fullQueryTextSha1 != null) {
            builder.fullQueryTextSha1(json.fullQueryTextSha1);
        }
        if (json.totalDurationNanosIsSet) {
            builder.totalDurationNanos(json.totalDurationNanos);
        }
        if (json.executionCountIsSet) {
            builder.executionCount(json.executionCount);
        }
        if (json.totalRows != null) {
            builder.totalRows(json.totalRows);
        }
        return builder.build();
    }

    public static ImmutableQuery copyOf(TransactionJsonService.Query instance) {
        if (instance instanceof ImmutableQuery) {
            return (ImmutableQuery)instance;
        }
        return ImmutableQuery.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionJsonService.Query", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_QUERY_TYPE = 1L;
        private static final long INIT_BIT_TRUNCATED_QUERY_TEXT = 2L;
        private static final long INIT_BIT_TOTAL_DURATION_NANOS = 4L;
        private static final long INIT_BIT_EXECUTION_COUNT = 8L;
        private long initBits = 15L;
        @Nullable
        private String queryType;
        @Nullable
        private String truncatedQueryText;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String fullQueryTextSha1;
        private double totalDurationNanos;
        private long executionCount;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable Long totalRows;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TransactionJsonService.Query instance) {
            Objects.requireNonNull(instance, "instance");
            this.queryType(instance.queryType());
            this.truncatedQueryText(instance.truncatedQueryText());
            @org.checkerframework.checker.nullness.qual.Nullable String fullQueryTextSha1Value = instance.fullQueryTextSha1();
            if (fullQueryTextSha1Value != null) {
                this.fullQueryTextSha1(fullQueryTextSha1Value);
            }
            this.totalDurationNanos(instance.totalDurationNanos());
            this.executionCount(instance.executionCount());
            @org.checkerframework.checker.nullness.qual.Nullable Long totalRowsValue = instance.totalRows();
            if (totalRowsValue != null) {
                this.totalRows(totalRowsValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queryType(String queryType) {
            this.queryType = Objects.requireNonNull(queryType, "queryType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder truncatedQueryText(String truncatedQueryText) {
            this.truncatedQueryText = Objects.requireNonNull(truncatedQueryText, "truncatedQueryText");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fullQueryTextSha1(@org.checkerframework.checker.nullness.qual.Nullable String fullQueryTextSha1) {
            this.fullQueryTextSha1 = fullQueryTextSha1;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder executionCount(long executionCount) {
            this.executionCount = executionCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalRows(@org.checkerframework.checker.nullness.qual.Nullable Long totalRows) {
            this.totalRows = totalRows;
            return this;
        }

        public ImmutableQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQuery(this.queryType, this.truncatedQueryText, this.fullQueryTextSha1, this.totalDurationNanos, this.executionCount, this.totalRows);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("truncatedQueryText");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("totalDurationNanos");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("executionCount");
            }
            return "Cannot build Query, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionJsonService.Query", generator="Immutables")
    static final class Json
    implements TransactionJsonService.Query {
        @Nullable
        String queryType;
        @Nullable
        String truncatedQueryText;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String fullQueryTextSha1;
        double totalDurationNanos;
        boolean totalDurationNanosIsSet;
        long executionCount;
        boolean executionCountIsSet;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable Long totalRows;

        Json() {
        }

        @JsonProperty(value="queryType")
        public void setQueryType(String queryType) {
            this.queryType = queryType;
        }

        @JsonProperty(value="truncatedQueryText")
        public void setTruncatedQueryText(String truncatedQueryText) {
            this.truncatedQueryText = truncatedQueryText;
        }

        @JsonProperty(value="fullQueryTextSha1")
        public void setFullQueryTextSha1(@org.checkerframework.checker.nullness.qual.Nullable String fullQueryTextSha1) {
            this.fullQueryTextSha1 = fullQueryTextSha1;
        }

        @JsonProperty(value="totalDurationNanos")
        public void setTotalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.totalDurationNanosIsSet = true;
        }

        @JsonProperty(value="executionCount")
        public void setExecutionCount(long executionCount) {
            this.executionCount = executionCount;
            this.executionCountIsSet = true;
        }

        @JsonProperty(value="totalRows")
        public void setTotalRows(@org.checkerframework.checker.nullness.qual.Nullable Long totalRows) {
            this.totalRows = totalRows;
        }

        @Override
        public String queryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String truncatedQueryText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String fullQueryTextSha1() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double totalDurationNanos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long executionCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable Long totalRows() {
            throw new UnsupportedOperationException();
        }
    }
}

