/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ConfigJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutablePluginPropertyDto;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConfigJsonService.PluginUpdateRequest", generator="Immutables")
@Immutable
final class ImmutablePluginUpdateRequest
implements ConfigJsonService.PluginUpdateRequest {
    private final String pluginId;
    private final ImmutableList<ImmutablePluginPropertyDto> properties;
    private final String version;

    private ImmutablePluginUpdateRequest(String pluginId, ImmutableList<ImmutablePluginPropertyDto> properties, String version) {
        this.pluginId = pluginId;
        this.properties = properties;
        this.version = version;
    }

    @Override
    @JsonProperty(value="pluginId")
    public String pluginId() {
        return this.pluginId;
    }

    @JsonProperty(value="properties")
    public ImmutableList<ImmutablePluginPropertyDto> properties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final ImmutablePluginUpdateRequest withPluginId(String value) {
        String newValue = Objects.requireNonNull(value, "pluginId");
        if (this.pluginId.equals(newValue)) {
            return this;
        }
        return new ImmutablePluginUpdateRequest(newValue, this.properties, this.version);
    }

    public final ImmutablePluginUpdateRequest withProperties(ImmutablePluginPropertyDto ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutablePluginUpdateRequest(this.pluginId, (ImmutableList<ImmutablePluginPropertyDto>)newValue, this.version);
    }

    public final ImmutablePluginUpdateRequest withProperties(Iterable<? extends ImmutablePluginPropertyDto> elements) {
        if (this.properties == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutablePluginUpdateRequest(this.pluginId, (ImmutableList<ImmutablePluginPropertyDto>)newValue, this.version);
    }

    public final ImmutablePluginUpdateRequest withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutablePluginUpdateRequest(this.pluginId, this.properties, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePluginUpdateRequest && this.equalTo(0, (ImmutablePluginUpdateRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutablePluginUpdateRequest another) {
        return this.pluginId.equals(another.pluginId) && this.properties.equals(another.properties) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pluginId.hashCode();
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PluginUpdateRequest").omitNullValues().add("pluginId", (Object)this.pluginId).add("properties", this.properties).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePluginUpdateRequest fromJson(Json json) {
        Builder builder = ImmutablePluginUpdateRequest.builder();
        if (json.pluginId != null) {
            builder.pluginId(json.pluginId);
        }
        if (json.properties != null) {
            builder.addAllProperties(json.properties);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static ImmutablePluginUpdateRequest copyOf(ConfigJsonService.PluginUpdateRequest instance) {
        if (instance instanceof ImmutablePluginUpdateRequest) {
            return (ImmutablePluginUpdateRequest)instance;
        }
        return ImmutablePluginUpdateRequest.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConfigJsonService.PluginUpdateRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLUGIN_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private long initBits = 3L;
        @Nullable
        private String pluginId;
        private ImmutableList.Builder<ImmutablePluginPropertyDto> properties = ImmutableList.builder();
        @Nullable
        private String version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ConfigJsonService.PluginUpdateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.pluginId(instance.pluginId());
            this.addAllProperties(instance.properties());
            this.version(instance.version());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pluginId(String pluginId) {
            this.pluginId = Objects.requireNonNull(pluginId, "pluginId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProperties(ImmutablePluginPropertyDto element) {
            this.properties.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProperties(ImmutablePluginPropertyDto ... elements) {
            this.properties.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder properties(Iterable<? extends ImmutablePluginPropertyDto> elements) {
            this.properties = ImmutableList.builder();
            return this.addAllProperties(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllProperties(Iterable<? extends ImmutablePluginPropertyDto> elements) {
            this.properties.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePluginUpdateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePluginUpdateRequest(this.pluginId, this.properties.build(), this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pluginId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build PluginUpdateRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConfigJsonService.PluginUpdateRequest", generator="Immutables")
    static final class Json
    implements ConfigJsonService.PluginUpdateRequest {
        @Nullable
        String pluginId;
        @Nullable
        List<ImmutablePluginPropertyDto> properties = ImmutableList.of();
        @Nullable
        String version;

        Json() {
        }

        @JsonProperty(value="pluginId")
        public void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @JsonProperty(value="properties")
        public void setProperties(List<ImmutablePluginPropertyDto> properties) {
            this.properties = properties;
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @Override
        public String pluginId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ImmutablePluginPropertyDto> properties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String version() {
            throw new UnsupportedOperationException();
        }
    }
}

