/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.AdminJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AdminJsonService.LdapConfigDto", generator="Immutables")
@Immutable
final class ImmutableLdapConfigDto
extends AdminJsonService.LdapConfigDto {
    private final String host;
    private final @org.checkerframework.checker.nullness.qual.Nullable Integer port;
    private final boolean ssl;
    private final String username;
    private final boolean passwordExists;
    private final String newPassword;
    private final String userBaseDn;
    private final String userSearchFilter;
    private final String groupBaseDn;
    private final String groupSearchFilter;
    private final ImmutableMap<String, List<String>> roleMappings;
    private final @org.checkerframework.checker.nullness.qual.Nullable String authTestUsername;
    private final @org.checkerframework.checker.nullness.qual.Nullable String authTestPassword;
    private final String version;

    private ImmutableLdapConfigDto(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.ssl = builder.ssl;
        this.username = builder.username;
        this.passwordExists = builder.passwordExists;
        this.userBaseDn = builder.userBaseDn;
        this.userSearchFilter = builder.userSearchFilter;
        this.groupBaseDn = builder.groupBaseDn;
        this.groupSearchFilter = builder.groupSearchFilter;
        this.roleMappings = builder.roleMappings.build();
        this.authTestUsername = builder.authTestUsername;
        this.authTestPassword = builder.authTestPassword;
        this.version = builder.version;
        this.newPassword = builder.newPassword != null ? builder.newPassword : Objects.requireNonNull(super.newPassword(), "newPassword");
    }

    private ImmutableLdapConfigDto(String host, @org.checkerframework.checker.nullness.qual.Nullable Integer port, boolean ssl, String username, boolean passwordExists, String newPassword, String userBaseDn, String userSearchFilter, String groupBaseDn, String groupSearchFilter, ImmutableMap<String, List<String>> roleMappings, @org.checkerframework.checker.nullness.qual.Nullable String authTestUsername, @org.checkerframework.checker.nullness.qual.Nullable String authTestPassword, String version) {
        this.host = host;
        this.port = port;
        this.ssl = ssl;
        this.username = username;
        this.passwordExists = passwordExists;
        this.newPassword = newPassword;
        this.userBaseDn = userBaseDn;
        this.userSearchFilter = userSearchFilter;
        this.groupBaseDn = groupBaseDn;
        this.groupSearchFilter = groupSearchFilter;
        this.roleMappings = roleMappings;
        this.authTestUsername = authTestUsername;
        this.authTestPassword = authTestPassword;
        this.version = version;
    }

    @Override
    @JsonProperty(value="host")
    String host() {
        return this.host;
    }

    @Override
    @JsonProperty(value="port")
    @JsonInclude
    @org.checkerframework.checker.nullness.qual.Nullable Integer port() {
        return this.port;
    }

    @Override
    @JsonProperty(value="ssl")
    boolean ssl() {
        return this.ssl;
    }

    @Override
    @JsonProperty(value="username")
    String username() {
        return this.username;
    }

    @Override
    @JsonProperty(value="passwordExists")
    boolean passwordExists() {
        return this.passwordExists;
    }

    @Override
    @JsonProperty(value="newPassword")
    String newPassword() {
        return this.newPassword;
    }

    @Override
    @JsonProperty(value="userBaseDn")
    String userBaseDn() {
        return this.userBaseDn;
    }

    @Override
    @JsonProperty(value="userSearchFilter")
    String userSearchFilter() {
        return this.userSearchFilter;
    }

    @Override
    @JsonProperty(value="groupBaseDn")
    String groupBaseDn() {
        return this.groupBaseDn;
    }

    @Override
    @JsonProperty(value="groupSearchFilter")
    String groupSearchFilter() {
        return this.groupSearchFilter;
    }

    @JsonProperty(value="roleMappings")
    ImmutableMap<String, List<String>> roleMappings() {
        return this.roleMappings;
    }

    @Override
    @JsonProperty(value="authTestUsername")
    @org.checkerframework.checker.nullness.qual.Nullable String authTestUsername() {
        return this.authTestUsername;
    }

    @Override
    @JsonProperty(value="authTestPassword")
    @org.checkerframework.checker.nullness.qual.Nullable String authTestPassword() {
        return this.authTestPassword;
    }

    @Override
    @JsonProperty(value="version")
    String version() {
        return this.version;
    }

    public final ImmutableLdapConfigDto withHost(String value) {
        String newValue = Objects.requireNonNull(value, "host");
        if (this.host.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfigDto(newValue, this.port, this.ssl, this.username, this.passwordExists, this.newPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings, this.authTestUsername, this.authTestPassword, this.version);
    }

    public final ImmutableLdapConfigDto withPort(@org.checkerframework.checker.nullness.qual.Nullable Integer value) {
        if (Objects.equals(this.port, value)) {
            return this;
        }
        return new ImmutableLdapConfigDto(this.host, value, this.ssl, this.username, this.passwordExists, this.newPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings, this.authTestUsername, this.authTestPassword, this.version);
    }

    public final ImmutableLdapConfigDto withSsl(boolean value) {
        if (this.ssl == value) {
            return this;
        }
        return new ImmutableLdapConfigDto(this.host, this.port, value, this.username, this.passwordExists, this.newPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings, this.authTestUsername, this.authTestPassword, this.version);
    }

    public final ImmutableLdapConfigDto withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfigDto(this.host, this.port, this.ssl, newValue, this.passwordExists, this.newPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings, this.authTestUsername, this.authTestPassword, this.version);
    }

    public final ImmutableLdapConfigDto withPasswordExists(boolean value) {
        if (this.passwordExists == value) {
            return this;
        }
        return new ImmutableLdapConfigDto(this.host, this.port, this.ssl, this.username, value, this.newPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings, this.authTestUsername, this.authTestPassword, this.version);
    }

    public final ImmutableLdapConfigDto withNewPassword(String value) {
        String newValue = Objects.requireNonNull(value, "newPassword");
        if (this.newPassword.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfigDto(this.host, this.port, this.ssl, this.username, this.passwordExists, newValue, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings, this.authTestUsername, this.authTestPassword, this.version);
    }

    public final ImmutableLdapConfigDto withUserBaseDn(String value) {
        String newValue = Objects.requireNonNull(value, "userBaseDn");
        if (this.userBaseDn.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfigDto(this.host, this.port, this.ssl, this.username, this.passwordExists, this.newPassword, newValue, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings, this.authTestUsername, this.authTestPassword, this.version);
    }

    public final ImmutableLdapConfigDto withUserSearchFilter(String value) {
        String newValue = Objects.requireNonNull(value, "userSearchFilter");
        if (this.userSearchFilter.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfigDto(this.host, this.port, this.ssl, this.username, this.passwordExists, this.newPassword, this.userBaseDn, newValue, this.groupBaseDn, this.groupSearchFilter, this.roleMappings, this.authTestUsername, this.authTestPassword, this.version);
    }

    public final ImmutableLdapConfigDto withGroupBaseDn(String value) {
        String newValue = Objects.requireNonNull(value, "groupBaseDn");
        if (this.groupBaseDn.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfigDto(this.host, this.port, this.ssl, this.username, this.passwordExists, this.newPassword, this.userBaseDn, this.userSearchFilter, newValue, this.groupSearchFilter, this.roleMappings, this.authTestUsername, this.authTestPassword, this.version);
    }

    public final ImmutableLdapConfigDto withGroupSearchFilter(String value) {
        String newValue = Objects.requireNonNull(value, "groupSearchFilter");
        if (this.groupSearchFilter.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfigDto(this.host, this.port, this.ssl, this.username, this.passwordExists, this.newPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, newValue, this.roleMappings, this.authTestUsername, this.authTestPassword, this.version);
    }

    public final ImmutableLdapConfigDto withRoleMappings(Map<String, ? extends List<String>> entries) {
        if (this.roleMappings == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableLdapConfigDto(this.host, this.port, this.ssl, this.username, this.passwordExists, this.newPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, (ImmutableMap<String, List<String>>)newValue, this.authTestUsername, this.authTestPassword, this.version);
    }

    public final ImmutableLdapConfigDto withAuthTestUsername(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.authTestUsername, value)) {
            return this;
        }
        return new ImmutableLdapConfigDto(this.host, this.port, this.ssl, this.username, this.passwordExists, this.newPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings, value, this.authTestPassword, this.version);
    }

    public final ImmutableLdapConfigDto withAuthTestPassword(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.authTestPassword, value)) {
            return this;
        }
        return new ImmutableLdapConfigDto(this.host, this.port, this.ssl, this.username, this.passwordExists, this.newPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings, this.authTestUsername, value, this.version);
    }

    public final ImmutableLdapConfigDto withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfigDto(this.host, this.port, this.ssl, this.username, this.passwordExists, this.newPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings, this.authTestUsername, this.authTestPassword, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLdapConfigDto && this.equalTo(0, (ImmutableLdapConfigDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableLdapConfigDto another) {
        return this.host.equals(another.host) && Objects.equals(this.port, another.port) && this.ssl == another.ssl && this.username.equals(another.username) && this.passwordExists == another.passwordExists && this.newPassword.equals(another.newPassword) && this.userBaseDn.equals(another.userBaseDn) && this.userSearchFilter.equals(another.userSearchFilter) && this.groupBaseDn.equals(another.groupBaseDn) && this.groupSearchFilter.equals(another.groupSearchFilter) && this.roleMappings.equals(another.roleMappings) && Objects.equals(this.authTestUsername, another.authTestUsername) && Objects.equals(this.authTestPassword, another.authTestPassword) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Booleans.hashCode((boolean)this.ssl);
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.passwordExists);
        h += (h << 5) + this.newPassword.hashCode();
        h += (h << 5) + this.userBaseDn.hashCode();
        h += (h << 5) + this.userSearchFilter.hashCode();
        h += (h << 5) + this.groupBaseDn.hashCode();
        h += (h << 5) + this.groupSearchFilter.hashCode();
        h += (h << 5) + this.roleMappings.hashCode();
        h += (h << 5) + Objects.hashCode(this.authTestUsername);
        h += (h << 5) + Objects.hashCode(this.authTestPassword);
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LdapConfigDto").omitNullValues().add("host", (Object)this.host).add("port", (Object)this.port).add("ssl", this.ssl).add("username", (Object)this.username).add("passwordExists", this.passwordExists).add("newPassword", (Object)this.newPassword).add("userBaseDn", (Object)this.userBaseDn).add("userSearchFilter", (Object)this.userSearchFilter).add("groupBaseDn", (Object)this.groupBaseDn).add("groupSearchFilter", (Object)this.groupSearchFilter).add("roleMappings", this.roleMappings).add("authTestUsername", (Object)this.authTestUsername).add("authTestPassword", (Object)this.authTestPassword).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLdapConfigDto fromJson(Json json) {
        Builder builder = ImmutableLdapConfigDto.builder();
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.sslIsSet) {
            builder.ssl(json.ssl);
        }
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.passwordExistsIsSet) {
            builder.passwordExists(json.passwordExists);
        }
        if (json.newPassword != null) {
            builder.newPassword(json.newPassword);
        }
        if (json.userBaseDn != null) {
            builder.userBaseDn(json.userBaseDn);
        }
        if (json.userSearchFilter != null) {
            builder.userSearchFilter(json.userSearchFilter);
        }
        if (json.groupBaseDn != null) {
            builder.groupBaseDn(json.groupBaseDn);
        }
        if (json.groupSearchFilter != null) {
            builder.groupSearchFilter(json.groupSearchFilter);
        }
        if (json.roleMappings != null) {
            builder.putAllRoleMappings(json.roleMappings);
        }
        if (json.authTestUsername != null) {
            builder.authTestUsername(json.authTestUsername);
        }
        if (json.authTestPassword != null) {
            builder.authTestPassword(json.authTestPassword);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static ImmutableLdapConfigDto copyOf(AdminJsonService.LdapConfigDto instance) {
        if (instance instanceof ImmutableLdapConfigDto) {
            return (ImmutableLdapConfigDto)instance;
        }
        return ImmutableLdapConfigDto.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AdminJsonService.LdapConfigDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HOST = 1L;
        private static final long INIT_BIT_SSL = 2L;
        private static final long INIT_BIT_USERNAME = 4L;
        private static final long INIT_BIT_PASSWORD_EXISTS = 8L;
        private static final long INIT_BIT_USER_BASE_DN = 16L;
        private static final long INIT_BIT_USER_SEARCH_FILTER = 32L;
        private static final long INIT_BIT_GROUP_BASE_DN = 64L;
        private static final long INIT_BIT_GROUP_SEARCH_FILTER = 128L;
        private static final long INIT_BIT_VERSION = 256L;
        private long initBits = 511L;
        @Nullable
        private String host;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable Integer port;
        private boolean ssl;
        @Nullable
        private String username;
        private boolean passwordExists;
        @Nullable
        private String newPassword;
        @Nullable
        private String userBaseDn;
        @Nullable
        private String userSearchFilter;
        @Nullable
        private String groupBaseDn;
        @Nullable
        private String groupSearchFilter;
        private ImmutableMap.Builder<String, List<String>> roleMappings = ImmutableMap.builder();
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String authTestUsername;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String authTestPassword;
        @Nullable
        private String version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AdminJsonService.LdapConfigDto instance) {
            String authTestPasswordValue;
            Objects.requireNonNull(instance, "instance");
            this.host(instance.host());
            @org.checkerframework.checker.nullness.qual.Nullable Integer portValue = instance.port();
            if (portValue != null) {
                this.port(portValue);
            }
            this.ssl(instance.ssl());
            this.username(instance.username());
            this.passwordExists(instance.passwordExists());
            this.newPassword(instance.newPassword());
            this.userBaseDn(instance.userBaseDn());
            this.userSearchFilter(instance.userSearchFilter());
            this.groupBaseDn(instance.groupBaseDn());
            this.groupSearchFilter(instance.groupSearchFilter());
            this.putAllRoleMappings(instance.roleMappings());
            @org.checkerframework.checker.nullness.qual.Nullable String authTestUsernameValue = instance.authTestUsername();
            if (authTestUsernameValue != null) {
                this.authTestUsername(authTestUsernameValue);
            }
            if ((authTestPasswordValue = instance.authTestPassword()) != null) {
                this.authTestPassword(authTestPasswordValue);
            }
            this.version(instance.version());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder port(@org.checkerframework.checker.nullness.qual.Nullable Integer port) {
            this.port = port;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ssl(boolean ssl) {
            this.ssl = ssl;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder passwordExists(boolean passwordExists) {
            this.passwordExists = passwordExists;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder newPassword(String newPassword) {
            this.newPassword = Objects.requireNonNull(newPassword, "newPassword");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userBaseDn(String userBaseDn) {
            this.userBaseDn = Objects.requireNonNull(userBaseDn, "userBaseDn");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userSearchFilter(String userSearchFilter) {
            this.userSearchFilter = Objects.requireNonNull(userSearchFilter, "userSearchFilter");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder groupBaseDn(String groupBaseDn) {
            this.groupBaseDn = Objects.requireNonNull(groupBaseDn, "groupBaseDn");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder groupSearchFilter(String groupSearchFilter) {
            this.groupSearchFilter = Objects.requireNonNull(groupSearchFilter, "groupSearchFilter");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRoleMappings(String key, List<String> value) {
            this.roleMappings.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRoleMappings(Map.Entry<String, ? extends List<String>> entry) {
            this.roleMappings.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder roleMappings(Map<String, ? extends List<String>> entries) {
            this.roleMappings = ImmutableMap.builder();
            return this.putAllRoleMappings(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllRoleMappings(Map<String, ? extends List<String>> entries) {
            this.roleMappings.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authTestUsername(@org.checkerframework.checker.nullness.qual.Nullable String authTestUsername) {
            this.authTestUsername = authTestUsername;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authTestPassword(@org.checkerframework.checker.nullness.qual.Nullable String authTestPassword) {
            this.authTestPassword = authTestPassword;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public ImmutableLdapConfigDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLdapConfigDto(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ssl");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("passwordExists");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("userBaseDn");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("userSearchFilter");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("groupBaseDn");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("groupSearchFilter");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build LdapConfigDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AdminJsonService.LdapConfigDto", generator="Immutables")
    static final class Json
    extends AdminJsonService.LdapConfigDto {
        @Nullable
        String host;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable Integer port;
        boolean ssl;
        boolean sslIsSet;
        @Nullable
        String username;
        boolean passwordExists;
        boolean passwordExistsIsSet;
        @Nullable
        String newPassword;
        @Nullable
        String userBaseDn;
        @Nullable
        String userSearchFilter;
        @Nullable
        String groupBaseDn;
        @Nullable
        String groupSearchFilter;
        @Nullable
        Map<String, List<String>> roleMappings = ImmutableMap.of();
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String authTestUsername;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String authTestPassword;
        @Nullable
        String version;

        Json() {
        }

        @JsonProperty(value="host")
        public void setHost(String host) {
            this.host = host;
        }

        @JsonProperty(value="port")
        @JsonInclude
        public void setPort(@org.checkerframework.checker.nullness.qual.Nullable Integer port) {
            this.port = port;
        }

        @JsonProperty(value="ssl")
        public void setSsl(boolean ssl) {
            this.ssl = ssl;
            this.sslIsSet = true;
        }

        @JsonProperty(value="username")
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="passwordExists")
        public void setPasswordExists(boolean passwordExists) {
            this.passwordExists = passwordExists;
            this.passwordExistsIsSet = true;
        }

        @JsonProperty(value="newPassword")
        public void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }

        @JsonProperty(value="userBaseDn")
        public void setUserBaseDn(String userBaseDn) {
            this.userBaseDn = userBaseDn;
        }

        @JsonProperty(value="userSearchFilter")
        public void setUserSearchFilter(String userSearchFilter) {
            this.userSearchFilter = userSearchFilter;
        }

        @JsonProperty(value="groupBaseDn")
        public void setGroupBaseDn(String groupBaseDn) {
            this.groupBaseDn = groupBaseDn;
        }

        @JsonProperty(value="groupSearchFilter")
        public void setGroupSearchFilter(String groupSearchFilter) {
            this.groupSearchFilter = groupSearchFilter;
        }

        @JsonProperty(value="roleMappings")
        public void setRoleMappings(Map<String, List<String>> roleMappings) {
            this.roleMappings = roleMappings;
        }

        @JsonProperty(value="authTestUsername")
        public void setAuthTestUsername(@org.checkerframework.checker.nullness.qual.Nullable String authTestUsername) {
            this.authTestUsername = authTestUsername;
        }

        @JsonProperty(value="authTestPassword")
        public void setAuthTestPassword(@org.checkerframework.checker.nullness.qual.Nullable String authTestPassword) {
            this.authTestPassword = authTestPassword;
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @Override
        String host() {
            throw new UnsupportedOperationException();
        }

        @Override
        @org.checkerframework.checker.nullness.qual.Nullable Integer port() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean ssl() {
            throw new UnsupportedOperationException();
        }

        @Override
        String username() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean passwordExists() {
            throw new UnsupportedOperationException();
        }

        @Override
        String newPassword() {
            throw new UnsupportedOperationException();
        }

        @Override
        String userBaseDn() {
            throw new UnsupportedOperationException();
        }

        @Override
        String userSearchFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        String groupBaseDn() {
            throw new UnsupportedOperationException();
        }

        @Override
        String groupSearchFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        Map<String, List<String>> roleMappings() {
            throw new UnsupportedOperationException();
        }

        @Override
        @org.checkerframework.checker.nullness.qual.Nullable String authTestUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        @org.checkerframework.checker.nullness.qual.Nullable String authTestPassword() {
            throw new UnsupportedOperationException();
        }

        @Override
        String version() {
            throw new UnsupportedOperationException();
        }
    }
}

