/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.LayoutService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LayoutService.Layout", generator="Immutables")
@Immutable
final class ImmutableLayout
extends LayoutService.Layout {
    private final boolean central;
    private final boolean offlineViewer;
    private final String glowrootVersion;
    private final boolean loginEnabled;
    private final ImmutableList<ConfigRepository.RollupConfig> rollupConfigs;
    private final ImmutableList<Long> rollupExpirationMillis;
    private final ImmutableList<Long> queryAndServiceCallRollupExpirationMillis;
    private final ImmutableList<Long> profileRollupExpirationMillis;
    private final long gaugeCollectionIntervalMillis;
    private final boolean showNavbarTransaction;
    private final boolean showNavbarError;
    private final boolean showNavbarJvm;
    private final boolean showNavbarSyntheticMonitor;
    private final boolean showNavbarIncident;
    private final boolean showNavbarReport;
    private final boolean showNavbarConfig;
    private final boolean adminView;
    private final boolean adminEdit;
    private final boolean loggedIn;
    private final boolean ldap;
    private final boolean redirectToLogin;
    private final String defaultTimeZoneId;
    private final ImmutableList<String> timeZoneIds;
    private final  @org.checkerframework.checker.nullness.qual.Nullable LayoutService.AgentRollupLayout embeddedAgentRollup;
    private final transient String version;

    private ImmutableLayout(boolean central, boolean offlineViewer, String glowrootVersion, boolean loginEnabled, ImmutableList<ConfigRepository.RollupConfig> rollupConfigs, ImmutableList<Long> rollupExpirationMillis, ImmutableList<Long> queryAndServiceCallRollupExpirationMillis, ImmutableList<Long> profileRollupExpirationMillis, long gaugeCollectionIntervalMillis, boolean showNavbarTransaction, boolean showNavbarError, boolean showNavbarJvm, boolean showNavbarSyntheticMonitor, boolean showNavbarIncident, boolean showNavbarReport, boolean showNavbarConfig, boolean adminView, boolean adminEdit, boolean loggedIn, boolean ldap, boolean redirectToLogin, String defaultTimeZoneId, ImmutableList<String> timeZoneIds,  @org.checkerframework.checker.nullness.qual.Nullable LayoutService.AgentRollupLayout embeddedAgentRollup) {
        this.central = central;
        this.offlineViewer = offlineViewer;
        this.glowrootVersion = glowrootVersion;
        this.loginEnabled = loginEnabled;
        this.rollupConfigs = rollupConfigs;
        this.rollupExpirationMillis = rollupExpirationMillis;
        this.queryAndServiceCallRollupExpirationMillis = queryAndServiceCallRollupExpirationMillis;
        this.profileRollupExpirationMillis = profileRollupExpirationMillis;
        this.gaugeCollectionIntervalMillis = gaugeCollectionIntervalMillis;
        this.showNavbarTransaction = showNavbarTransaction;
        this.showNavbarError = showNavbarError;
        this.showNavbarJvm = showNavbarJvm;
        this.showNavbarSyntheticMonitor = showNavbarSyntheticMonitor;
        this.showNavbarIncident = showNavbarIncident;
        this.showNavbarReport = showNavbarReport;
        this.showNavbarConfig = showNavbarConfig;
        this.adminView = adminView;
        this.adminEdit = adminEdit;
        this.loggedIn = loggedIn;
        this.ldap = ldap;
        this.redirectToLogin = redirectToLogin;
        this.defaultTimeZoneId = defaultTimeZoneId;
        this.timeZoneIds = timeZoneIds;
        this.embeddedAgentRollup = embeddedAgentRollup;
        this.version = Objects.requireNonNull(super.version(), "version");
    }

    @Override
    @JsonProperty(value="central")
    boolean central() {
        return this.central;
    }

    @Override
    @JsonProperty(value="offlineViewer")
    boolean offlineViewer() {
        return this.offlineViewer;
    }

    @Override
    @JsonProperty(value="glowrootVersion")
    String glowrootVersion() {
        return this.glowrootVersion;
    }

    @Override
    @JsonProperty(value="loginEnabled")
    boolean loginEnabled() {
        return this.loginEnabled;
    }

    @Override
    @JsonProperty(value="rollupConfigs")
    ImmutableList<ConfigRepository.RollupConfig> rollupConfigs() {
        return this.rollupConfigs;
    }

    @Override
    @JsonProperty(value="rollupExpirationMillis")
    ImmutableList<Long> rollupExpirationMillis() {
        return this.rollupExpirationMillis;
    }

    @Override
    @JsonProperty(value="queryAndServiceCallRollupExpirationMillis")
    ImmutableList<Long> queryAndServiceCallRollupExpirationMillis() {
        return this.queryAndServiceCallRollupExpirationMillis;
    }

    @Override
    @JsonProperty(value="profileRollupExpirationMillis")
    ImmutableList<Long> profileRollupExpirationMillis() {
        return this.profileRollupExpirationMillis;
    }

    @Override
    @JsonProperty(value="gaugeCollectionIntervalMillis")
    long gaugeCollectionIntervalMillis() {
        return this.gaugeCollectionIntervalMillis;
    }

    @Override
    @JsonProperty(value="showNavbarTransaction")
    boolean showNavbarTransaction() {
        return this.showNavbarTransaction;
    }

    @Override
    @JsonProperty(value="showNavbarError")
    boolean showNavbarError() {
        return this.showNavbarError;
    }

    @Override
    @JsonProperty(value="showNavbarJvm")
    boolean showNavbarJvm() {
        return this.showNavbarJvm;
    }

    @Override
    @JsonProperty(value="showNavbarSyntheticMonitor")
    boolean showNavbarSyntheticMonitor() {
        return this.showNavbarSyntheticMonitor;
    }

    @Override
    @JsonProperty(value="showNavbarIncident")
    boolean showNavbarIncident() {
        return this.showNavbarIncident;
    }

    @Override
    @JsonProperty(value="showNavbarReport")
    boolean showNavbarReport() {
        return this.showNavbarReport;
    }

    @Override
    @JsonProperty(value="showNavbarConfig")
    boolean showNavbarConfig() {
        return this.showNavbarConfig;
    }

    @Override
    @JsonProperty(value="adminView")
    boolean adminView() {
        return this.adminView;
    }

    @Override
    @JsonProperty(value="adminEdit")
    boolean adminEdit() {
        return this.adminEdit;
    }

    @Override
    @JsonProperty(value="loggedIn")
    boolean loggedIn() {
        return this.loggedIn;
    }

    @Override
    @JsonProperty(value="ldap")
    boolean ldap() {
        return this.ldap;
    }

    @Override
    @JsonProperty(value="redirectToLogin")
    boolean redirectToLogin() {
        return this.redirectToLogin;
    }

    @Override
    @JsonProperty(value="defaultTimeZoneId")
    String defaultTimeZoneId() {
        return this.defaultTimeZoneId;
    }

    @JsonProperty(value="timeZoneIds")
    ImmutableList<String> timeZoneIds() {
        return this.timeZoneIds;
    }

    @Override
    @JsonProperty(value="embeddedAgentRollup")
     @org.checkerframework.checker.nullness.qual.Nullable LayoutService.AgentRollupLayout embeddedAgentRollup() {
        return this.embeddedAgentRollup;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final ImmutableLayout withCentral(boolean value) {
        if (this.central == value) {
            return this;
        }
        return new ImmutableLayout(value, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withOfflineViewer(boolean value) {
        if (this.offlineViewer == value) {
            return this;
        }
        return new ImmutableLayout(this.central, value, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withGlowrootVersion(String value) {
        String newValue = Objects.requireNonNull(value, "glowrootVersion");
        if (this.glowrootVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, newValue, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withLoginEnabled(boolean value) {
        if (this.loginEnabled == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, value, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withRollupConfigs(ConfigRepository.RollupConfig ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, (ImmutableList<ConfigRepository.RollupConfig>)newValue, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withRollupConfigs(Iterable<? extends ConfigRepository.RollupConfig> elements) {
        if (this.rollupConfigs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, (ImmutableList<ConfigRepository.RollupConfig>)newValue, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withRollupExpirationMillis(long ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Longs.asList((long[])elements));
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, (ImmutableList<Long>)newValue, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withRollupExpirationMillis(Iterable<Long> elements) {
        if (this.rollupExpirationMillis == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, (ImmutableList<Long>)newValue, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withQueryAndServiceCallRollupExpirationMillis(long ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Longs.asList((long[])elements));
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, (ImmutableList<Long>)newValue, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withQueryAndServiceCallRollupExpirationMillis(Iterable<Long> elements) {
        if (this.queryAndServiceCallRollupExpirationMillis == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, (ImmutableList<Long>)newValue, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withProfileRollupExpirationMillis(long ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Longs.asList((long[])elements));
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, (ImmutableList<Long>)newValue, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withProfileRollupExpirationMillis(Iterable<Long> elements) {
        if (this.profileRollupExpirationMillis == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, (ImmutableList<Long>)newValue, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withGaugeCollectionIntervalMillis(long value) {
        if (this.gaugeCollectionIntervalMillis == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, value, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withShowNavbarTransaction(boolean value) {
        if (this.showNavbarTransaction == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, value, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withShowNavbarError(boolean value) {
        if (this.showNavbarError == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, value, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withShowNavbarJvm(boolean value) {
        if (this.showNavbarJvm == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, value, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withShowNavbarSyntheticMonitor(boolean value) {
        if (this.showNavbarSyntheticMonitor == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, value, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withShowNavbarIncident(boolean value) {
        if (this.showNavbarIncident == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, value, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withShowNavbarReport(boolean value) {
        if (this.showNavbarReport == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, value, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withShowNavbarConfig(boolean value) {
        if (this.showNavbarConfig == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, value, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withAdminView(boolean value) {
        if (this.adminView == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, value, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withAdminEdit(boolean value) {
        if (this.adminEdit == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, value, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withLoggedIn(boolean value) {
        if (this.loggedIn == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, value, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withLdap(boolean value) {
        if (this.ldap == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, value, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withRedirectToLogin(boolean value) {
        if (this.redirectToLogin == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, value, this.defaultTimeZoneId, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withDefaultTimeZoneId(String value) {
        String newValue = Objects.requireNonNull(value, "defaultTimeZoneId");
        if (this.defaultTimeZoneId.equals(newValue)) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, newValue, this.timeZoneIds, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withTimeZoneIds(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, (ImmutableList<String>)newValue, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withTimeZoneIds(Iterable<String> elements) {
        if (this.timeZoneIds == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, (ImmutableList<String>)newValue, this.embeddedAgentRollup);
    }

    public final ImmutableLayout withEmbeddedAgentRollup( @org.checkerframework.checker.nullness.qual.Nullable LayoutService.AgentRollupLayout value) {
        if (this.embeddedAgentRollup == value) {
            return this;
        }
        return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs, this.rollupExpirationMillis, this.queryAndServiceCallRollupExpirationMillis, this.profileRollupExpirationMillis, this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLayout && this.equalTo(0, (ImmutableLayout)another);
    }

    private boolean equalTo(int synthetic, ImmutableLayout another) {
        return this.central == another.central && this.offlineViewer == another.offlineViewer && this.glowrootVersion.equals(another.glowrootVersion) && this.loginEnabled == another.loginEnabled && this.rollupConfigs.equals(another.rollupConfigs) && this.rollupExpirationMillis.equals(another.rollupExpirationMillis) && this.queryAndServiceCallRollupExpirationMillis.equals(another.queryAndServiceCallRollupExpirationMillis) && this.profileRollupExpirationMillis.equals(another.profileRollupExpirationMillis) && this.gaugeCollectionIntervalMillis == another.gaugeCollectionIntervalMillis && this.showNavbarTransaction == another.showNavbarTransaction && this.showNavbarError == another.showNavbarError && this.showNavbarJvm == another.showNavbarJvm && this.showNavbarSyntheticMonitor == another.showNavbarSyntheticMonitor && this.showNavbarIncident == another.showNavbarIncident && this.showNavbarReport == another.showNavbarReport && this.showNavbarConfig == another.showNavbarConfig && this.adminView == another.adminView && this.adminEdit == another.adminEdit && this.loggedIn == another.loggedIn && this.ldap == another.ldap && this.redirectToLogin == another.redirectToLogin && this.defaultTimeZoneId.equals(another.defaultTimeZoneId) && this.timeZoneIds.equals(another.timeZoneIds) && Objects.equals(this.embeddedAgentRollup, another.embeddedAgentRollup) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.central);
        h += (h << 5) + Booleans.hashCode((boolean)this.offlineViewer);
        h += (h << 5) + this.glowrootVersion.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.loginEnabled);
        h += (h << 5) + this.rollupConfigs.hashCode();
        h += (h << 5) + this.rollupExpirationMillis.hashCode();
        h += (h << 5) + this.queryAndServiceCallRollupExpirationMillis.hashCode();
        h += (h << 5) + this.profileRollupExpirationMillis.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.gaugeCollectionIntervalMillis);
        h += (h << 5) + Booleans.hashCode((boolean)this.showNavbarTransaction);
        h += (h << 5) + Booleans.hashCode((boolean)this.showNavbarError);
        h += (h << 5) + Booleans.hashCode((boolean)this.showNavbarJvm);
        h += (h << 5) + Booleans.hashCode((boolean)this.showNavbarSyntheticMonitor);
        h += (h << 5) + Booleans.hashCode((boolean)this.showNavbarIncident);
        h += (h << 5) + Booleans.hashCode((boolean)this.showNavbarReport);
        h += (h << 5) + Booleans.hashCode((boolean)this.showNavbarConfig);
        h += (h << 5) + Booleans.hashCode((boolean)this.adminView);
        h += (h << 5) + Booleans.hashCode((boolean)this.adminEdit);
        h += (h << 5) + Booleans.hashCode((boolean)this.loggedIn);
        h += (h << 5) + Booleans.hashCode((boolean)this.ldap);
        h += (h << 5) + Booleans.hashCode((boolean)this.redirectToLogin);
        h += (h << 5) + this.defaultTimeZoneId.hashCode();
        h += (h << 5) + this.timeZoneIds.hashCode();
        h += (h << 5) + Objects.hashCode(this.embeddedAgentRollup);
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Layout").omitNullValues().add("central", this.central).add("offlineViewer", this.offlineViewer).add("glowrootVersion", (Object)this.glowrootVersion).add("loginEnabled", this.loginEnabled).add("rollupConfigs", this.rollupConfigs).add("rollupExpirationMillis", this.rollupExpirationMillis).add("queryAndServiceCallRollupExpirationMillis", this.queryAndServiceCallRollupExpirationMillis).add("profileRollupExpirationMillis", this.profileRollupExpirationMillis).add("gaugeCollectionIntervalMillis", this.gaugeCollectionIntervalMillis).add("showNavbarTransaction", this.showNavbarTransaction).add("showNavbarError", this.showNavbarError).add("showNavbarJvm", this.showNavbarJvm).add("showNavbarSyntheticMonitor", this.showNavbarSyntheticMonitor).add("showNavbarIncident", this.showNavbarIncident).add("showNavbarReport", this.showNavbarReport).add("showNavbarConfig", this.showNavbarConfig).add("adminView", this.adminView).add("adminEdit", this.adminEdit).add("loggedIn", this.loggedIn).add("ldap", this.ldap).add("redirectToLogin", this.redirectToLogin).add("defaultTimeZoneId", (Object)this.defaultTimeZoneId).add("timeZoneIds", this.timeZoneIds).add("embeddedAgentRollup", (Object)this.embeddedAgentRollup).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLayout fromJson(Json json) {
        Builder builder = ImmutableLayout.builder();
        if (json.centralIsSet) {
            builder.central(json.central);
        }
        if (json.offlineViewerIsSet) {
            builder.offlineViewer(json.offlineViewer);
        }
        if (json.glowrootVersion != null) {
            builder.glowrootVersion(json.glowrootVersion);
        }
        if (json.loginEnabledIsSet) {
            builder.loginEnabled(json.loginEnabled);
        }
        if (json.rollupConfigs != null) {
            builder.addAllRollupConfigs((Iterable<? extends ConfigRepository.RollupConfig>)json.rollupConfigs);
        }
        if (json.rollupExpirationMillis != null) {
            builder.addAllRollupExpirationMillis((Iterable<Long>)json.rollupExpirationMillis);
        }
        if (json.queryAndServiceCallRollupExpirationMillis != null) {
            builder.addAllQueryAndServiceCallRollupExpirationMillis((Iterable<Long>)json.queryAndServiceCallRollupExpirationMillis);
        }
        if (json.profileRollupExpirationMillis != null) {
            builder.addAllProfileRollupExpirationMillis((Iterable<Long>)json.profileRollupExpirationMillis);
        }
        if (json.gaugeCollectionIntervalMillisIsSet) {
            builder.gaugeCollectionIntervalMillis(json.gaugeCollectionIntervalMillis);
        }
        if (json.showNavbarTransactionIsSet) {
            builder.showNavbarTransaction(json.showNavbarTransaction);
        }
        if (json.showNavbarErrorIsSet) {
            builder.showNavbarError(json.showNavbarError);
        }
        if (json.showNavbarJvmIsSet) {
            builder.showNavbarJvm(json.showNavbarJvm);
        }
        if (json.showNavbarSyntheticMonitorIsSet) {
            builder.showNavbarSyntheticMonitor(json.showNavbarSyntheticMonitor);
        }
        if (json.showNavbarIncidentIsSet) {
            builder.showNavbarIncident(json.showNavbarIncident);
        }
        if (json.showNavbarReportIsSet) {
            builder.showNavbarReport(json.showNavbarReport);
        }
        if (json.showNavbarConfigIsSet) {
            builder.showNavbarConfig(json.showNavbarConfig);
        }
        if (json.adminViewIsSet) {
            builder.adminView(json.adminView);
        }
        if (json.adminEditIsSet) {
            builder.adminEdit(json.adminEdit);
        }
        if (json.loggedInIsSet) {
            builder.loggedIn(json.loggedIn);
        }
        if (json.ldapIsSet) {
            builder.ldap(json.ldap);
        }
        if (json.redirectToLoginIsSet) {
            builder.redirectToLogin(json.redirectToLogin);
        }
        if (json.defaultTimeZoneId != null) {
            builder.defaultTimeZoneId(json.defaultTimeZoneId);
        }
        if (json.timeZoneIds != null) {
            builder.addAllTimeZoneIds(json.timeZoneIds);
        }
        if (json.embeddedAgentRollup != null) {
            builder.embeddedAgentRollup(json.embeddedAgentRollup);
        }
        return builder.build();
    }

    public static ImmutableLayout copyOf(LayoutService.Layout instance) {
        if (instance instanceof ImmutableLayout) {
            return (ImmutableLayout)instance;
        }
        return ImmutableLayout.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LayoutService.Layout", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CENTRAL = 1L;
        private static final long INIT_BIT_OFFLINE_VIEWER = 2L;
        private static final long INIT_BIT_GLOWROOT_VERSION = 4L;
        private static final long INIT_BIT_LOGIN_ENABLED = 8L;
        private static final long INIT_BIT_GAUGE_COLLECTION_INTERVAL_MILLIS = 16L;
        private static final long INIT_BIT_SHOW_NAVBAR_TRANSACTION = 32L;
        private static final long INIT_BIT_SHOW_NAVBAR_ERROR = 64L;
        private static final long INIT_BIT_SHOW_NAVBAR_JVM = 128L;
        private static final long INIT_BIT_SHOW_NAVBAR_SYNTHETIC_MONITOR = 256L;
        private static final long INIT_BIT_SHOW_NAVBAR_INCIDENT = 512L;
        private static final long INIT_BIT_SHOW_NAVBAR_REPORT = 1024L;
        private static final long INIT_BIT_SHOW_NAVBAR_CONFIG = 2048L;
        private static final long INIT_BIT_ADMIN_VIEW = 4096L;
        private static final long INIT_BIT_ADMIN_EDIT = 8192L;
        private static final long INIT_BIT_LOGGED_IN = 16384L;
        private static final long INIT_BIT_LDAP = 32768L;
        private static final long INIT_BIT_REDIRECT_TO_LOGIN = 65536L;
        private static final long INIT_BIT_DEFAULT_TIME_ZONE_ID = 131072L;
        private long initBits = 262143L;
        private boolean central;
        private boolean offlineViewer;
        @Nullable
        private String glowrootVersion;
        private boolean loginEnabled;
        private ImmutableList.Builder<ConfigRepository.RollupConfig> rollupConfigs = ImmutableList.builder();
        private ImmutableList.Builder<Long> rollupExpirationMillis = ImmutableList.builder();
        private ImmutableList.Builder<Long> queryAndServiceCallRollupExpirationMillis = ImmutableList.builder();
        private ImmutableList.Builder<Long> profileRollupExpirationMillis = ImmutableList.builder();
        private long gaugeCollectionIntervalMillis;
        private boolean showNavbarTransaction;
        private boolean showNavbarError;
        private boolean showNavbarJvm;
        private boolean showNavbarSyntheticMonitor;
        private boolean showNavbarIncident;
        private boolean showNavbarReport;
        private boolean showNavbarConfig;
        private boolean adminView;
        private boolean adminEdit;
        private boolean loggedIn;
        private boolean ldap;
        private boolean redirectToLogin;
        @Nullable
        private String defaultTimeZoneId;
        private ImmutableList.Builder<String> timeZoneIds = ImmutableList.builder();
        @Nullable
        private  @org.checkerframework.checker.nullness.qual.Nullable LayoutService.AgentRollupLayout embeddedAgentRollup;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(LayoutService.Layout instance) {
            Objects.requireNonNull(instance, "instance");
            this.central(instance.central());
            this.offlineViewer(instance.offlineViewer());
            this.glowrootVersion(instance.glowrootVersion());
            this.loginEnabled(instance.loginEnabled());
            this.addAllRollupConfigs((Iterable<? extends ConfigRepository.RollupConfig>)instance.rollupConfigs());
            this.addAllRollupExpirationMillis((Iterable<Long>)instance.rollupExpirationMillis());
            this.addAllQueryAndServiceCallRollupExpirationMillis((Iterable<Long>)instance.queryAndServiceCallRollupExpirationMillis());
            this.addAllProfileRollupExpirationMillis((Iterable<Long>)instance.profileRollupExpirationMillis());
            this.gaugeCollectionIntervalMillis(instance.gaugeCollectionIntervalMillis());
            this.showNavbarTransaction(instance.showNavbarTransaction());
            this.showNavbarError(instance.showNavbarError());
            this.showNavbarJvm(instance.showNavbarJvm());
            this.showNavbarSyntheticMonitor(instance.showNavbarSyntheticMonitor());
            this.showNavbarIncident(instance.showNavbarIncident());
            this.showNavbarReport(instance.showNavbarReport());
            this.showNavbarConfig(instance.showNavbarConfig());
            this.adminView(instance.adminView());
            this.adminEdit(instance.adminEdit());
            this.loggedIn(instance.loggedIn());
            this.ldap(instance.ldap());
            this.redirectToLogin(instance.redirectToLogin());
            this.defaultTimeZoneId(instance.defaultTimeZoneId());
            this.addAllTimeZoneIds(instance.timeZoneIds());
             @org.checkerframework.checker.nullness.qual.Nullable LayoutService.AgentRollupLayout embeddedAgentRollupValue = instance.embeddedAgentRollup();
            if (embeddedAgentRollupValue != null) {
                this.embeddedAgentRollup(embeddedAgentRollupValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder central(boolean central) {
            this.central = central;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder offlineViewer(boolean offlineViewer) {
            this.offlineViewer = offlineViewer;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder glowrootVersion(String glowrootVersion) {
            this.glowrootVersion = Objects.requireNonNull(glowrootVersion, "glowrootVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loginEnabled(boolean loginEnabled) {
            this.loginEnabled = loginEnabled;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRollupConfigs(ConfigRepository.RollupConfig element) {
            this.rollupConfigs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRollupConfigs(ConfigRepository.RollupConfig ... elements) {
            this.rollupConfigs.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rollupConfigs(Iterable<? extends ConfigRepository.RollupConfig> elements) {
            this.rollupConfigs = ImmutableList.builder();
            return this.addAllRollupConfigs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRollupConfigs(Iterable<? extends ConfigRepository.RollupConfig> elements) {
            this.rollupConfigs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRollupExpirationMillis(long element) {
            this.rollupExpirationMillis.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRollupExpirationMillis(long ... elements) {
            this.rollupExpirationMillis.addAll((Iterable)Longs.asList((long[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rollupExpirationMillis(Iterable<Long> elements) {
            this.rollupExpirationMillis = ImmutableList.builder();
            return this.addAllRollupExpirationMillis(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRollupExpirationMillis(Iterable<Long> elements) {
            this.rollupExpirationMillis.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addQueryAndServiceCallRollupExpirationMillis(long element) {
            this.queryAndServiceCallRollupExpirationMillis.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addQueryAndServiceCallRollupExpirationMillis(long ... elements) {
            this.queryAndServiceCallRollupExpirationMillis.addAll((Iterable)Longs.asList((long[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queryAndServiceCallRollupExpirationMillis(Iterable<Long> elements) {
            this.queryAndServiceCallRollupExpirationMillis = ImmutableList.builder();
            return this.addAllQueryAndServiceCallRollupExpirationMillis(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllQueryAndServiceCallRollupExpirationMillis(Iterable<Long> elements) {
            this.queryAndServiceCallRollupExpirationMillis.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProfileRollupExpirationMillis(long element) {
            this.profileRollupExpirationMillis.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProfileRollupExpirationMillis(long ... elements) {
            this.profileRollupExpirationMillis.addAll((Iterable)Longs.asList((long[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder profileRollupExpirationMillis(Iterable<Long> elements) {
            this.profileRollupExpirationMillis = ImmutableList.builder();
            return this.addAllProfileRollupExpirationMillis(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllProfileRollupExpirationMillis(Iterable<Long> elements) {
            this.profileRollupExpirationMillis.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gaugeCollectionIntervalMillis(long gaugeCollectionIntervalMillis) {
            this.gaugeCollectionIntervalMillis = gaugeCollectionIntervalMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder showNavbarTransaction(boolean showNavbarTransaction) {
            this.showNavbarTransaction = showNavbarTransaction;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder showNavbarError(boolean showNavbarError) {
            this.showNavbarError = showNavbarError;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder showNavbarJvm(boolean showNavbarJvm) {
            this.showNavbarJvm = showNavbarJvm;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder showNavbarSyntheticMonitor(boolean showNavbarSyntheticMonitor) {
            this.showNavbarSyntheticMonitor = showNavbarSyntheticMonitor;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder showNavbarIncident(boolean showNavbarIncident) {
            this.showNavbarIncident = showNavbarIncident;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder showNavbarReport(boolean showNavbarReport) {
            this.showNavbarReport = showNavbarReport;
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder showNavbarConfig(boolean showNavbarConfig) {
            this.showNavbarConfig = showNavbarConfig;
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder adminView(boolean adminView) {
            this.adminView = adminView;
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder adminEdit(boolean adminEdit) {
            this.adminEdit = adminEdit;
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loggedIn(boolean loggedIn) {
            this.loggedIn = loggedIn;
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ldap(boolean ldap) {
            this.ldap = ldap;
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder redirectToLogin(boolean redirectToLogin) {
            this.redirectToLogin = redirectToLogin;
            this.initBits &= 0xFFFFFFFFFFFEFFFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultTimeZoneId(String defaultTimeZoneId) {
            this.defaultTimeZoneId = Objects.requireNonNull(defaultTimeZoneId, "defaultTimeZoneId");
            this.initBits &= 0xFFFFFFFFFFFDFFFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTimeZoneIds(String element) {
            this.timeZoneIds.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTimeZoneIds(String ... elements) {
            this.timeZoneIds.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timeZoneIds(Iterable<String> elements) {
            this.timeZoneIds = ImmutableList.builder();
            return this.addAllTimeZoneIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTimeZoneIds(Iterable<String> elements) {
            this.timeZoneIds.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder embeddedAgentRollup( @org.checkerframework.checker.nullness.qual.Nullable LayoutService.AgentRollupLayout embeddedAgentRollup) {
            this.embeddedAgentRollup = embeddedAgentRollup;
            return this;
        }

        public ImmutableLayout build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLayout(this.central, this.offlineViewer, this.glowrootVersion, this.loginEnabled, this.rollupConfigs.build(), this.rollupExpirationMillis.build(), this.queryAndServiceCallRollupExpirationMillis.build(), this.profileRollupExpirationMillis.build(), this.gaugeCollectionIntervalMillis, this.showNavbarTransaction, this.showNavbarError, this.showNavbarJvm, this.showNavbarSyntheticMonitor, this.showNavbarIncident, this.showNavbarReport, this.showNavbarConfig, this.adminView, this.adminEdit, this.loggedIn, this.ldap, this.redirectToLogin, this.defaultTimeZoneId, this.timeZoneIds.build(), this.embeddedAgentRollup);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("central");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offlineViewer");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("glowrootVersion");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("loginEnabled");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("gaugeCollectionIntervalMillis");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("showNavbarTransaction");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("showNavbarError");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("showNavbarJvm");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("showNavbarSyntheticMonitor");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("showNavbarIncident");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("showNavbarReport");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("showNavbarConfig");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("adminView");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("adminEdit");
            }
            if ((this.initBits & 0x4000L) != 0L) {
                attributes.add("loggedIn");
            }
            if ((this.initBits & 0x8000L) != 0L) {
                attributes.add("ldap");
            }
            if ((this.initBits & 0x10000L) != 0L) {
                attributes.add("redirectToLogin");
            }
            if ((this.initBits & 0x20000L) != 0L) {
                attributes.add("defaultTimeZoneId");
            }
            return "Cannot build Layout, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LayoutService.Layout", generator="Immutables")
    static final class Json
    extends LayoutService.Layout {
        boolean central;
        boolean centralIsSet;
        boolean offlineViewer;
        boolean offlineViewerIsSet;
        @Nullable
        String glowrootVersion;
        boolean loginEnabled;
        boolean loginEnabledIsSet;
        @Nullable
        ImmutableList<ConfigRepository.RollupConfig> rollupConfigs = ImmutableList.of();
        @Nullable
        ImmutableList<Long> rollupExpirationMillis = ImmutableList.of();
        @Nullable
        ImmutableList<Long> queryAndServiceCallRollupExpirationMillis = ImmutableList.of();
        @Nullable
        ImmutableList<Long> profileRollupExpirationMillis = ImmutableList.of();
        long gaugeCollectionIntervalMillis;
        boolean gaugeCollectionIntervalMillisIsSet;
        boolean showNavbarTransaction;
        boolean showNavbarTransactionIsSet;
        boolean showNavbarError;
        boolean showNavbarErrorIsSet;
        boolean showNavbarJvm;
        boolean showNavbarJvmIsSet;
        boolean showNavbarSyntheticMonitor;
        boolean showNavbarSyntheticMonitorIsSet;
        boolean showNavbarIncident;
        boolean showNavbarIncidentIsSet;
        boolean showNavbarReport;
        boolean showNavbarReportIsSet;
        boolean showNavbarConfig;
        boolean showNavbarConfigIsSet;
        boolean adminView;
        boolean adminViewIsSet;
        boolean adminEdit;
        boolean adminEditIsSet;
        boolean loggedIn;
        boolean loggedInIsSet;
        boolean ldap;
        boolean ldapIsSet;
        boolean redirectToLogin;
        boolean redirectToLoginIsSet;
        @Nullable
        String defaultTimeZoneId;
        @Nullable
        List<String> timeZoneIds = ImmutableList.of();
        @Nullable
         @org.checkerframework.checker.nullness.qual.Nullable LayoutService.AgentRollupLayout embeddedAgentRollup;

        Json() {
        }

        @JsonProperty(value="central")
        public void setCentral(boolean central) {
            this.central = central;
            this.centralIsSet = true;
        }

        @JsonProperty(value="offlineViewer")
        public void setOfflineViewer(boolean offlineViewer) {
            this.offlineViewer = offlineViewer;
            this.offlineViewerIsSet = true;
        }

        @JsonProperty(value="glowrootVersion")
        public void setGlowrootVersion(String glowrootVersion) {
            this.glowrootVersion = glowrootVersion;
        }

        @JsonProperty(value="loginEnabled")
        public void setLoginEnabled(boolean loginEnabled) {
            this.loginEnabled = loginEnabled;
            this.loginEnabledIsSet = true;
        }

        @JsonProperty(value="rollupConfigs")
        public void setRollupConfigs(ImmutableList<ConfigRepository.RollupConfig> rollupConfigs) {
            this.rollupConfigs = rollupConfigs;
        }

        @JsonProperty(value="rollupExpirationMillis")
        public void setRollupExpirationMillis(ImmutableList<Long> rollupExpirationMillis) {
            this.rollupExpirationMillis = rollupExpirationMillis;
        }

        @JsonProperty(value="queryAndServiceCallRollupExpirationMillis")
        public void setQueryAndServiceCallRollupExpirationMillis(ImmutableList<Long> queryAndServiceCallRollupExpirationMillis) {
            this.queryAndServiceCallRollupExpirationMillis = queryAndServiceCallRollupExpirationMillis;
        }

        @JsonProperty(value="profileRollupExpirationMillis")
        public void setProfileRollupExpirationMillis(ImmutableList<Long> profileRollupExpirationMillis) {
            this.profileRollupExpirationMillis = profileRollupExpirationMillis;
        }

        @JsonProperty(value="gaugeCollectionIntervalMillis")
        public void setGaugeCollectionIntervalMillis(long gaugeCollectionIntervalMillis) {
            this.gaugeCollectionIntervalMillis = gaugeCollectionIntervalMillis;
            this.gaugeCollectionIntervalMillisIsSet = true;
        }

        @JsonProperty(value="showNavbarTransaction")
        public void setShowNavbarTransaction(boolean showNavbarTransaction) {
            this.showNavbarTransaction = showNavbarTransaction;
            this.showNavbarTransactionIsSet = true;
        }

        @JsonProperty(value="showNavbarError")
        public void setShowNavbarError(boolean showNavbarError) {
            this.showNavbarError = showNavbarError;
            this.showNavbarErrorIsSet = true;
        }

        @JsonProperty(value="showNavbarJvm")
        public void setShowNavbarJvm(boolean showNavbarJvm) {
            this.showNavbarJvm = showNavbarJvm;
            this.showNavbarJvmIsSet = true;
        }

        @JsonProperty(value="showNavbarSyntheticMonitor")
        public void setShowNavbarSyntheticMonitor(boolean showNavbarSyntheticMonitor) {
            this.showNavbarSyntheticMonitor = showNavbarSyntheticMonitor;
            this.showNavbarSyntheticMonitorIsSet = true;
        }

        @JsonProperty(value="showNavbarIncident")
        public void setShowNavbarIncident(boolean showNavbarIncident) {
            this.showNavbarIncident = showNavbarIncident;
            this.showNavbarIncidentIsSet = true;
        }

        @JsonProperty(value="showNavbarReport")
        public void setShowNavbarReport(boolean showNavbarReport) {
            this.showNavbarReport = showNavbarReport;
            this.showNavbarReportIsSet = true;
        }

        @JsonProperty(value="showNavbarConfig")
        public void setShowNavbarConfig(boolean showNavbarConfig) {
            this.showNavbarConfig = showNavbarConfig;
            this.showNavbarConfigIsSet = true;
        }

        @JsonProperty(value="adminView")
        public void setAdminView(boolean adminView) {
            this.adminView = adminView;
            this.adminViewIsSet = true;
        }

        @JsonProperty(value="adminEdit")
        public void setAdminEdit(boolean adminEdit) {
            this.adminEdit = adminEdit;
            this.adminEditIsSet = true;
        }

        @JsonProperty(value="loggedIn")
        public void setLoggedIn(boolean loggedIn) {
            this.loggedIn = loggedIn;
            this.loggedInIsSet = true;
        }

        @JsonProperty(value="ldap")
        public void setLdap(boolean ldap) {
            this.ldap = ldap;
            this.ldapIsSet = true;
        }

        @JsonProperty(value="redirectToLogin")
        public void setRedirectToLogin(boolean redirectToLogin) {
            this.redirectToLogin = redirectToLogin;
            this.redirectToLoginIsSet = true;
        }

        @JsonProperty(value="defaultTimeZoneId")
        public void setDefaultTimeZoneId(String defaultTimeZoneId) {
            this.defaultTimeZoneId = defaultTimeZoneId;
        }

        @JsonProperty(value="timeZoneIds")
        public void setTimeZoneIds(List<String> timeZoneIds) {
            this.timeZoneIds = timeZoneIds;
        }

        @JsonProperty(value="embeddedAgentRollup")
        public void setEmbeddedAgentRollup( @org.checkerframework.checker.nullness.qual.Nullable LayoutService.AgentRollupLayout embeddedAgentRollup) {
            this.embeddedAgentRollup = embeddedAgentRollup;
        }

        @Override
        boolean central() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean offlineViewer() {
            throw new UnsupportedOperationException();
        }

        @Override
        String glowrootVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean loginEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<ConfigRepository.RollupConfig> rollupConfigs() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<Long> rollupExpirationMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<Long> queryAndServiceCallRollupExpirationMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<Long> profileRollupExpirationMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        long gaugeCollectionIntervalMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean showNavbarTransaction() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean showNavbarError() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean showNavbarJvm() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean showNavbarSyntheticMonitor() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean showNavbarIncident() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean showNavbarReport() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean showNavbarConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean adminView() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean adminEdit() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean loggedIn() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean ldap() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean redirectToLogin() {
            throw new UnsupportedOperationException();
        }

        @Override
        String defaultTimeZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<String> timeZoneIds() {
            throw new UnsupportedOperationException();
        }

        @Override
         @org.checkerframework.checker.nullness.qual.Nullable LayoutService.AgentRollupLayout embeddedAgentRollup() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String version() {
            throw new UnsupportedOperationException();
        }
    }
}

