/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GaugeValueJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GaugeValueJsonService.GaugeValueRequest", generator="Immutables")
@Immutable
final class ImmutableGaugeValueRequest
implements GaugeValueJsonService.GaugeValueRequest {
    private final long from;
    private final long to;
    private final ImmutableList<String> gaugeName;

    private ImmutableGaugeValueRequest(long from, long to, ImmutableList<String> gaugeName) {
        this.from = from;
        this.to = to;
        this.gaugeName = gaugeName;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="gaugeName")
    public ImmutableList<String> gaugeName() {
        return this.gaugeName;
    }

    public final ImmutableGaugeValueRequest withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        return new ImmutableGaugeValueRequest(value, this.to, this.gaugeName);
    }

    public final ImmutableGaugeValueRequest withTo(long value) {
        if (this.to == value) {
            return this;
        }
        return new ImmutableGaugeValueRequest(this.from, value, this.gaugeName);
    }

    public final ImmutableGaugeValueRequest withGaugeName(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableGaugeValueRequest(this.from, this.to, (ImmutableList<String>)newValue);
    }

    public final ImmutableGaugeValueRequest withGaugeName(Iterable<String> elements) {
        if (this.gaugeName == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableGaugeValueRequest(this.from, this.to, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGaugeValueRequest && this.equalTo(0, (ImmutableGaugeValueRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableGaugeValueRequest another) {
        return this.from == another.from && this.to == another.to && this.gaugeName.equals(another.gaugeName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.from);
        h += (h << 5) + Longs.hashCode((long)this.to);
        h += (h << 5) + this.gaugeName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GaugeValueRequest").omitNullValues().add("from", this.from).add("to", this.to).add("gaugeName", this.gaugeName).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGaugeValueRequest fromJson(Json json) {
        Builder builder = ImmutableGaugeValueRequest.builder();
        if (json.fromIsSet) {
            builder.from(json.from);
        }
        if (json.toIsSet) {
            builder.to(json.to);
        }
        if (json.gaugeName != null) {
            builder.addAllGaugeName((Iterable<String>)json.gaugeName);
        }
        return builder.build();
    }

    public static ImmutableGaugeValueRequest copyOf(GaugeValueJsonService.GaugeValueRequest instance) {
        if (instance instanceof ImmutableGaugeValueRequest) {
            return (ImmutableGaugeValueRequest)instance;
        }
        return ImmutableGaugeValueRequest.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GaugeValueJsonService.GaugeValueRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FROM = 1L;
        private static final long INIT_BIT_TO = 2L;
        private long initBits = 3L;
        private long from;
        private long to;
        private ImmutableList.Builder<String> gaugeName = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(GaugeValueJsonService.GaugeValueRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from(instance.from());
            this.to(instance.to());
            this.addAllGaugeName((Iterable<String>)instance.gaugeName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(long from) {
            this.from = from;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder to(long to) {
            this.to = to;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGaugeName(String element) {
            this.gaugeName.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGaugeName(String ... elements) {
            this.gaugeName.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gaugeName(Iterable<String> elements) {
            this.gaugeName = ImmutableList.builder();
            return this.addAllGaugeName(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGaugeName(Iterable<String> elements) {
            this.gaugeName.addAll(elements);
            return this;
        }

        public ImmutableGaugeValueRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGaugeValueRequest(this.from, this.to, this.gaugeName.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("from");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("to");
            }
            return "Cannot build GaugeValueRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GaugeValueJsonService.GaugeValueRequest", generator="Immutables")
    static final class Json
    implements GaugeValueJsonService.GaugeValueRequest {
        long from;
        boolean fromIsSet;
        long to;
        boolean toIsSet;
        @Nullable
        ImmutableList<String> gaugeName = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="from")
        public void setFrom(long from) {
            this.from = from;
            this.fromIsSet = true;
        }

        @JsonProperty(value="to")
        public void setTo(long to) {
            this.to = to;
            this.toIsSet = true;
        }

        @JsonProperty(value="gaugeName")
        public void setGaugeName(ImmutableList<String> gaugeName) {
            this.gaugeName = gaugeName;
        }

        @Override
        public long from() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long to() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<String> gaugeName() {
            throw new UnsupportedOperationException();
        }
    }
}

