/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ErrorJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ErrorJsonService.ErrorPoint", generator="Immutables")
@Immutable
final class ImmutableErrorPoint
implements ErrorJsonService.ErrorPoint {
    private final long captureTime;
    private final long errorCount;
    private final long transactionCount;

    private ImmutableErrorPoint(long captureTime, long errorCount, long transactionCount) {
        this.captureTime = captureTime;
        this.errorCount = errorCount;
        this.transactionCount = transactionCount;
    }

    @Override
    @JsonProperty(value="captureTime")
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    @JsonProperty(value="errorCount")
    public long errorCount() {
        return this.errorCount;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    public final ImmutableErrorPoint withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        return new ImmutableErrorPoint(value, this.errorCount, this.transactionCount);
    }

    public final ImmutableErrorPoint withErrorCount(long value) {
        if (this.errorCount == value) {
            return this;
        }
        return new ImmutableErrorPoint(this.captureTime, value, this.transactionCount);
    }

    public final ImmutableErrorPoint withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        return new ImmutableErrorPoint(this.captureTime, this.errorCount, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorPoint && this.equalTo(0, (ImmutableErrorPoint)another);
    }

    private boolean equalTo(int synthetic, ImmutableErrorPoint another) {
        return this.captureTime == another.captureTime && this.errorCount == another.errorCount && this.transactionCount == another.transactionCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.captureTime);
        h += (h << 5) + Longs.hashCode((long)this.errorCount);
        h += (h << 5) + Longs.hashCode((long)this.transactionCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ErrorPoint").omitNullValues().add("captureTime", this.captureTime).add("errorCount", this.errorCount).add("transactionCount", this.transactionCount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableErrorPoint fromJson(Json json) {
        Builder builder = ImmutableErrorPoint.builder();
        if (json.captureTimeIsSet) {
            builder.captureTime(json.captureTime);
        }
        if (json.errorCountIsSet) {
            builder.errorCount(json.errorCount);
        }
        if (json.transactionCountIsSet) {
            builder.transactionCount(json.transactionCount);
        }
        return builder.build();
    }

    public static ImmutableErrorPoint of(long captureTime, long errorCount, long transactionCount) {
        return new ImmutableErrorPoint(captureTime, errorCount, transactionCount);
    }

    public static ImmutableErrorPoint copyOf(ErrorJsonService.ErrorPoint instance) {
        if (instance instanceof ImmutableErrorPoint) {
            return (ImmutableErrorPoint)instance;
        }
        return ImmutableErrorPoint.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ErrorJsonService.ErrorPoint", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CAPTURE_TIME = 1L;
        private static final long INIT_BIT_ERROR_COUNT = 2L;
        private static final long INIT_BIT_TRANSACTION_COUNT = 4L;
        private long initBits = 7L;
        private long captureTime;
        private long errorCount;
        private long transactionCount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ErrorJsonService.ErrorPoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.captureTime(instance.captureTime());
            this.errorCount(instance.errorCount());
            this.transactionCount(instance.transactionCount());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder captureTime(long captureTime) {
            this.captureTime = captureTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorCount(long errorCount) {
            this.errorCount = errorCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableErrorPoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableErrorPoint(this.captureTime, this.errorCount, this.transactionCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("captureTime");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("errorCount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("transactionCount");
            }
            return "Cannot build ErrorPoint, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ErrorJsonService.ErrorPoint", generator="Immutables")
    static final class Json
    implements ErrorJsonService.ErrorPoint {
        long captureTime;
        boolean captureTimeIsSet;
        long errorCount;
        boolean errorCountIsSet;
        long transactionCount;
        boolean transactionCountIsSet;

        Json() {
        }

        @JsonProperty(value="captureTime")
        public void setCaptureTime(long captureTime) {
            this.captureTime = captureTime;
            this.captureTimeIsSet = true;
        }

        @JsonProperty(value="errorCount")
        public void setErrorCount(long errorCount) {
            this.errorCount = errorCount;
            this.errorCountIsSet = true;
        }

        @JsonProperty(value="transactionCount")
        public void setTransactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.transactionCountIsSet = true;
        }

        @Override
        public long captureTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long errorCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long transactionCount() {
            throw new UnsupportedOperationException();
        }
    }
}

