/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ChartMarking;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ChartMarking.ChartMarkingInterval", generator="Immutables")
@Immutable
public final class ImmutableChartMarkingInterval
implements ChartMarking.ChartMarkingInterval {
    private final long from;
    private final long to;
    private final int count;
    private final String message;

    private ImmutableChartMarkingInterval(long from, long to, int count, String message) {
        this.from = from;
        this.to = to;
        this.count = count;
        this.message = message;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="count")
    public int count() {
        return this.count;
    }

    @Override
    @JsonProperty(value="message")
    public String message() {
        return this.message;
    }

    public final ImmutableChartMarkingInterval withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        return new ImmutableChartMarkingInterval(value, this.to, this.count, this.message);
    }

    public final ImmutableChartMarkingInterval withTo(long value) {
        if (this.to == value) {
            return this;
        }
        return new ImmutableChartMarkingInterval(this.from, value, this.count, this.message);
    }

    public final ImmutableChartMarkingInterval withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableChartMarkingInterval(this.from, this.to, value, this.message);
    }

    public final ImmutableChartMarkingInterval withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableChartMarkingInterval(this.from, this.to, this.count, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChartMarkingInterval && this.equalTo(0, (ImmutableChartMarkingInterval)another);
    }

    private boolean equalTo(int synthetic, ImmutableChartMarkingInterval another) {
        return this.from == another.from && this.to == another.to && this.count == another.count && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.from);
        h += (h << 5) + Longs.hashCode((long)this.to);
        h += (h << 5) + this.count;
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ChartMarkingInterval").omitNullValues().add("from", this.from).add("to", this.to).add("count", this.count).add("message", (Object)this.message).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableChartMarkingInterval fromJson(Json json) {
        Builder builder = ImmutableChartMarkingInterval.builder();
        if (json.fromIsSet) {
            builder.from(json.from);
        }
        if (json.toIsSet) {
            builder.to(json.to);
        }
        if (json.countIsSet) {
            builder.count(json.count);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        return builder.build();
    }

    public static ImmutableChartMarkingInterval copyOf(ChartMarking.ChartMarkingInterval instance) {
        if (instance instanceof ImmutableChartMarkingInterval) {
            return (ImmutableChartMarkingInterval)instance;
        }
        return ImmutableChartMarkingInterval.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChartMarking.ChartMarkingInterval", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FROM = 1L;
        private static final long INIT_BIT_TO = 2L;
        private static final long INIT_BIT_COUNT = 4L;
        private static final long INIT_BIT_MESSAGE = 8L;
        private long initBits = 15L;
        private long from;
        private long to;
        private int count;
        @Nullable
        private String message;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ChartMarking.ChartMarkingInterval instance) {
            Objects.requireNonNull(instance, "instance");
            this.from(instance.from());
            this.to(instance.to());
            this.count(instance.count());
            this.message(instance.message());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(long from) {
            this.from = from;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder to(long to) {
            this.to = to;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableChartMarkingInterval build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChartMarkingInterval(this.from, this.to, this.count, this.message);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("from");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("to");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("count");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build ChartMarkingInterval, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChartMarking.ChartMarkingInterval", generator="Immutables")
    static final class Json
    implements ChartMarking.ChartMarkingInterval {
        long from;
        boolean fromIsSet;
        long to;
        boolean toIsSet;
        int count;
        boolean countIsSet;
        @Nullable
        String message;

        Json() {
        }

        @JsonProperty(value="from")
        public void setFrom(long from) {
            this.from = from;
            this.fromIsSet = true;
        }

        @JsonProperty(value="to")
        public void setTo(long to) {
            this.to = to;
            this.toIsSet = true;
        }

        @JsonProperty(value="count")
        public void setCount(int count) {
            this.count = count;
            this.countIsSet = true;
        }

        @JsonProperty(value="message")
        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public long from() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long to() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int count() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String message() {
            throw new UnsupportedOperationException();
        }
    }
}

