/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableErrorMessageFilter;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableTraceQuery;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.RollupLevelService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentRollupId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAutoRefresh;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.DataSeries;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.DataSeriesHelper;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ErrorCommonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableErrorPoint;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TransactionCommonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableAggregateQuery;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableSummaryQuery;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.model.ImmutableOverallErrorSummary;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallErrorSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.Result;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameErrorSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.immutables.value.Value;

@JsonService
class ErrorJsonService {
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private final ErrorCommonService errorCommonService;
    private final TransactionCommonService transactionCommonService;
    private final TraceRepository traceRepository;
    private final ConfigRepository configRepository;
    private final RollupLevelService rollupLevelService;
    private final Clock clock;

    ErrorJsonService(ErrorCommonService errorCommonService, TransactionCommonService transactionCommonService, TraceRepository traceRepository, ConfigRepository configRepository, RollupLevelService rollupLevelService, Clock clock) {
        this.errorCommonService = errorCommonService;
        this.transactionCommonService = transactionCommonService;
        this.traceRepository = traceRepository;
        this.configRepository = configRepository;
        this.rollupLevelService = rollupLevelService;
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/error/messages", permission="agent:error:overview")
    String getData(@BindAgentRollupId String agentRollupId, @BindRequest ErrorMessageRequest request, @BindAutoRefresh boolean autoRefresh) throws Exception {
        ImmutableTraceQuery query = ImmutableTraceQuery.builder().transactionType(request.transactionType()).transactionName(request.transactionName()).from(request.from()).to(request.to()).build();
        ImmutableAggregateQuery aggregateQuery = ImmutableAggregateQuery.builder().transactionType(request.transactionType()).transactionName(request.transactionName()).from(request.from()).to(request.to()).rollupLevel(this.rollupLevelService.getRollupLevelForView(request.from(), request.to(), RollupLevelService.DataKind.GENERAL)).build();
        ImmutableErrorMessageFilter filter = ImmutableErrorMessageFilter.builder().addAllIncludes((Iterable<String>)request.include()).addAllExcludes((Iterable<String>)request.exclude()).build();
        long liveCaptureTime = this.clock.currentTimeMillis();
        ImmutableList throughputAggregates = this.transactionCommonService.getThroughputAggregates(agentRollupId, (LiveAggregateRepository.AggregateQuery)aggregateQuery, autoRefresh).toCompletableFuture().get();
        if (throughputAggregates.isEmpty() && this.fallBackToLargestAggregates((LiveAggregateRepository.AggregateQuery)aggregateQuery) && !(throughputAggregates = this.transactionCommonService.getThroughputAggregates(agentRollupId, (LiveAggregateRepository.AggregateQuery)(aggregateQuery = this.withLargestRollupLevel((LiveAggregateRepository.AggregateQuery)aggregateQuery)), autoRefresh).toCompletableFuture().get()).isEmpty() && this.ignoreFallBackData((LiveAggregateRepository.AggregateQuery)aggregateQuery, ((LiveAggregateRepository.ThroughputAggregate)Iterables.getLast(throughputAggregates)).captureTime())) {
            throughputAggregates = ImmutableList.of();
        }
        long dataPointIntervalMillis = this.configRepository.getRollupConfigs().get(aggregateQuery.rollupLevel()).intervalMillis();
        DataSeries dataSeries = new DataSeries(null);
        HashMap dataSeriesExtra = Maps.newHashMap();
        HashMap transactionCountMap = Maps.newHashMap();
        for (LiveAggregateRepository.ThroughputAggregate unfilteredErrorPoint : throughputAggregates) {
            transactionCountMap.put(unfilteredErrorPoint.captureTime(), unfilteredErrorPoint.transactionCount());
        }
        List records = Lists.newArrayList();
        boolean moreAvailable = false;
        if (!throughputAggregates.isEmpty()) {
            long maxCaptureTime = ((LiveAggregateRepository.ThroughputAggregate)Iterables.getLast((Iterable)throughputAggregates)).captureTime();
            TraceRepository.ErrorMessageResult result = this.traceRepository.readErrorMessages(agentRollupId, ImmutableTraceQuery.builder().copyFrom(query).to(maxCaptureTime).build(), filter, dataPointIntervalMillis, request.errorMessageLimit()).toCompletableFuture().get();
            ArrayList errorPoints = Lists.newArrayList();
            for (TraceRepository.ErrorMessagePoint traceErrorPoint : result.points()) {
                Long transactionCount;
                long captureTime = traceErrorPoint.captureTime();
                if (captureTime > maxCaptureTime) {
                    captureTime = maxCaptureTime;
                }
                if ((transactionCount = (Long)transactionCountMap.get(captureTime)) == null) continue;
                errorPoints.add(ImmutableErrorPoint.of(captureTime, traceErrorPoint.errorCount(), transactionCount));
            }
            ErrorJsonService.populateDataSeries(query, errorPoints, dataSeries, dataSeriesExtra, dataPointIntervalMillis, liveCaptureTime);
            records = result.counts().records();
            moreAvailable = result.counts().moreAvailable();
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeObjectField("dataSeries", (Object)dataSeries);
            jg.writeNumberField("dataPointIntervalMillis", dataPointIntervalMillis);
            jg.writeObjectField("dataSeriesExtra", (Object)dataSeriesExtra);
            jg.writeObjectField("errorMessages", (Object)records);
            jg.writeBooleanField("moreErrorMessagesAvailable", moreAvailable);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/error/summaries", permission="agent:error:overview")
    String getSummaries(@BindAgentRollupId String agentRollupId, @BindRequest ErrorSummaryRequest request, @BindAutoRefresh boolean autoRefresh) throws Exception {
        ImmutableSummaryQuery query = ImmutableSummaryQuery.builder().transactionType(request.transactionType()).from(request.from()).to(request.to()).rollupLevel(this.rollupLevelService.getRollupLevelForView(request.from(), request.to(), RollupLevelService.DataKind.GENERAL)).build();
        OverallErrorSummaryCollector overallErrorSummaryCollector = this.errorCommonService.readOverallErrorSummary(agentRollupId, (LiveAggregateRepository.SummaryQuery)query, autoRefresh);
        OverallErrorSummaryCollector.OverallErrorSummary overallSummary = overallErrorSummaryCollector.getOverallErrorSummary();
        if (overallSummary.transactionCount() == 0L && this.fallBackToLargestAggregates((LiveAggregateRepository.SummaryQuery)query)) {
            query = this.withLargestRollupLevel((LiveAggregateRepository.SummaryQuery)query);
            overallErrorSummaryCollector = this.errorCommonService.readOverallErrorSummary(agentRollupId, (LiveAggregateRepository.SummaryQuery)query, autoRefresh);
            overallSummary = overallErrorSummaryCollector.getOverallErrorSummary();
            if (this.ignoreFallBackData((LiveAggregateRepository.SummaryQuery)query, overallErrorSummaryCollector.getLastCaptureTime())) {
                overallSummary = ImmutableOverallErrorSummary.builder().errorCount(0L).transactionCount(0L).build();
            }
        }
        Result<TransactionNameErrorSummaryCollector.TransactionNameErrorSummary> queryResult = this.errorCommonService.readTransactionNameErrorSummaries(agentRollupId, (LiveAggregateRepository.SummaryQuery)query, request.sortOrder(), request.limit(), autoRefresh);
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeObjectField("overall", (Object)overallSummary);
            jg.writeObjectField("transactions", (Object)queryResult.records());
            jg.writeBooleanField("moreAvailable", queryResult.moreAvailable());
            jg.writeEndObject();
        }
        return sb.toString();
    }

    private boolean fallBackToLargestAggregates(LiveAggregateRepository.AggregateQuery query) {
        return query.rollupLevel() < this.getLargestRollupLevel() && query.from() > this.clock.currentTimeMillis() - this.getLargestRollupIntervalMillis() * 2L;
    }

    private boolean fallBackToLargestAggregates(LiveAggregateRepository.SummaryQuery query) {
        return query.rollupLevel() < this.getLargestRollupLevel() && query.from() > this.clock.currentTimeMillis() - this.getLargestRollupIntervalMillis() * 2L;
    }

    private LiveAggregateRepository.AggregateQuery withLargestRollupLevel(LiveAggregateRepository.AggregateQuery query) {
        return ImmutableAggregateQuery.builder().copyFrom(query).rollupLevel(this.getLargestRollupLevel()).build();
    }

    private LiveAggregateRepository.SummaryQuery withLargestRollupLevel(LiveAggregateRepository.SummaryQuery query) {
        return ImmutableSummaryQuery.builder().copyFrom(query).rollupLevel(this.getLargestRollupLevel()).build();
    }

    private boolean ignoreFallBackData(LiveAggregateRepository.AggregateQuery query, long lastCaptureTime) {
        return lastCaptureTime < query.from() + this.getLargestRollupIntervalMillis();
    }

    private boolean ignoreFallBackData(LiveAggregateRepository.SummaryQuery query, long lastCaptureTime) {
        return lastCaptureTime < query.from() + this.getLargestRollupIntervalMillis();
    }

    private int getLargestRollupLevel() {
        return this.configRepository.getRollupConfigs().size() - 1;
    }

    private long getLargestRollupIntervalMillis() {
        List<ConfigRepository.RollupConfig> rollupConfigs = this.configRepository.getRollupConfigs();
        return rollupConfigs.get(rollupConfigs.size() - 1).intervalMillis();
    }

    private static void populateDataSeries(TraceRepository.TraceQuery query, List<ErrorPoint> errorPoints, DataSeries dataSeries, Map<Long, Long[]> dataSeriesExtra, long dataPointIntervalMillis, long liveCaptureTime) {
        DataSeriesHelper dataSeriesHelper = new DataSeriesHelper(liveCaptureTime, dataPointIntervalMillis);
        ErrorPoint lastErrorPoint = null;
        for (ErrorPoint errorPoint : errorPoints) {
            if (lastErrorPoint == null) {
                dataSeriesHelper.addInitialUpslopeIfNeeded(query.from(), errorPoint.captureTime(), dataSeries);
            } else {
                dataSeriesHelper.addGapIfNeeded(lastErrorPoint.captureTime(), errorPoint.captureTime(), dataSeries);
            }
            lastErrorPoint = errorPoint;
            long transactionCount = errorPoint.transactionCount();
            dataSeries.add(errorPoint.captureTime(), (double)(100L * errorPoint.errorCount()) / (double)transactionCount);
            dataSeriesExtra.put(errorPoint.captureTime(), new Long[]{errorPoint.errorCount(), transactionCount});
        }
        if (lastErrorPoint != null) {
            dataSeriesHelper.addFinalDownslopeIfNeeded(dataSeries, lastErrorPoint.captureTime());
        }
    }

    static {
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    }

    @Value.Immutable
    static interface ErrorMessageRequest {
        public String transactionType();

        public @Nullable String transactionName();

        public long from();

        public long to();

        public ImmutableList<String> include();

        public ImmutableList<String> exclude();

        public int errorMessageLimit();
    }

    @Value.Immutable
    static interface ErrorSummaryRequest {
        public String transactionType();

        public long from();

        public long to();

        public TransactionNameErrorSummaryCollector.ErrorSummarySortOrder sortOrder();

        public int limit();
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface ErrorPoint {
        public long captureTime();

        public long errorCount();

        public long transactionCount();
    }
}

