/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.MutableThreadStats;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.MutableTimer;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableMergedAggregate;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.immutables.value.Value;

class AggregateMerging {
    private AggregateMerging() {
    }

    static MergedAggregate getMergedAggregate(List<LiveAggregateRepository.OverviewAggregate> overviewAggregates) {
        long transactionCount = 0L;
        ArrayList mainThreadRootTimers = Lists.newArrayList();
        MutableThreadStats mainThreadStats = new MutableThreadStats();
        MutableTimer auxThreadRootTimer = MutableTimer.createAuxThreadRootTimer();
        MutableThreadStats auxThreadStats = new MutableThreadStats();
        ArrayList asyncTimers = Lists.newArrayList();
        for (LiveAggregateRepository.OverviewAggregate aggregate : overviewAggregates) {
            transactionCount += aggregate.transactionCount();
            AggregateMerging.mergeRootTimers(aggregate.mainThreadRootTimers(), mainThreadRootTimers);
            mainThreadStats.addThreadStats(aggregate.mainThreadStats());
            AggregateOuterClass.Aggregate.Timer toBeMergedAuxThreadRootTimer = aggregate.auxThreadRootTimer();
            if (toBeMergedAuxThreadRootTimer != null) {
                auxThreadRootTimer.merge(toBeMergedAuxThreadRootTimer);
                auxThreadStats.addThreadStats((AggregateOuterClass.Aggregate.ThreadStats)Preconditions.checkNotNull((Object)aggregate.auxThreadStats()));
            }
            AggregateMerging.mergeRootTimers(aggregate.asyncTimers(), asyncTimers);
        }
        ImmutableMergedAggregate.Builder builder = ImmutableMergedAggregate.builder().transactionCount(transactionCount).mainThreadRootTimers(mainThreadRootTimers).mainThreadStats(mainThreadStats);
        if (auxThreadRootTimer.getCount() != 0L) {
            builder.auxThreadRootTimer(auxThreadRootTimer).auxThreadStats(auxThreadStats);
        }
        return builder.asyncTimers(asyncTimers).build();
    }

    private static void mergeRootTimers(List<AggregateOuterClass.Aggregate.Timer> toBeMergedRootTimers, List<MutableTimer> rootTimers) {
        for (AggregateOuterClass.Aggregate.Timer toBeMergedRootTimer : toBeMergedRootTimers) {
            AggregateMerging.mergeRootTimer(toBeMergedRootTimer, rootTimers);
        }
    }

    private static void mergeRootTimer(AggregateOuterClass.Aggregate.Timer toBeMergedRootTimer, List<MutableTimer> rootTimers) {
        for (MutableTimer rootTimer : rootTimers) {
            if (!toBeMergedRootTimer.getName().equals(rootTimer.getName())) continue;
            rootTimer.merge(toBeMergedRootTimer);
            return;
        }
        MutableTimer rootTimer = MutableTimer.createRootTimer(toBeMergedRootTimer.getName(), toBeMergedRootTimer.getExtended());
        rootTimer.merge(toBeMergedRootTimer);
        rootTimers.add(rootTimer);
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface PercentileValue {
        public String dataSeriesName();

        public long value();
    }

    @Value.Immutable
    static interface MergedAggregate {
        public long transactionCount();

        public List<MutableTimer> mainThreadRootTimers();

        public MutableThreadStats mainThreadStats();

        public @Nullable MutableTimer auxThreadRootTimer();

        public @Nullable MutableThreadStats auxThreadStats();

        public List<MutableTimer> asyncTimers();
    }
}

