/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.javax.mail.Address;
import org.glowroot.agent.embedded.shaded.javax.mail.Authenticator;
import org.glowroot.agent.embedded.shaded.javax.mail.Message;
import org.glowroot.agent.embedded.shaded.javax.mail.PasswordAuthentication;
import org.glowroot.agent.embedded.shaded.javax.mail.Session;
import org.glowroot.agent.embedded.shaded.javax.mail.internet.InternetAddress;
import org.glowroot.agent.embedded.shaded.javax.mail.internet.MimeMessage;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.SlackConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.SmtpConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AggregateRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.GaugeValueRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.IncidentRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.Utils;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Encryption;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Formatting;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Gauges;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.HttpClient;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.ImmutableIncidentKey;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.LazySecretKey;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.LockSet;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.MailService;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.MetricService;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.RollupLevelService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.util.concurrent.RateLimiter;
import org.glowroot.agent.shaded.com.google.protobuf.AbstractMessage;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

public class AlertingService {
    private static final Logger logger = LoggerFactory.getLogger(AlertingService.class);
    private final ConfigRepository configRepository;
    private final IncidentRepository incidentRepository;
    private final MailService mailService;
    private final HttpClient httpClient;
    private final LockSet<IncidentKey> openingIncidentLockSet;
    private final LockSet<IncidentKey> resolvingIncidentLockSet;
    private final Clock clock;
    private final MetricService metricService;
    private final RateLimiter smtpHostWarningRateLimiter = RateLimiter.create((double)2.777777777777778E-4);
    private final ScheduledExecutorService pagerDutyRetryExecutor;
    private volatile boolean closed;

    public AlertingService(ConfigRepository configRepository, IncidentRepository incidentRepository, AggregateRepository aggregateRepository, GaugeValueRepository gaugeValueRepository, TraceRepository traceRepository, RollupLevelService rollupLevelService, MailService mailService, HttpClient httpClient, LockSet<IncidentKey> openingIncidentLockSet, LockSet<IncidentKey> resolvingIncidentLockSet, Clock clock) {
        this.configRepository = configRepository;
        this.incidentRepository = incidentRepository;
        this.mailService = mailService;
        this.httpClient = httpClient;
        this.openingIncidentLockSet = openingIncidentLockSet;
        this.resolvingIncidentLockSet = resolvingIncidentLockSet;
        this.clock = clock;
        this.metricService = new MetricService(aggregateRepository, gaugeValueRepository, traceRepository, rollupLevelService);
        this.pagerDutyRetryExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    public void close() throws InterruptedException {
        this.closed = true;
        this.pagerDutyRetryExecutor.shutdownNow();
        if (!this.pagerDutyRetryExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Timed out waiting for pager duty retry thread to terminate");
        }
    }

    public CompletionStage<?> checkForDeletedAlerts(String agentRollupId, CassandraProfile profile) {
        return this.incidentRepository.readOpenIncidents(agentRollupId, profile).thenCompose(openIncidents -> {
            ArrayList futures = new ArrayList();
            for (IncidentRepository.OpenIncident openIncident : openIncidents) {
                futures.add(this.isDeletedAlert(openIncident).thenCompose(isDeletedAlert -> {
                    if (isDeletedAlert.booleanValue()) {
                        return this.incidentRepository.resolveIncident(openIncident, this.clock.currentTimeMillis(), profile);
                    }
                    return CompletableFuture.completedFuture(null);
                }));
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        });
    }

    public CompletionStage<?> checkForAllDeletedAlerts(CassandraProfile profile) {
        return this.incidentRepository.readAllOpenIncidents(profile).thenCompose(openIncidents -> {
            ArrayList futures = new ArrayList(openIncidents.size());
            for (IncidentRepository.OpenIncident openIncident : openIncidents) {
                futures.add(this.isDeletedAlert(openIncident).thenCompose(isDeletedAlert -> {
                    if (isDeletedAlert.booleanValue()) {
                        return this.incidentRepository.resolveIncident(openIncident, this.clock.currentTimeMillis(), profile);
                    }
                    return CompletableFuture.completedFuture(null);
                }));
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        });
    }

    public CompletionStage<?> checkMetricAlert(String centralDisplay, String agentRollupId, String agentRollupDisplay, AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition metricCondition, long endTime, CassandraProfile profile) {
        long startTime = endTime - TimeUnit.SECONDS.toMillis(metricCondition.getTimePeriodSeconds());
        return this.metricService.getMetricValue(agentRollupId, metricCondition, startTime, endTime, profile).thenCompose(value -> {
            if (value == null) {
                return CompletableFuture.completedFuture(null);
            }
            boolean currentlyTriggered = metricCondition.getLowerBoundThreshold() ? value.doubleValue() <= metricCondition.getThreshold() : value.doubleValue() >= metricCondition.getThreshold();
            AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition alertCondition = alertConfig.getCondition();
            return this.incidentRepository.readOpenIncident(agentRollupId, alertCondition, alertConfig.getSeverity(), profile).thenCompose(openIncident -> {
                if (openIncident != null && !currentlyTriggered) {
                    return this.resolveIncident(centralDisplay, agentRollupId, agentRollupDisplay, alertConfig, metricCondition, endTime, alertCondition, (IncidentRepository.OpenIncident)openIncident, profile);
                }
                if (openIncident == null && currentlyTriggered) {
                    long minTransactionCount;
                    if (AlertingService.hasMinTransactionCount(metricCondition.getMetric()) && (minTransactionCount = metricCondition.getMinTransactionCount()) != 0L) {
                        return this.metricService.getTransactionCount(agentRollupId, metricCondition.getTransactionType(), Strings.emptyToNull((String)metricCondition.getTransactionName()), startTime, endTime, profile).thenCompose(transactionCount -> {
                            if (transactionCount < minTransactionCount) {
                                return CompletableFuture.completedFuture(null);
                            }
                            return this.openIncident(centralDisplay, agentRollupId, agentRollupDisplay, alertConfig, metricCondition, endTime, alertCondition, profile);
                        });
                    }
                    return this.openIncident(centralDisplay, agentRollupId, agentRollupDisplay, alertConfig, metricCondition, endTime, alertCondition, profile);
                }
                return CompletableFuture.completedFuture(null);
            });
        });
    }

    private CompletionStage<?> openIncident(String centralDisplay, String agentRollupId, String agentRollupDisplay, AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition metricCondition, long endTime, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition alertCondition, CassandraProfile profile) {
        ImmutableIncidentKey incidentKey = ImmutableIncidentKey.builder().agentRollupId(agentRollupId).condition(alertCondition).severity(alertConfig.getSeverity()).build();
        UUID lockToken = this.openingIncidentLockSet.lock(incidentKey);
        if (lockToken == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.incidentRepository.insertOpenIncident(agentRollupId, alertCondition, alertConfig.getSeverity(), alertConfig.getNotification(), endTime, profile).thenAccept(v -> this.sendMetricAlert(centralDisplay, agentRollupId, agentRollupDisplay, alertConfig, metricCondition, endTime, false)).whenComplete((v, t) -> this.openingIncidentLockSet.unlock(incidentKey, lockToken));
    }

    private CompletionStage<?> resolveIncident(String centralDisplay, String agentRollupId, String agentRollupDisplay, AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition metricCondition, long endTime, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition alertCondition, IncidentRepository.OpenIncident openIncident, CassandraProfile profile) {
        ImmutableIncidentKey incidentKey = ImmutableIncidentKey.builder().agentRollupId(agentRollupId).condition(alertCondition).severity(alertConfig.getSeverity()).build();
        UUID lockToken = this.resolvingIncidentLockSet.lock(incidentKey);
        if (lockToken == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.incidentRepository.resolveIncident(openIncident, endTime, profile).thenAccept(v -> this.sendMetricAlert(centralDisplay, agentRollupId, agentRollupDisplay, alertConfig, metricCondition, endTime, true)).whenComplete((v, t) -> this.resolvingIncidentLockSet.unlock(incidentKey, lockToken));
    }

    private CompletionStage<Boolean> isDeletedAlert(IncidentRepository.OpenIncident openIncident) {
        return this.getAlertConfigsLeniently(openIncident.agentRollupId()).thenApply(alertConfigs -> {
            for (AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig : alertConfigs) {
                if (!alertConfig.getCondition().equals((Object)openIncident.condition()) || alertConfig.getSeverity() != openIncident.severity()) continue;
                return false;
            }
            return true;
        });
    }

    private CompletionStage<List<AgentConfigOuterClass.AgentConfig.AlertConfig>> getAlertConfigsLeniently(String agentRollupId) {
        return this.configRepository.getAlertConfigs(agentRollupId).handle((configs, t) -> {
            if (t != null) {
                if (t instanceof ConfigRepository.AgentConfigNotFoundException) {
                    logger.debug(t.getMessage(), t);
                    return ImmutableList.of();
                }
                throw new RuntimeException((Throwable)t);
            }
            return configs;
        });
    }

    private void sendMetricAlert(String centralDisplay, String agentRollupId, String agentRollupDisplay, AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition metricCondition, long endTime, boolean ok) {
        String transactionName;
        StringBuilder subject = new StringBuilder();
        String metric = metricCondition.getMetric();
        String transactionType = metricCondition.getTransactionType();
        boolean needsSubjectSeparator = false;
        if (!transactionType.isEmpty()) {
            subject.append(transactionType);
            needsSubjectSeparator = true;
        }
        if (!(transactionName = metricCondition.getTransactionName()).isEmpty()) {
            if (needsSubjectSeparator) {
                subject.append(" - ");
            }
            subject.append(transactionName);
        }
        GaugeValueRepository.Gauge gauge = null;
        StringBuilder message = new StringBuilder();
        if (metric.equals("transaction:x-percentile")) {
            Preconditions.checkState((boolean)metricCondition.hasPercentile());
            message.append(Utils.getPercentileWithSuffix(metricCondition.getPercentile().getValue()));
            message.append(" percentile");
        } else if (metric.equals("transaction:average")) {
            message.append("Average");
        } else if (metric.equals("transaction:count")) {
            message.append("Transaction count");
        } else if (metric.equals("error:rate")) {
            message.append("Error rate");
        } else if (metric.equals("error:count")) {
            String errorMessageFilter = metricCondition.getErrorMessageFilter();
            if (errorMessageFilter.isEmpty()) {
                message.append("Error count");
            } else if (errorMessageFilter.startsWith("/") && errorMessageFilter.endsWith("/")) {
                message.append("error count matching ");
                message.append(errorMessageFilter);
            } else {
                message.append("error count containing \"");
                message.append(errorMessageFilter);
                message.append("\"");
            }
        } else if (metric.startsWith("gauge:")) {
            String gaugeName = metric.substring("gauge:".length());
            gauge = Gauges.getGauge(gaugeName);
            subject.append(gauge.display());
            message.append("Average");
        } else {
            throw new IllegalStateException("Unexpected metric: " + metric);
        }
        message.append(AlertingService.getOverTheLastMinutesText(metricCondition.getTimePeriodSeconds()));
        if (metricCondition.getLowerBoundThreshold()) {
            message.append(AlertingService.getPreLowerBoundText(ok));
        } else {
            message.append(AlertingService.getPreUpperBoundText(ok));
        }
        if (metric.equals("transaction:x-percentile") || metric.equals("transaction:average")) {
            message.append(AlertingService.getWithUnit(metricCondition.getThreshold(), "millisecond"));
        } else if (metric.equals("transaction:count")) {
            message.append(metricCondition.getThreshold());
        } else if (metric.equals("error:rate")) {
            message.append(metricCondition.getThreshold());
            message.append("percent");
        } else if (metric.equals("error:count")) {
            message.append(metricCondition.getThreshold());
        } else if (metric.startsWith("gauge:")) {
            message.append(AlertingService.getGaugeThresholdText(metricCondition.getThreshold(), ((GaugeValueRepository.Gauge)Preconditions.checkNotNull((Object)gauge)).unit()));
        } else {
            throw new IllegalStateException("Unexpected metric: " + metric);
        }
        message.append(".\n\n");
        this.sendNotification(centralDisplay, agentRollupId, agentRollupDisplay, alertConfig, endTime, subject.toString(), message.toString(), ok);
    }

    public void sendNotification(String centralDisplay, String agentRollupId, String agentRollupDisplay, AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig, long endTime, String subject, String messageText, boolean ok) {
        AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.SlackNotification slackNotification;
        AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.PagerDutyNotification pagerDutyNotification;
        AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification alertNotification = alertConfig.getNotification();
        AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.EmailNotification emailNotification = alertNotification.getEmailNotification();
        if (emailNotification.getEmailAddressCount() > 0) {
            SmtpConfig smtpConfig = this.configRepository.getSmtpConfig().toCompletableFuture().join();
            if (smtpConfig.host().isEmpty()) {
                if (this.smtpHostWarningRateLimiter.tryAcquire()) {
                    logger.warn("not sending alert due to missing SMTP host configuration (this warning will be logged at most once an hour)");
                }
            } else {
                AlertingService.sendEmail(centralDisplay, agentRollupDisplay, subject, (List<String>)emailNotification.getEmailAddressList(), messageText, smtpConfig, null, this.configRepository.getLazySecretKey(), this.mailService, ok);
            }
        }
        if (!(pagerDutyNotification = alertNotification.getPagerDutyNotification()).getPagerDutyIntegrationKey().isEmpty()) {
            this.sendPagerDutyWithRetry(agentRollupId, agentRollupDisplay, alertConfig, pagerDutyNotification, endTime, subject, messageText, ok);
        }
        if (!(slackNotification = alertNotification.getSlackNotification()).getSlackWebhookId().isEmpty()) {
            String slackWebhookUrl = null;
            for (SlackConfig.SlackWebhook slackWebhook : this.configRepository.getSlackConfig().toCompletableFuture().join().webhooks()) {
                if (!slackWebhook.id().equals(slackNotification.getSlackWebhookId())) continue;
                slackWebhookUrl = slackWebhook.url();
                break;
            }
            if (slackWebhookUrl == null) {
                logger.warn("{} - alert config refers to non-existent webhook id: {}", (Object)agentRollupId, (Object)slackNotification.getSlackWebhookId());
            } else {
                for (String string : slackNotification.getSlackChannelList()) {
                    this.sendSlackWithRetry(centralDisplay, agentRollupDisplay, slackWebhookUrl, string, endTime, subject, messageText, ok);
                }
            }
        }
    }

    private void sendPagerDutyWithRetry(String agentRollupId, String agentRollupDisplay, AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.PagerDutyNotification pagerDutyNotification, long endTime, String subject, String messageText, boolean ok) {
        SendPagerDuty sendPagerDuty = new SendPagerDuty(agentRollupId, agentRollupDisplay, alertConfig, pagerDutyNotification, endTime, subject, messageText, ok);
        sendPagerDuty.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSlackWithRetry(String centralDisplay, String agentRollupDisplay, String slackWebhookUrl, String slackChannel, long endTime, String subject, String messageText, boolean ok) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (JsonGenerator jg = ObjectMappers.create((Module[])new Module[0]).getFactory().createGenerator((OutputStream)baos);){
                jg.writeStartObject();
                jg.writeArrayFieldStart("attachments");
                jg.writeStartObject();
                if (!agentRollupDisplay.isEmpty()) {
                    subject = "[" + agentRollupDisplay + "] " + subject;
                }
                if (!centralDisplay.isEmpty()) {
                    subject = "[" + centralDisplay + "] " + subject;
                }
                jg.writeStringField("fallback", subject + " - " + messageText);
                jg.writeStringField("pretext", subject);
                jg.writeStringField("color", ok ? "good" : "danger");
                jg.writeStringField("text", messageText);
                jg.writeNumberField("ts", (double)endTime / 1000.0);
                jg.writeEndObject();
                jg.writeEndArray();
                jg.writeStringField("channel", slackChannel);
                jg.writeEndObject();
            }
            this.httpClient.post(slackWebhookUrl, baos.toByteArray(), "application/json");
        }
        catch (Throwable t) {
            logger.error("{} - {}", new Object[]{agentRollupDisplay, t.getMessage(), t});
        }
    }

    public static void sendEmail(String centralDisplay, String agentRollupDisplay, String subject, List<String> emailAddresses, String messageText, SmtpConfig smtpConfig, @Nullable String passwordOverride, LazySecretKey lazySecretKey, MailService mailService, boolean ok) {
        try {
            String fromDisplayName;
            Session session = AlertingService.createMailSession(smtpConfig, passwordOverride, lazySecretKey);
            MimeMessage message = new MimeMessage(session);
            String fromEmailAddress = smtpConfig.fromEmailAddress();
            if (fromEmailAddress.isEmpty()) {
                String localServerName = InetAddress.getLocalHost().getHostName();
                fromEmailAddress = "glowroot@" + localServerName;
            }
            if ((fromDisplayName = smtpConfig.fromDisplayName()).isEmpty()) {
                fromDisplayName = "Glowroot";
            }
            ((Message)message).setFrom(new InternetAddress(fromEmailAddress, fromDisplayName));
            Address[] emailAddrs = new Address[emailAddresses.size()];
            for (int i = 0; i < emailAddresses.size(); ++i) {
                emailAddrs[i] = new InternetAddress(emailAddresses.get(i));
            }
            ((Message)message).setRecipients(Message.RecipientType.TO, emailAddrs);
            String subj = subject;
            if (!agentRollupDisplay.isEmpty()) {
                subj = "[" + agentRollupDisplay + "] " + subj;
            }
            if (!centralDisplay.isEmpty()) {
                subj = "[" + centralDisplay + "] " + subj;
            }
            if (agentRollupDisplay.isEmpty() && centralDisplay.isEmpty()) {
                subj = "[Glowroot] " + subj;
            }
            subj = ok ? subj + " - resolved" : subj + " - triggered";
            ((Message)message).setSubject(subj);
            message.setText(messageText);
            mailService.send(message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPreUpperBoundText(boolean ok) {
        if (ok) {
            return " is no longer greater than or equal to the alert threshold of ";
        }
        return " is greater than or equal to the alert threshold of ";
    }

    public static String getGaugeThresholdText(double threshold, String gaugeUnit) {
        if (gaugeUnit.equals("bytes")) {
            return Formatting.formatBytes((long)threshold);
        }
        if (!gaugeUnit.isEmpty()) {
            return Formatting.displaySixDigitsOfPrecision(threshold) + " " + gaugeUnit;
        }
        return Formatting.displaySixDigitsOfPrecision(threshold);
    }

    public static String getOverTheLastMinutesText(int timePeriodSeconds) {
        return " over the last " + AlertingService.getWithUnit((double)timePeriodSeconds / 60.0, "minute");
    }

    public static String getWithUnit(double val, String unit) {
        String text = Formatting.displaySixDigitsOfPrecision(val) + " " + unit;
        if (val != 1.0) {
            text = text + "s";
        }
        return text;
    }

    public static boolean hasTransactionTypeAndName(String metric) {
        return metric.startsWith("transaction:") || metric.startsWith("error:");
    }

    public static boolean hasMinTransactionCount(String metric) {
        return AlertingService.hasTransactionTypeAndName(metric) && !metric.equals("transaction:count") && !metric.equals("error:count");
    }

    public static boolean hasErrorMessageFilter(String metric) {
        return metric.equals("error:count");
    }

    private static String getPreLowerBoundText(boolean ok) {
        if (ok) {
            return " is no longer less than or equal to the alert threshold of ";
        }
        return " is less than or equal to the alert threshold of ";
    }

    private static Session createMailSession(SmtpConfig smtpConfig, @Nullable String passwordOverride, LazySecretKey lazySecretKey) throws Exception {
        Properties props = new Properties();
        props.put("mail.smtp.host", smtpConfig.host());
        SmtpConfig.ConnectionSecurity connectionSecurity = smtpConfig.connectionSecurity();
        Integer port = smtpConfig.port();
        if (port == null) {
            port = 25;
        }
        props.put("mail.smtp.port", port);
        if (connectionSecurity == SmtpConfig.ConnectionSecurity.SSL_TLS) {
            props.put("mail.smtp.socketFactory.port", port);
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        } else if (connectionSecurity == SmtpConfig.ConnectionSecurity.STARTTLS) {
            props.put("mail.smtp.starttls.enable", (Object)true);
        }
        for (Map.Entry<String, String> entry : smtpConfig.additionalProperties().entrySet()) {
            props.put(entry.getKey(), entry.getValue());
        }
        Authenticator authenticator = null;
        final String password = AlertingService.getPassword(smtpConfig, passwordOverride, lazySecretKey);
        if (!password.isEmpty()) {
            props.put("mail.smtp.auth", "true");
            final String username = smtpConfig.username();
            authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            };
        }
        return Session.getInstance(props, authenticator);
    }

    private static String getPassword(SmtpConfig smtpConfig, @Nullable String passwordOverride, LazySecretKey lazySecretKey) throws Exception {
        if (passwordOverride != null) {
            return passwordOverride;
        }
        String password = smtpConfig.encryptedPassword();
        if (password.isEmpty()) {
            return "";
        }
        return Encryption.decrypt(password, lazySecretKey);
    }

    private class SendPagerDuty
    implements Runnable {
        private final String agentRollupId;
        private final String agentRollupDisplay;
        private final AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig;
        private final AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.PagerDutyNotification pagerDutyNotification;
        private final long endTime;
        private final String subject;
        private final String messageText;
        private final boolean ok;
        private volatile int currentTryCount = 1;

        private SendPagerDuty(String agentRollupId, String agentRollupDisplay, AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.PagerDutyNotification pagerDutyNotification, long endTime, String subject, String messageText, boolean ok) {
            this.agentRollupId = agentRollupId;
            this.agentRollupDisplay = agentRollupDisplay;
            this.alertConfig = alertConfig;
            this.pagerDutyNotification = pagerDutyNotification;
            this.endTime = endTime;
            this.subject = subject;
            this.messageText = messageText;
            this.ok = ok;
        }

        @Override
        public void run() {
            try {
                this.sendPagerDuty(this.agentRollupId, this.agentRollupDisplay, this.alertConfig, this.pagerDutyNotification, this.endTime, this.subject, this.messageText, this.ok);
                if (this.currentTryCount > 1) {
                    logger.info("{} - PagerDuty no longer responded with 429 Too many requests (rate limit exceeded), successfully {} incident \"{} / {}\"", new Object[]{this.agentRollupDisplay, this.ok ? "resolved" : "triggered", this.subject, this.messageText});
                }
            }
            catch (HttpClient.TooManyRequestsHttpResponseException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                if (this.currentTryCount == 1) {
                    logger.warn("{} - PagerDuty responded with 429 Too many requests (rate limit exceeded), unable to {} incident \"{} / {}\" (will keep trying...)", new Object[]{this.agentRollupDisplay, this.ok ? "resolve" : "trigger", this.subject, this.messageText});
                }
                if (this.currentTryCount < 10) {
                    ++this.currentTryCount;
                    if (!AlertingService.this.closed) {
                        AlertingService.this.pagerDutyRetryExecutor.schedule(this, 1L, TimeUnit.MINUTES);
                    }
                } else {
                    String action = this.ok ? "resolve" : "trigger";
                    logger.warn("{} - PagerDuty responded with 429 Too many requests (rate limit exceeded), unable to {} incident \"{} / {}\" (will stop trying to {} this incident)", new Object[]{this.agentRollupDisplay, action, this.subject, this.messageText, action});
                }
            }
            catch (Throwable t) {
                logger.error("{} - {}", new Object[]{this.agentRollupDisplay, t.getMessage(), t});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendPagerDuty(String agentRollupId, String agentRollupDisplay, AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.PagerDutyNotification pagerDutyNotification, long endTime, String subject, String messageText, boolean ok) throws Exception {
            AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition alertCondition = alertConfig.getCondition();
            String dedupKey = this.getPagerDutyDedupKey(agentRollupId, alertCondition);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (JsonGenerator jg = ObjectMappers.create((Module[])new Module[0]).getFactory().createGenerator((OutputStream)baos);){
                jg.writeStartObject();
                jg.writeStringField("routing_key", pagerDutyNotification.getPagerDutyIntegrationKey());
                jg.writeStringField("dedup_key", dedupKey);
                if (ok) {
                    jg.writeStringField("event_action", "resolve");
                } else {
                    jg.writeStringField("event_action", "trigger");
                    jg.writeStringField("client", "Glowroot");
                    jg.writeObjectFieldStart("payload");
                    jg.writeStringField("summary", subject + "\n\n" + messageText);
                    if (agentRollupId.isEmpty()) {
                        jg.writeStringField("source", InetAddress.getLocalHost().getHostName());
                    } else {
                        jg.writeStringField("source", agentRollupDisplay);
                    }
                    jg.writeStringField("severity", this.getPagerDutySeverity(alertConfig.getSeverity()));
                    jg.writeStringField("timestamp", this.formatAsIso8601(endTime));
                    switch (alertCondition.getValCase()) {
                        case METRIC_CONDITION: {
                            jg.writeStringField("class", "metric: " + alertCondition.getMetricCondition().getMetric());
                            break;
                        }
                        case SYNTHETIC_MONITOR_CONDITION: {
                            jg.writeStringField("class", "synthetic monitor");
                            break;
                        }
                        case HEARTBEAT_CONDITION: {
                            jg.writeStringField("class", "heartbeat");
                            break;
                        }
                        default: {
                            logger.warn("unexpected alert condition: " + alertCondition.getValCase().name());
                            jg.writeStringField("class", "unknown: " + alertCondition.getValCase().name());
                        }
                    }
                    jg.writeEndObject();
                }
                jg.writeEndObject();
            }
            AlertingService.this.httpClient.post("https://events.pagerduty.com/v2/enqueue", baos.toByteArray(), "application/json");
        }

        private String getPagerDutyDedupKey(String agentRollupId, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition alertCondition) throws UnknownHostException {
            String dedupKey = agentRollupId.isEmpty() ? InetAddress.getLocalHost().getHostName() : agentRollupId;
            dedupKey = this.escapeDedupKeyPart(dedupKey) + ":" + Versions.getVersion((AbstractMessage)alertCondition);
            return dedupKey;
        }

        private String getPagerDutySeverity(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity) {
            switch (severity) {
                case CRITICAL: {
                    return "critical";
                }
                case HIGH: {
                    return "error";
                }
                case MEDIUM: {
                    return "warning";
                }
                case LOW: {
                    return "info";
                }
            }
            throw new IllegalStateException("Unknown alert severity: " + severity);
        }

        private String formatAsIso8601(long endTime) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return df.format(endTime);
        }

        private String escapeDedupKeyPart(String agentRollupId) {
            return agentRollupId.replace("\\", "\\\\").replace(":", "\\:");
        }
    }

    @Value.Immutable
    @Serial.Structural
    public static interface IncidentKey
    extends Serializable {
        public String agentRollupId();

        public AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition condition();

        public AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity();
    }
}

