/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.UsedByJsonSerialization;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;

public class MutableTimer {
    private final String name;
    private final boolean extended;
    private double totalNanos;
    private long count;
    private final List<MutableTimer> childTimers;

    public static MutableTimer createAuxThreadRootTimer() {
        return MutableTimer.createRootTimer("auxiliary thread", false);
    }

    public static MutableTimer createRootTimer(String name, boolean extended) {
        return new MutableTimer(name, extended, 0.0, 0L, new ArrayList<MutableTimer>());
    }

    private MutableTimer(String name, boolean extended, double totalNanos, long count, List<MutableTimer> nestedTimers) {
        this.name = name;
        this.extended = extended;
        this.totalNanos = totalNanos;
        this.count = count;
        this.childTimers = Lists.newArrayList(nestedTimers);
    }

    @UsedByJsonSerialization
    public String getName() {
        return this.name;
    }

    @UsedByJsonSerialization
    public boolean isExtended() {
        return this.extended;
    }

    @UsedByJsonSerialization
    public double getTotalNanos() {
        return this.totalNanos;
    }

    @UsedByJsonSerialization
    public long getCount() {
        return this.count;
    }

    @UsedByJsonSerialization
    public List<MutableTimer> getChildTimers() {
        return this.childTimers;
    }

    public void merge(AggregateOuterClass.Aggregate.Timer timer) {
        this.count += timer.getCount();
        this.totalNanos += timer.getTotalNanos();
        for (AggregateOuterClass.Aggregate.Timer toBeMergedChildTimer : timer.getChildTimerList()) {
            String toBeMergedChildTimerName = toBeMergedChildTimer.getName();
            boolean extended = toBeMergedChildTimer.getExtended();
            MutableTimer matchingChildTimer = null;
            for (MutableTimer childTimer : this.childTimers) {
                if (!toBeMergedChildTimerName.equals(childTimer.getName()) || extended != childTimer.extended) continue;
                matchingChildTimer = childTimer;
                break;
            }
            if (matchingChildTimer == null) {
                matchingChildTimer = new MutableTimer(toBeMergedChildTimer.getName(), toBeMergedChildTimer.getExtended(), 0.0, 0L, new ArrayList<MutableTimer>());
                this.childTimers.add(matchingChildTimer);
            }
            matchingChildTimer.merge(toBeMergedChildTimer);
        }
    }

    AggregateOuterClass.Aggregate.Timer toProto() {
        AggregateOuterClass.Aggregate.Timer.Builder builder = AggregateOuterClass.Aggregate.Timer.newBuilder().setName(this.name).setExtended(this.extended).setTotalNanos(this.totalNanos).setCount(this.count);
        for (MutableTimer childTimer : this.childTimers) {
            builder.addChildTimer(childTimer.toProto());
        }
        return builder.build();
    }
}

