/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.UsedByJsonSerialization;
import org.glowroot.agent.shaded.org.glowroot.common.util.NotAvailableAware;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;

public class MutableThreadStats {
    private double totalCpuNanos;
    private double totalBlockedNanos;
    private double totalWaitedNanos;
    private double totalAllocatedBytes;

    @UsedByJsonSerialization
    public double getTotalCpuNanos() {
        return this.totalCpuNanos;
    }

    @UsedByJsonSerialization
    public double getTotalBlockedNanos() {
        return this.totalBlockedNanos;
    }

    @UsedByJsonSerialization
    public double getTotalWaitedNanos() {
        return this.totalWaitedNanos;
    }

    @UsedByJsonSerialization
    public double getTotalAllocatedBytes() {
        return this.totalAllocatedBytes;
    }

    public void addTotalCpuNanos(double totalCpuNanos) {
        this.totalCpuNanos = NotAvailableAware.add((double)this.totalCpuNanos, (double)totalCpuNanos);
    }

    public void addTotalBlockedNanos(double totalBlockedNanos) {
        this.totalBlockedNanos = NotAvailableAware.add((double)this.totalBlockedNanos, (double)totalBlockedNanos);
    }

    public void addTotalWaitedNanos(double totalWaitedNanos) {
        this.totalWaitedNanos = NotAvailableAware.add((double)this.totalWaitedNanos, (double)totalWaitedNanos);
    }

    public void addTotalAllocatedBytes(double totalAllocatedBytes) {
        this.totalAllocatedBytes = NotAvailableAware.add((double)this.totalAllocatedBytes, (double)totalAllocatedBytes);
    }

    public void addThreadStats(AggregateOuterClass.Aggregate.ThreadStats threadStats) {
        this.totalCpuNanos = NotAvailableAware.add((double)this.totalCpuNanos, (double)threadStats.getTotalCpuNanos());
        this.totalBlockedNanos = NotAvailableAware.add((double)this.totalBlockedNanos, (double)threadStats.getTotalBlockedNanos());
        this.totalWaitedNanos = NotAvailableAware.add((double)this.totalWaitedNanos, (double)threadStats.getTotalWaitedNanos());
        this.totalAllocatedBytes = NotAvailableAware.add((double)this.totalAllocatedBytes, (double)threadStats.getTotalAllocatedBytes());
    }

    AggregateOuterClass.Aggregate.ThreadStats toProto() {
        return AggregateOuterClass.Aggregate.ThreadStats.newBuilder().setTotalCpuNanos(this.totalCpuNanos).setTotalBlockedNanos(this.totalBlockedNanos).setTotalWaitedNanos(this.totalWaitedNanos).setTotalAllocatedBytes(this.totalAllocatedBytes).build();
    }
}

