/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.util.HashSet;
import java.util.Set;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.protobuf.AbstractMessage;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;

public class ConfigValidation {
    private ConfigValidation() {
    }

    public static void validatePartOne(AgentConfigOuterClass.AgentConfig config) {
        HashSet gaugeMBeanObjectNames = Sets.newHashSet();
        for (Object gaugeConfig : config.getGaugeConfigList()) {
            if (gaugeMBeanObjectNames.add(gaugeConfig.getMbeanObjectName())) continue;
            throw new ConfigRepository.DuplicateMBeanObjectNameException();
        }
        HashSet syntheticMonitorDisplays = Sets.newHashSet();
        for (Object syntheticMonitorConfig : config.getSyntheticMonitorConfigList()) {
            if (syntheticMonitorDisplays.add(syntheticMonitorConfig.getDisplay())) continue;
            throw new ConfigRepository.DuplicateSyntheticMonitorDisplayException();
        }
        HashSet alertVersions = Sets.newHashSet();
        for (Object alertConfig : config.getAlertConfigList()) {
            if (alertVersions.add(Versions.getVersion((AbstractMessage)alertConfig))) continue;
            throw new IllegalStateException("Duplicate alerts");
        }
        HashSet pluginIds = Sets.newHashSet();
        for (AgentConfigOuterClass.AgentConfig.PluginConfig pluginConfig : config.getPluginConfigList()) {
            if (pluginIds.add(pluginConfig.getId())) continue;
            throw new IllegalStateException("Duplicate plugin id: " + pluginConfig.getId());
        }
        HashSet instrumentationVersions = Sets.newHashSet();
        for (AgentConfigOuterClass.AgentConfig.InstrumentationConfig instrumentationConfig : config.getInstrumentationConfigList()) {
            if (instrumentationVersions.add(Versions.getVersion((AbstractMessage)instrumentationConfig))) continue;
            throw new IllegalStateException("Duplicate instrumentation");
        }
    }

    public static void validatePartTwo(AgentConfigOuterClass.AgentConfig config, Set<String> validPluginIds) {
        for (AgentConfigOuterClass.AgentConfig.PluginConfig pluginConfig : config.getPluginConfigList()) {
            if (validPluginIds.contains(pluginConfig.getId())) continue;
            throw new IllegalStateException("Invalid plugin id: " + pluginConfig.getId());
        }
    }
}

