/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableSimplePermission;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.PermissionParser;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.immutables.value.Value;

@Value.Immutable
public abstract class RoleConfig {
    public abstract String name();

    public abstract ImmutableSet<String> permissions();

    @JsonIgnore
    @Value.Default
    public boolean central() {
        return false;
    }

    @JsonIgnore
    @Value.Derived
    public ImmutableSet<SimplePermission> simplePermissions() {
        HashSet simplePermissions = Sets.newHashSet();
        for (String permission : this.permissions()) {
            if (this.central()) {
                simplePermissions.add(SimplePermission.create(permission));
                continue;
            }
            simplePermissions.add(SimplePermission.create("", permission));
        }
        return ImmutableSet.copyOf((Collection)simplePermissions);
    }

    public boolean isPermitted(SimplePermission permission) {
        for (SimplePermission simplePermission : this.simplePermissions()) {
            if (!simplePermission.implies(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyPermissionImpliedBy(List<String> permissionParts) {
        for (SimplePermission simplePermission : this.simplePermissions()) {
            if (!SimplePermission.implies(permissionParts, simplePermission.parts())) continue;
            return true;
        }
        return false;
    }

    public boolean isPermittedForSomeAgentRollup(List<String> permissionParts) {
        for (SimplePermission simplePermission : this.simplePermissions()) {
            if (!SimplePermission.implies(simplePermission.parts(), permissionParts)) continue;
            return true;
        }
        return false;
    }

    public HasAnyPermission hasAnyPermissionForAgentRollup(String agentRollupId) {
        boolean onlyInChild = false;
        for (SimplePermission permission : this.simplePermissions()) {
            HasAnyPermission hasAnyPermission = permission.hasAnyPermissionForAgentRollup(agentRollupId);
            if (hasAnyPermission == HasAnyPermission.YES) {
                return HasAnyPermission.YES;
            }
            if (hasAnyPermission != HasAnyPermission.ONLY_IN_CHILD) continue;
            onlyInChild = true;
        }
        return onlyInChild ? HasAnyPermission.ONLY_IN_CHILD : HasAnyPermission.NO;
    }

    @JsonIgnore
    @Value.Derived
    public String version() {
        return Versions.getJsonVersion((Object)this);
    }

    @Value.Immutable
    public static abstract class SimplePermission {
        public static SimplePermission create(String permission) {
            PermissionParser parser = new PermissionParser(permission);
            parser.parse();
            return ImmutableSimplePermission.builder().addAllAgentRollupIds(parser.getAgentRollupIds()).addAllParts(Splitter.on((char)':').splitToList((CharSequence)parser.getPermission())).build();
        }

        public static SimplePermission create(String agentId, String permission) {
            return ImmutableSimplePermission.builder().addAgentRollupIds(agentId).addAllParts(Splitter.on((char)':').splitToList((CharSequence)permission)).build();
        }

        public abstract List<String> agentRollupIds();

        public abstract List<String> parts();

        @VisibleForTesting
        boolean implies(SimplePermission other) {
            if (!this.agentListImplies(other.agentRollupIds())) {
                return false;
            }
            List<String> otherParts = other.parts();
            return SimplePermission.implies(this.parts(), otherParts);
        }

        private boolean agentListImplies(List<String> otherAgentRollupIds) {
            for (String otherAgentRollupId : otherAgentRollupIds) {
                if (this.agentListImplies(otherAgentRollupId)) continue;
                return false;
            }
            return true;
        }

        private boolean agentListImplies(String otherAgentRollupId) {
            for (String agentRollupId : this.agentRollupIds()) {
                if (agentRollupId.equals("*") || this.agentRollupIds().contains(otherAgentRollupId)) {
                    return true;
                }
                if (!agentRollupId.endsWith("::") || !otherAgentRollupId.startsWith(agentRollupId)) continue;
                return true;
            }
            return false;
        }

        private HasAnyPermission hasAnyPermissionForAgentRollup(String otherAgentRollupId) {
            boolean onlyInChild = false;
            for (String agentRollupId : this.agentRollupIds()) {
                if (agentRollupId.equals("*") || this.agentRollupIds().contains(otherAgentRollupId)) {
                    return HasAnyPermission.YES;
                }
                if (!agentRollupId.endsWith("::") || !otherAgentRollupId.startsWith(agentRollupId)) continue;
                onlyInChild = true;
            }
            return onlyInChild ? HasAnyPermission.ONLY_IN_CHILD : HasAnyPermission.NO;
        }

        private static boolean implies(List<String> parts, List<String> otherParts) {
            if (otherParts.size() < parts.size()) {
                return false;
            }
            for (int i = 0; i < parts.size(); ++i) {
                String otherPart;
                String part = parts.get(i);
                if (SimplePermission.implies(part, otherPart = otherParts.get(i))) continue;
                return false;
            }
            return true;
        }

        private static boolean implies(String part, String otherPart) {
            return part.equals(otherPart) || part.equals("*");
        }
    }

    public static enum HasAnyPermission {
        YES,
        NO,
        ONLY_IN_CHILD;

    }
}

