/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.config;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;

public class PermissionParser {
    private String permission;
    private int index;
    private boolean inAgentRollupId;
    private boolean inQuotedAgentRollupId;
    private final StringBuilder currAgentRollupId = new StringBuilder();
    private final List<String> agentRollupIds = Lists.newArrayList();

    public PermissionParser(String permission) {
        this.permission = permission;
    }

    public void parse() {
        if (this.permission.equals("agent")) {
            return;
        }
        if (this.permission.equals("agent:")) {
            this.permission = "agent";
            return;
        }
        if (!this.permission.startsWith("agent:")) {
            return;
        }
        this.index = "agent:".length();
        while (this.index < this.permission.length()) {
            this.readNextChar();
            if (this.inAgentRollupId || this.permission.charAt(this.index - 1) != ':') continue;
        }
        if (this.inAgentRollupId) {
            this.agentRollupIds.add(this.currAgentRollupId.toString());
        }
        this.permission = this.permission.length() == this.index ? "agent" : "agent:" + this.permission.substring(this.index);
    }

    public List<String> getAgentRollupIds() {
        return this.agentRollupIds;
    }

    public String getPermission() {
        return this.permission;
    }

    private void readNextChar() {
        char c;
        if (this.isStartOfValue(c = this.permission.charAt(this.index++))) {
            this.startValue(c);
        } else if (this.isEndOfValue(c)) {
            this.endValue();
        } else if (this.inQuotedAgentRollupId && c == '\\') {
            this.currAgentRollupId.append(this.permission.charAt(this.index++));
        } else if (this.inAgentRollupId) {
            this.currAgentRollupId.append(c);
        }
    }

    private boolean isStartOfValue(char c) {
        return !this.inAgentRollupId && c != ',' && c != ':';
    }

    private void startValue(char c) {
        this.inAgentRollupId = true;
        if (c == '\"') {
            this.inQuotedAgentRollupId = true;
        } else {
            this.currAgentRollupId.append(c);
        }
    }

    private boolean isEndOfValue(char c) {
        return this.isEndOfQuotedValue(c) || this.isEndOfNonQuotedValue(c);
    }

    private void endValue() {
        this.agentRollupIds.add(this.currAgentRollupId.toString());
        this.inAgentRollupId = false;
        this.inQuotedAgentRollupId = false;
        this.currAgentRollupId.setLength(0);
    }

    private boolean isEndOfQuotedValue(char c) {
        return this.inQuotedAgentRollupId && c == '\"';
    }

    private boolean isEndOfNonQuotedValue(char c) {
        return this.inAgentRollupId && !this.inQuotedAgentRollupId && (c == ',' || c == ':');
    }

    public static String quoteIfNeededAndJoin(List<String> agentRollupIds) {
        ArrayList quotedIfNeededAgentRollupIds = Lists.newArrayList();
        for (String agentRollupId : agentRollupIds) {
            if (agentRollupId.indexOf(44) != -1 || agentRollupId.indexOf(58) != -1) {
                quotedIfNeededAgentRollupIds.add("\"" + agentRollupId.replace("\\", "\\\\").replace("\"", "\\\"") + "\"");
                continue;
            }
            quotedIfNeededAgentRollupIds.add(agentRollupId);
        }
        return Joiner.on((char)',').join((Iterable)quotedIfNeededAgentRollupIds);
    }

    public static boolean upgradeAgentPermissionsFrom_0_9_1_to_0_9_2(List<String> perms) {
        boolean hasAgentJvmAll = perms.contains("agent:tool");
        boolean upgrade = false;
        ListIterator<String> i = perms.listIterator();
        while (i.hasNext()) {
            String perm = i.next();
            if (perm.equals("agent:view")) {
                i.set("agent:transaction");
                i.add("agent:error");
                if (!hasAgentJvmAll) {
                    i.add("agent:jvm:gauges");
                    i.add("agent:jvm:environment");
                }
                upgrade = true;
                continue;
            }
            if (perm.equals("agent:tool")) {
                i.set("agent:jvm");
                upgrade = true;
                continue;
            }
            if (!perm.startsWith("agent:tool:")) continue;
            i.set("agent:jvm:" + perm.substring("agent:tool:".length()));
            upgrade = true;
        }
        if (!upgrade) {
            return false;
        }
        int configViewIndex = perms.indexOf("agent:config:view");
        int configEditIndex = perms.indexOf("agent:config:edit");
        if (configViewIndex != -1 && configEditIndex != -1) {
            perms.set(configViewIndex, "agent:config");
            perms.remove(configEditIndex);
        }
        return true;
    }
}

