/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.config;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.HttpProxyConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HttpProxyConfig", generator="Immutables")
@Immutable
public final class ImmutableHttpProxyConfig
extends HttpProxyConfig {
    private final String host;
    private final @org.checkerframework.checker.nullness.qual.Nullable Integer port;
    private final String username;
    private final String encryptedPassword;
    private final transient String version;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableHttpProxyConfig(Builder builder) {
        this.port = builder.port;
        if (builder.host != null) {
            this.initShim.host(builder.host);
        }
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.encryptedPassword != null) {
            this.initShim.encryptedPassword(builder.encryptedPassword);
        }
        this.host = this.initShim.host();
        this.username = this.initShim.username();
        this.encryptedPassword = this.initShim.encryptedPassword();
        this.version = this.initShim.version();
        this.initShim = null;
    }

    private ImmutableHttpProxyConfig(String host, @org.checkerframework.checker.nullness.qual.Nullable Integer port, String username, String encryptedPassword) {
        this.initShim.host(host);
        this.port = port;
        this.initShim.username(username);
        this.initShim.encryptedPassword(encryptedPassword);
        this.host = this.initShim.host();
        this.username = this.initShim.username();
        this.encryptedPassword = this.initShim.encryptedPassword();
        this.version = this.initShim.version();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String host() {
        InitShim shim = this.initShim;
        return shim != null ? shim.host() : this.host;
    }

    @Override
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public @org.checkerframework.checker.nullness.qual.Nullable Integer port() {
        return this.port;
    }

    @Override
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    @Override
    @JsonProperty(value="encryptedPassword")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String encryptedPassword() {
        InitShim shim = this.initShim;
        return shim != null ? shim.encryptedPassword() : this.encryptedPassword;
    }

    @Override
    @JsonProperty(value="version")
    @JsonIgnore
    public String version() {
        InitShim shim = this.initShim;
        return shim != null ? shim.version() : this.version;
    }

    public final ImmutableHttpProxyConfig withHost(String value) {
        String newValue = Objects.requireNonNull(value, "host");
        if (this.host.equals(newValue)) {
            return this;
        }
        return new ImmutableHttpProxyConfig(newValue, this.port, this.username, this.encryptedPassword);
    }

    public final ImmutableHttpProxyConfig withPort(@org.checkerframework.checker.nullness.qual.Nullable Integer value) {
        if (Objects.equals(this.port, value)) {
            return this;
        }
        return new ImmutableHttpProxyConfig(this.host, value, this.username, this.encryptedPassword);
    }

    public final ImmutableHttpProxyConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableHttpProxyConfig(this.host, this.port, newValue, this.encryptedPassword);
    }

    public final ImmutableHttpProxyConfig withEncryptedPassword(String value) {
        String newValue = Objects.requireNonNull(value, "encryptedPassword");
        if (this.encryptedPassword.equals(newValue)) {
            return this;
        }
        return new ImmutableHttpProxyConfig(this.host, this.port, this.username, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHttpProxyConfig && this.equalTo(0, (ImmutableHttpProxyConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableHttpProxyConfig another) {
        return this.host.equals(another.host) && Objects.equals(this.port, another.port) && this.username.equals(another.username) && this.encryptedPassword.equals(another.encryptedPassword) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.encryptedPassword.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HttpProxyConfig").omitNullValues().add("host", (Object)this.host).add("port", (Object)this.port).add("username", (Object)this.username).add("encryptedPassword", (Object)this.encryptedPassword).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableHttpProxyConfig fromJson(Json json) {
        Builder builder = ImmutableHttpProxyConfig.builder();
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.encryptedPassword != null) {
            builder.encryptedPassword(json.encryptedPassword);
        }
        return builder.build();
    }

    public static ImmutableHttpProxyConfig copyOf(HttpProxyConfig instance) {
        if (instance instanceof ImmutableHttpProxyConfig) {
            return (ImmutableHttpProxyConfig)instance;
        }
        return ImmutableHttpProxyConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HttpProxyConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String host;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable Integer port;
        @Nullable
        private String username;
        @Nullable
        private String encryptedPassword;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(HttpProxyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.host(instance.host());
            @org.checkerframework.checker.nullness.qual.Nullable Integer portValue = instance.port();
            if (portValue != null) {
                this.port(portValue);
            }
            this.username(instance.username());
            this.encryptedPassword(instance.encryptedPassword());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder port(@org.checkerframework.checker.nullness.qual.Nullable Integer port) {
            this.port = port;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder encryptedPassword(String encryptedPassword) {
            this.encryptedPassword = Objects.requireNonNull(encryptedPassword, "encryptedPassword");
            return this;
        }

        public ImmutableHttpProxyConfig build() {
            return new ImmutableHttpProxyConfig(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="HttpProxyConfig", generator="Immutables")
    static final class Json
    extends HttpProxyConfig {
        @Nullable
        String host;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable Integer port;
        @Nullable
        String username;
        @Nullable
        String encryptedPassword;

        Json() {
        }

        @JsonProperty(value="host")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setHost(String host) {
            this.host = host;
        }

        @JsonProperty(value="port")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setPort(@org.checkerframework.checker.nullness.qual.Nullable Integer port) {
            this.port = port;
        }

        @JsonProperty(value="username")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="encryptedPassword")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setEncryptedPassword(String encryptedPassword) {
            this.encryptedPassword = encryptedPassword;
        }

        @Override
        public String host() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable Integer port() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String username() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String encryptedPassword() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String version() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="HttpProxyConfig", generator="Immutables")
    private final class InitShim {
        private byte hostBuildStage = 0;
        private String host;
        private byte usernameBuildStage = 0;
        private String username;
        private byte encryptedPasswordBuildStage = 0;
        private String encryptedPassword;
        private byte versionBuildStage = 0;
        private String version;

        private InitShim() {
        }

        String host() {
            if (this.hostBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hostBuildStage == 0) {
                this.hostBuildStage = (byte)-1;
                this.host = Objects.requireNonNull(ImmutableHttpProxyConfig.super.host(), "host");
                this.hostBuildStage = 1;
            }
            return this.host;
        }

        void host(String host) {
            this.host = host;
            this.hostBuildStage = 1;
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableHttpProxyConfig.super.username(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        String encryptedPassword() {
            if (this.encryptedPasswordBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.encryptedPasswordBuildStage == 0) {
                this.encryptedPasswordBuildStage = (byte)-1;
                this.encryptedPassword = Objects.requireNonNull(ImmutableHttpProxyConfig.super.encryptedPassword(), "encryptedPassword");
                this.encryptedPasswordBuildStage = 1;
            }
            return this.encryptedPassword;
        }

        void encryptedPassword(String encryptedPassword) {
            this.encryptedPassword = encryptedPassword;
            this.encryptedPasswordBuildStage = 1;
        }

        String version() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = (byte)-1;
                this.version = Objects.requireNonNull(ImmutableHttpProxyConfig.super.version(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.hostBuildStage == -1) {
                attributes.add("host");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.encryptedPasswordBuildStage == -1) {
                attributes.add("encryptedPassword");
            }
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            return "Cannot build HttpProxyConfig, attribute initializers form cycle " + attributes;
        }
    }
}

