/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.glowroot.agent.embedded.shaded.javax.activation.CommandMap;
import org.glowroot.agent.embedded.shaded.javax.activation.DataContentHandler;
import org.glowroot.agent.embedded.shaded.javax.activation.DataContentHandlerFactory;
import org.glowroot.agent.embedded.shaded.javax.activation.DataHandlerDataSource;
import org.glowroot.agent.embedded.shaded.javax.activation.DataSource;
import org.glowroot.agent.embedded.shaded.javax.activation.DataSourceDataContentHandler;
import org.glowroot.agent.embedded.shaded.javax.activation.MimeType;
import org.glowroot.agent.embedded.shaded.javax.activation.MimeTypeParseException;
import org.glowroot.agent.embedded.shaded.javax.activation.ObjectDataContentHandler;
import org.glowroot.agent.embedded.shaded.javax.activation.UnsupportedDataTypeException;

public class DataHandler
implements Transferable {
    private DataSource dataSource = null;
    private DataSource objDataSource = null;
    private Object object = null;
    private String objectMimeType = null;
    private CommandMap currentCommandMap = null;
    private static final DataFlavor[] emptyFlavors = new DataFlavor[0];
    private DataFlavor[] transferFlavors = emptyFlavors;
    private DataContentHandler dataContentHandler = null;
    private DataContentHandler factoryDCH = null;
    private static DataContentHandlerFactory factory = null;
    private DataContentHandlerFactory oldFactory = null;
    private String shortType = null;

    public DataHandler(DataSource ds) {
        this.dataSource = ds;
        this.oldFactory = factory;
    }

    public DataHandler(Object obj, String mimeType) {
        this.object = obj;
        this.objectMimeType = mimeType;
        this.oldFactory = factory;
    }

    private synchronized CommandMap getCommandMap() {
        if (this.currentCommandMap != null) {
            return this.currentCommandMap;
        }
        return CommandMap.getDefaultCommandMap();
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            if (this.objDataSource == null) {
                this.objDataSource = new DataHandlerDataSource(this);
            }
            return this.objDataSource;
        }
        return this.dataSource;
    }

    public String getName() {
        if (this.dataSource != null) {
            return this.dataSource.getName();
        }
        return null;
    }

    public String getContentType() {
        if (this.dataSource != null) {
            return this.dataSource.getContentType();
        }
        return this.objectMimeType;
    }

    public InputStream getInputStream() throws IOException {
        InputStream ins = null;
        if (this.dataSource != null) {
            ins = this.dataSource.getInputStream();
        } else {
            DataContentHandler dch = this.getDataContentHandler();
            if (dch == null) {
                throw new UnsupportedDataTypeException("no DCH for MIME type " + this.getBaseType());
            }
            if (dch instanceof ObjectDataContentHandler && ((ObjectDataContentHandler)dch).getDCH() == null) {
                throw new UnsupportedDataTypeException("no object DCH for MIME type " + this.getBaseType());
            }
            final DataContentHandler fdch = dch;
            final PipedOutputStream pos = new PipedOutputStream();
            PipedInputStream pin = new PipedInputStream(pos);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        fdch.writeTo(DataHandler.this.object, DataHandler.this.objectMimeType, pos);
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            pos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }, "DataHandler.getInputStream").start();
            ins = pin;
        }
        return ins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream os) throws IOException {
        if (this.dataSource != null) {
            InputStream is = null;
            byte[] data = new byte[8192];
            is = this.dataSource.getInputStream();
            try {
                int bytes_read;
                while ((bytes_read = is.read(data)) > 0) {
                    os.write(data, 0, bytes_read);
                }
            }
            finally {
                is.close();
                is = null;
            }
        } else {
            DataContentHandler dch = this.getDataContentHandler();
            dch.writeTo(this.object, this.objectMimeType, os);
        }
    }

    public Object getContent() throws IOException {
        if (this.object != null) {
            return this.object;
        }
        return this.getDataContentHandler().getContent(this.getDataSource());
    }

    private synchronized DataContentHandler getDataContentHandler() {
        if (factory != this.oldFactory) {
            this.oldFactory = factory;
            this.factoryDCH = null;
            this.dataContentHandler = null;
            this.transferFlavors = emptyFlavors;
        }
        if (this.dataContentHandler != null) {
            return this.dataContentHandler;
        }
        String simpleMT = this.getBaseType();
        if (this.factoryDCH == null && factory != null) {
            this.factoryDCH = factory.createDataContentHandler(simpleMT);
        }
        if (this.factoryDCH != null) {
            this.dataContentHandler = this.factoryDCH;
        }
        if (this.dataContentHandler == null) {
            this.dataContentHandler = this.dataSource != null ? this.getCommandMap().createDataContentHandler(simpleMT, this.dataSource) : this.getCommandMap().createDataContentHandler(simpleMT);
        }
        this.dataContentHandler = this.dataSource != null ? new DataSourceDataContentHandler(this.dataContentHandler, this.dataSource) : new ObjectDataContentHandler(this.dataContentHandler, this.object, this.objectMimeType);
        return this.dataContentHandler;
    }

    private synchronized String getBaseType() {
        if (this.shortType == null) {
            String ct = this.getContentType();
            try {
                MimeType mt = new MimeType(ct);
                this.shortType = mt.getBaseType();
            }
            catch (MimeTypeParseException e) {
                this.shortType = ct;
            }
        }
        return this.shortType;
    }
}

