/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TransactionTypeRepository;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.ImmutableColumn;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.google.common.cache.Cache;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;

class TransactionTypeDao
implements TransactionTypeRepository {
    private static final ImmutableList<Schemas.Column> columns = ImmutableList.of((Object)ImmutableColumn.of("transaction_type", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("last_capture_time", Schemas.ColumnType.BIGINT));
    private final DataSource dataSource;
    private final Cache<String, Boolean> lastCaptureTimeUpdatedInThePastDay = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(10000L).build();
    private final Object lock = new Object();

    TransactionTypeDao(DataSource dataSource) throws Exception {
        this.dataSource = dataSource;
        dataSource.syncTable("transaction_types", (List<Schemas.Column>)columns);
    }

    @Override
    public CompletionStage<List<String>> read(String agentRollupId) {
        try {
            List<String> transactionTypes = this.dataSource.queryForStringList("select transaction_type from transaction_types order by transaction_type");
            if (transactionTypes == null) {
                return CompletableFuture.completedFuture(ImmutableList.of());
            }
            return CompletableFuture.completedFuture(transactionTypes);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastCaptureTime(String transactionType, long captureTime) throws Exception {
        if (this.lastCaptureTimeUpdatedInThePastDay.getIfPresent((Object)transactionType) != null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int updateCount = this.dataSource.update("update transaction_types set last_capture_time = ? where transaction_type = ?", captureTime, transactionType);
            if (updateCount == 0) {
                this.dataSource.update("insert into transaction_types (transaction_type, last_capture_time) values (?, ?)", transactionType, captureTime);
            }
        }
        this.lastCaptureTimeUpdatedInThePastDay.put((Object)transactionType, (Object)true);
    }

    void deleteBefore(long captureTime) throws SQLException {
        this.dataSource.deleteBeforeUsingLock("transaction_types", "last_capture_time", captureTime - TimeUnit.DAYS.toMillis(1L), this.lock);
    }

    void invalidateCache() {
        this.lastCaptureTimeUpdatedInThePastDay.invalidateAll();
    }
}

