/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.repo.AggregateDao;
import org.glowroot.agent.embedded.repo.AlertingDisabledDao;
import org.glowroot.agent.embedded.repo.ConfigRepositoryImpl;
import org.glowroot.agent.embedded.repo.EnvironmentDao;
import org.glowroot.agent.embedded.repo.FullQueryTextDao;
import org.glowroot.agent.embedded.repo.GaugeIdDao;
import org.glowroot.agent.embedded.repo.GaugeNameDao;
import org.glowroot.agent.embedded.repo.GaugeValueDao;
import org.glowroot.agent.embedded.repo.IncidentDao;
import org.glowroot.agent.embedded.repo.PlatformMBeanServerLifecycle;
import org.glowroot.agent.embedded.repo.ReaperRunnable;
import org.glowroot.agent.embedded.repo.RepoAdminImpl;
import org.glowroot.agent.embedded.repo.RollupCappedDatabaseStats;
import org.glowroot.agent.embedded.repo.SchemaUpgrade;
import org.glowroot.agent.embedded.repo.TraceAttributeNameDao;
import org.glowroot.agent.embedded.repo.TraceCappedDatabaseStats;
import org.glowroot.agent.embedded.repo.TraceDao;
import org.glowroot.agent.embedded.repo.TransactionTypeDao;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.EmbeddedStorageConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.RepoAdmin;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceAttributeNameRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TransactionTypeRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.AlertingService;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.HttpClient;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.LockSet;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.MailService;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.RollupLevelService;
import org.glowroot.agent.embedded.util.CappedDatabase;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.H2DatabaseStats;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class SimpleRepoModule {
    private static final Logger startupLogger = LoggerFactory.getLogger((String)"org.glowroot");
    private static final long SNAPSHOT_REAPER_PERIOD_MINUTES = 5L;
    private final DataSource dataSource;
    private final ImmutableList<CappedDatabase> rollupCappedDatabases;
    private final CappedDatabase traceCappedDatabase;
    private final AlertingDisabledDao alertingDisabledDao;
    private final EnvironmentDao environmentDao;
    private final TransactionTypeDao transactionTypeDao;
    private final AggregateDao aggregateDao;
    private final TraceAttributeNameDao traceAttributeNameDao;
    private final TraceDao traceDao;
    private final GaugeValueDao gaugeValueDao;
    private final IncidentDao incidentDao;
    private final ConfigRepositoryImpl configRepository;
    private final RepoAdmin repoAdmin;
    private final RollupLevelService rollupLevelService;
    private final AlertingService alertingService;
    private final HttpClient httpClient;
    private final @Nullable ReaperRunnable reaperRunnable;

    public SimpleRepoModule(DataSource dataSource, File dataDir, Clock clock, Ticker ticker, ConfigRepositoryImpl configRepository, @Nullable ScheduledExecutorService backgroundExecutor) throws Exception {
        if (!dataDir.exists() && !dataDir.mkdir()) {
            throw new IOException("Could not create directory: " + dataDir.getAbsolutePath());
        }
        this.dataSource = dataSource;
        this.configRepository = configRepository;
        EmbeddedStorageConfig storageConfig = configRepository.getEmbeddedStorageConfig();
        ArrayList rollupCappedDatabases = Lists.newArrayList();
        for (int i = 0; i < storageConfig.rollupCappedDatabaseSizesMb().size(); ++i) {
            File file = new File(dataDir, "rollup-" + i + "-detail.capped.db");
            int sizeKb = (Integer)storageConfig.rollupCappedDatabaseSizesMb().get(i) * 1024;
            rollupCappedDatabases.add(new CappedDatabase(file, sizeKb, backgroundExecutor, ticker));
        }
        this.rollupCappedDatabases = ImmutableList.copyOf((Collection)rollupCappedDatabases);
        this.traceCappedDatabase = new CappedDatabase(new File(dataDir, "trace-detail.capped.db"), storageConfig.traceCappedDatabaseSizeMb() * 1024, backgroundExecutor, ticker);
        SchemaUpgrade schemaUpgrade = new SchemaUpgrade(dataSource);
        Integer initialSchemaVersion = schemaUpgrade.getInitialSchemaVersion();
        if (initialSchemaVersion == null) {
            startupLogger.info("creating glowroot schema...");
        } else {
            schemaUpgrade.upgrade();
        }
        this.alertingDisabledDao = new AlertingDisabledDao(dataSource);
        this.environmentDao = new EnvironmentDao(dataSource);
        this.transactionTypeDao = new TransactionTypeDao(dataSource);
        this.rollupLevelService = new RollupLevelService(configRepository, clock);
        FullQueryTextDao fullQueryTextDao = new FullQueryTextDao(dataSource);
        this.aggregateDao = new AggregateDao(dataSource, (List<CappedDatabase>)this.rollupCappedDatabases, configRepository, this.transactionTypeDao, fullQueryTextDao);
        this.traceAttributeNameDao = new TraceAttributeNameDao(dataSource);
        this.traceDao = new TraceDao(dataSource, this.traceCappedDatabase, this.transactionTypeDao, fullQueryTextDao, this.traceAttributeNameDao);
        GaugeIdDao gaugeIdDao = new GaugeIdDao(dataSource);
        GaugeNameDao gaugeNameDao = new GaugeNameDao(dataSource);
        this.gaugeValueDao = new GaugeValueDao(dataSource, gaugeIdDao, gaugeNameDao, clock);
        this.incidentDao = new IncidentDao(dataSource);
        if (initialSchemaVersion == null) {
            schemaUpgrade.updateSchemaVersionToCurent();
            startupLogger.info("glowroot schema created");
        }
        this.repoAdmin = new RepoAdminImpl(dataSource, rollupCappedDatabases, this.traceCappedDatabase, configRepository, this.alertingDisabledDao, this.environmentDao, gaugeIdDao, gaugeNameDao, this.gaugeValueDao, this.transactionTypeDao, fullQueryTextDao, this.traceAttributeNameDao, clock);
        this.httpClient = new HttpClient(configRepository);
        this.alertingService = new AlertingService(configRepository, this.incidentDao, this.aggregateDao, this.gaugeValueDao, this.traceDao, this.rollupLevelService, new MailService(), this.httpClient, SimpleRepoModule.newLockSet(), SimpleRepoModule.newLockSet(), clock);
        if (backgroundExecutor == null) {
            this.reaperRunnable = null;
        } else {
            this.reaperRunnable = new ReaperRunnable(configRepository, this.aggregateDao, this.traceDao, gaugeIdDao, gaugeNameDao, this.gaugeValueDao, this.transactionTypeDao, fullQueryTextDao, this.incidentDao, clock);
            this.reaperRunnable.scheduleWithFixedDelay(backgroundExecutor, 0L, 5L, TimeUnit.MINUTES);
        }
    }

    public void registerMBeans(PlatformMBeanServerLifecycle platformMBeanServerLifecycle) {
        for (int i = 0; i < this.rollupCappedDatabases.size(); ++i) {
            platformMBeanServerLifecycle.lazyRegisterMBean(new RollupCappedDatabaseStats((CappedDatabase)this.rollupCappedDatabases.get(i)), "org.glowroot:type=RollupCappedDatabase" + i);
        }
        platformMBeanServerLifecycle.lazyRegisterMBean(new TraceCappedDatabaseStats(this.traceCappedDatabase), "org.glowroot:type=TraceCappedDatabase");
        platformMBeanServerLifecycle.lazyRegisterMBean(new H2DatabaseStats(this.dataSource), "org.glowroot:type=H2Database");
    }

    public AlertingDisabledDao getAlertingDisabledDao() {
        return this.alertingDisabledDao;
    }

    public EnvironmentDao getEnvironmentDao() {
        return this.environmentDao;
    }

    public TransactionTypeRepository getTransactionTypeRepository() {
        return this.transactionTypeDao;
    }

    public AggregateDao getAggregateDao() {
        return this.aggregateDao;
    }

    public TraceAttributeNameRepository getTraceAttributeNameRepository() {
        return this.traceAttributeNameDao;
    }

    public TraceDao getTraceDao() {
        return this.traceDao;
    }

    public GaugeValueDao getGaugeValueDao() {
        return this.gaugeValueDao;
    }

    public IncidentDao getIncidentDao() {
        return this.incidentDao;
    }

    public ConfigRepositoryImpl getConfigRepository() {
        return this.configRepository;
    }

    public RepoAdmin getRepoAdmin() {
        return this.repoAdmin;
    }

    public RollupLevelService getRollupLevelService() {
        return this.rollupLevelService;
    }

    public AlertingService getAlertingService() {
        return this.alertingService;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @OnlyUsedByTests
    public void close() throws Exception {
        if (this.reaperRunnable != null) {
            this.reaperRunnable.cancel();
        }
        this.alertingService.close();
        for (CappedDatabase cappedDatabase : this.rollupCappedDatabases) {
            cappedDatabase.close();
        }
        this.traceCappedDatabase.close();
        this.dataSource.close();
    }

    private static LockSet.LockSetImpl<AlertingService.IncidentKey> newLockSet() {
        return new LockSet.LockSetImpl<AlertingService.IncidentKey>(Maps.newConcurrentMap());
    }
}

