/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.ImmutableColumn;
import org.glowroot.agent.embedded.util.ImmutableIndex;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.google.common.cache.Cache;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;

class GaugeIdDao {
    private static final ImmutableList<Schemas.Column> columns = ImmutableList.of((Object)ImmutableColumn.of("gauge_id", Schemas.ColumnType.AUTO_IDENTITY), (Object)ImmutableColumn.of("gauge_name", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("last_capture_time", Schemas.ColumnType.BIGINT));
    private static final ImmutableList<Schemas.Index> indexes = ImmutableList.of((Object)ImmutableIndex.of("gauge_id_gauge_id_idx", (ImmutableList<String>)ImmutableList.of((Object)"gauge_id")), (Object)ImmutableIndex.of("gauge_id_gauge_name_idx", (ImmutableList<String>)ImmutableList.of((Object)"gauge_name")));
    private final DataSource dataSource;
    private final Cache<String, Long> lastCaptureTimeUpdatedInThePastDay = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(10000L).build();
    private final Object lock = new Object();

    GaugeIdDao(DataSource dataSource) throws Exception {
        this.dataSource = dataSource;
        if (dataSource.columnExists("gauge_name", "last_capture_time")) {
            dataSource.renameTable("gauge_name", "gauge_id");
            dataSource.renameColumn("gauge_id", "id", "gauge_id");
        }
        dataSource.syncTable("gauge_id", (List<Schemas.Column>)columns);
        dataSource.syncIndexes("gauge_id", indexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long updateLastCaptureTime(String gaugeName, long captureTime) throws SQLException {
        Long gaugeId = (Long)this.lastCaptureTimeUpdatedInThePastDay.getIfPresent((Object)gaugeName);
        if (gaugeId != null) {
            return gaugeId;
        }
        Object object = this.lock;
        synchronized (object) {
            gaugeId = this.dataSource.queryForOptionalLong("select gauge_id from gauge_id where gauge_name = ?", gaugeName);
            if (gaugeId == null) {
                this.dataSource.update("insert into gauge_id (gauge_name, last_capture_time) values (?, ?)", gaugeName, captureTime);
                gaugeId = this.dataSource.queryForOptionalLong("select gauge_id from gauge_id where gauge_name = ?", gaugeName);
                if (gaugeId == null) {
                    return -1L;
                }
            } else {
                this.dataSource.update("update gauge_id set last_capture_time = ? where gauge_id = ?", captureTime, gaugeId);
            }
        }
        this.lastCaptureTimeUpdatedInThePastDay.put((Object)gaugeName, (Object)gaugeId);
        return gaugeId;
    }

    @Nullable Long getGaugeId(String gaugeName) throws SQLException {
        Long gaugeId = (Long)this.lastCaptureTimeUpdatedInThePastDay.getIfPresent((Object)gaugeName);
        if (gaugeId != null) {
            return gaugeId;
        }
        return this.dataSource.queryForOptionalLong("select gauge_id from gauge_id where gauge_name = ?", gaugeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteBefore(long captureTime) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.dataSource.update("delete from gauge_id where last_capture_time < ?", captureTime - TimeUnit.DAYS.toMillis(1L));
        }
    }

    void invalidateCache() {
        this.lastCaptureTimeUpdatedInThePastDay.invalidateAll();
    }
}

