/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.EnvironmentRepository;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.ImmutableColumn;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;

public class EnvironmentDao
implements EnvironmentRepository {
    private static final ImmutableList<Schemas.Column> columns = ImmutableList.of((Object)ImmutableColumn.of("environment", Schemas.ColumnType.VARBINARY));
    private final DataSource dataSource;

    EnvironmentDao(DataSource dataSource) throws Exception {
        this.dataSource = dataSource;
        dataSource.renameColumn("agent", "system_info", "environment");
        dataSource.renameTable("agent", "environment");
        dataSource.syncTable("environment", (List<Schemas.Column>)columns);
        EnvironmentDao.init(dataSource);
    }

    public void store(CollectorServiceOuterClass.InitMessage.Environment environment) throws SQLException {
        this.dataSource.update(new EnvironmentBinder(environment));
    }

    @Override
    public CompletionStage<CollectorServiceOuterClass.InitMessage.Environment> read(String agentId, CassandraProfile profile) {
        try {
            return CompletableFuture.completedFuture(this.dataSource.queryAtMostOne(new EnvironmentRowMapper()));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    void reinitAfterDeletingDatabase() throws Exception {
        EnvironmentDao.init(this.dataSource);
    }

    private static void init(DataSource dataSource) throws SQLException {
        long rowCount = dataSource.queryForLong("select count(*) from environment", new Object[0]);
        if (rowCount == 0L) {
            dataSource.execute("insert into environment (environment) values (null)");
        } else {
            Preconditions.checkState((rowCount == 1L ? 1 : 0) != 0);
        }
    }

    private static class EnvironmentRowMapper
    implements DataSource.JdbcRowQuery<CollectorServiceOuterClass.InitMessage.Environment> {
        private EnvironmentRowMapper() {
        }

        @Override
        public @Untainted String getSql() {
            return "select environment from environment where environment is not null";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) {
        }

        @Override
        public CollectorServiceOuterClass.InitMessage.Environment mapRow(ResultSet resultSet) throws Exception {
            byte[] bytes = resultSet.getBytes(1);
            Preconditions.checkNotNull((Object)bytes);
            return CollectorServiceOuterClass.InitMessage.Environment.parseFrom((byte[])bytes);
        }
    }

    private static class EnvironmentBinder
    implements DataSource.JdbcUpdate {
        private final CollectorServiceOuterClass.InitMessage.Environment environment;

        private EnvironmentBinder(CollectorServiceOuterClass.InitMessage.Environment environment) {
            this.environment = environment;
        }

        @Override
        public @Untainted String getSql() {
            return "update environment set environment = ?";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.setBytes(1, this.environment.toByteArray());
        }
    }
}

