/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.init;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

class PreInitializeStorageShutdownClasses {
    private static final Logger logger = LoggerFactory.getLogger(PreInitializeStorageShutdownClasses.class);

    private PreInitializeStorageShutdownClasses() {
    }

    static void preInitializeClasses() {
        ClassLoader loader = PreInitializeStorageShutdownClasses.class.getClassLoader();
        for (String type : PreInitializeStorageShutdownClasses.usedTypes()) {
            PreInitializeStorageShutdownClasses.initialize(type, loader, true);
        }
        for (String type : PreInitializeStorageShutdownClasses.maybeUsedTypes()) {
            PreInitializeStorageShutdownClasses.initialize(type, loader, false);
        }
        for (String type : PreInitializeStorageShutdownClasses.javaUsedTypes()) {
            PreInitializeStorageShutdownClasses.initialize(type, loader, true);
        }
    }

    private static void initialize(String type, @Nullable ClassLoader loader, boolean warnOnNotExists) {
        if (type.equals("org.glowroot.agent.embedded.shaded.org.h2.value.ValueGeometry")) {
            return;
        }
        try {
            Class.forName(type, true, loader);
        }
        catch (ClassNotFoundException e) {
            if (warnOnNotExists) {
                logger.warn("class not found: {}", (Object)type);
            }
            logger.trace(e.getMessage(), (Throwable)e);
        }
    }

    @VisibleForTesting
    static List<String> usedTypes() {
        ArrayList types = Lists.newArrayList();
        types.addAll(PreInitializeStorageShutdownClasses.getGlowrootUsedTypes());
        types.addAll(PreInitializeStorageShutdownClasses.getH2UsedTypes());
        types.addAll(PreInitializeStorageShutdownClasses.getGuavaUsedTypes());
        types.addAll(PreInitializeStorageShutdownClasses.javaUsedTypes());
        return types;
    }

    private static List<String> getGlowrootUsedTypes() {
        ArrayList types = Lists.newArrayList();
        types.add("org.glowroot.agent.embedded.util.CappedDatabase");
        types.add("org.glowroot.agent.embedded.util.CappedDatabase$ShutdownHookThread");
        types.add("org.glowroot.agent.embedded.util.CappedDatabaseOutputStream");
        types.add("org.glowroot.agent.embedded.util.CappedDatabaseOutputStream$FsyncRunnable");
        types.add("org.glowroot.agent.embedded.util.DataSource");
        types.add("org.glowroot.agent.embedded.util.DataSource$ShutdownHookThread");
        types.add("org.glowroot.agent.util.JavaVersion");
        types.add("org.glowroot.agent.shaded.org.glowroot.common.util.Cancellable");
        types.add("org.glowroot.agent.shaded.org.glowroot.common.util.ScheduledRunnable");
        types.add("org.glowroot.agent.shaded.org.glowroot.common.util.ScheduledRunnable$TerminateSubsequentExecutionsException");
        return types;
    }

    private static List<String> getH2UsedTypes() {
        ArrayList types = Lists.newArrayList();
        types.add("org.glowroot.agent.embedded.shaded.org.h2.api.ErrorCode");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.api.JavaObjectSerializer");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.command.CommandInterface");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.engine.Constants");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.engine.SessionInterface");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.engine.SysProperties");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.jdbc.JdbcConnection");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.jdbc.JdbcSQLException");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.message.DbException");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.message.Trace");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.message.TraceObject");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.message.TraceSystem");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.message.TraceWriter");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.store.fs.FilePath");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.store.fs.FileUtils");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.util.CloseWatcher");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.util.IOUtils");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.util.MathUtils");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.util.New");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.util.SortedProperties");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.util.StringUtils");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.util.Utils");
        types.add("org.glowroot.agent.embedded.shaded.org.h2.util.Utils$ClassFactory");
        return types;
    }

    private static List<String> getGuavaUsedTypes() {
        ArrayList types = Lists.newArrayList();
        types.add("org.glowroot.agent.shaded.com.google.common.base.StandardSystemProperty");
        types.add("org.glowroot.agent.shaded.com.google.common.base.Ticker");
        types.add("org.glowroot.agent.shaded.com.google.common.base.Ticker$1");
        return types;
    }

    @VisibleForTesting
    static List<String> maybeUsedTypes() {
        ArrayList types = Lists.newArrayList();
        types.add("org.glowroot.agent.shaded.org.glowroot.common.Reflections$1");
        types.add("org.glowroot.core.weaving.AnalyzedClass$1");
        types.add("org.glowroot.core.weaving.Weaver$1");
        types.add("org.glowroot.core.weaving.WeavingMethodVisitor$1");
        types.add("org.glowroot.core.weaving.AdviceMatcher$1");
        types.add("java.sql.Driver");
        types.add("org.glowroot.agent.embedded.sql.DriverManager$1");
        types.add("org.glowroot.agent.embedded.sql.DriverManager$2");
        types.add("org.glowroot.agent.embedded.sql.SQLException$1");
        return types;
    }

    private static List<String> javaUsedTypes() {
        ArrayList types = Lists.newArrayList();
        types.add("java.sql.Connection");
        types.add("org.glowroot.agent.embedded.sql.DriverManager");
        types.add("org.glowroot.agent.embedded.sql.SQLException");
        types.add("java.sql.SQLPermission");
        types.add("java.sql.SQLWarning");
        types.add("java.sql.Statement");
        types.add("java.sql.Wrapper");
        return types;
    }
}

